/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.secure.totp;

import cn.dev33.satoken.exception.TotpAuthException;
import cn.dev33.satoken.secure.SaBase32Util;
import cn.dev33.satoken.util.StrFormatter;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.time.Instant;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SaTotpTemplate {
    public int timeStep = 30;
    public int codeDigits = 6;
    public String hmacAlgorithm = "HmacSHA1";
    public int secretKeyLength = 16;

    public SaTotpTemplate() {
    }

    public SaTotpTemplate(int timeStep, int codeDigits, String hmacAlgorithm, int secretKeyLength) {
        this.timeStep = timeStep;
        this.codeDigits = codeDigits;
        this.hmacAlgorithm = hmacAlgorithm;
        this.secretKeyLength = secretKeyLength;
    }

    public String generateSecretKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[this.secretKeyLength];
        random.nextBytes(bytes);
        return SaBase32Util.encodeBytesToString(bytes).replace("=", "");
    }

    public String _generateTOTP(String secretKey) {
        return this._generateTOTP(secretKey, Instant.now().getEpochSecond());
    }

    public boolean validateTOTP(String secretKey, String code, int timeWindowOffset) {
        long currentWindow = Instant.now().getEpochSecond() / (long)this.timeStep;
        for (int i = -timeWindowOffset; i <= timeWindowOffset; ++i) {
            String calculatedCode = this._generateTOTP(secretKey, (currentWindow + (long)i) * (long)this.timeStep);
            if (!calculatedCode.equals(code)) continue;
            return true;
        }
        return false;
    }

    public void checkTOTP(String secretKey, String code, int timeWindowOffset) {
        if (!this.validateTOTP(secretKey, code, timeWindowOffset)) {
            throw new TotpAuthException();
        }
    }

    public String generateGoogleSecretKey(String account) {
        return this.generateGoogleSecretKey(account, this.generateSecretKey());
    }

    public String generateGoogleSecretKey(String account, String secretKey) {
        return StrFormatter.format("otpauth://totp/{}?secret={}", account, secretKey);
    }

    protected String _generateTOTP(String secretKey, long time) {
        byte[] keyBytes = SaBase32Util.decodeStringToBytes(secretKey);
        byte[] counterBytes = ByteBuffer.allocate(8).putLong(time / (long)this.timeStep).array();
        try {
            Mac hmac = Mac.getInstance(this.hmacAlgorithm);
            hmac.init(new SecretKeySpec(keyBytes, this.hmacAlgorithm));
            byte[] hash = hmac.doFinal(counterBytes);
            int offset = hash[hash.length - 1] & 0xF;
            int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
            int otp = binary % (int)Math.pow(10.0, this.codeDigits);
            return String.format("%0" + this.codeDigits + "d", otp);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("TOTP\u751f\u6210\u5931\u8d25", e);
        }
    }
}

