/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.session;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.application.SaSetValueInterface;
import cn.dev33.satoken.listener.SaTokenEventCenter;
import cn.dev33.satoken.session.TokenSign;
import cn.dev33.satoken.util.SaFoxUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class SaSession
implements SaSetValueInterface,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String USER = "USER";
    public static final String ROLE_LIST = "ROLE_LIST";
    public static final String PERMISSION_LIST = "PERMISSION_LIST";
    private String id;
    private long createTime;
    private final Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    private List<TokenSign> tokenSignList = new Vector<TokenSign>();

    public SaSession() {
    }

    public SaSession(String id) {
        this.id = id;
        this.createTime = System.currentTimeMillis();
        SaTokenEventCenter.doCreateSession(id);
    }

    public String getId() {
        return this.id;
    }

    public SaSession setId(String id) {
        this.id = id;
        return this;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public SaSession setCreateTime(long createTime) {
        this.createTime = createTime;
        return this;
    }

    public void setTokenSignList(List<TokenSign> tokenSignList) {
        this.tokenSignList = tokenSignList;
    }

    public List<TokenSign> getTokenSignList() {
        return this.tokenSignList;
    }

    public List<TokenSign> tokenSignListCopy() {
        return new ArrayList<TokenSign>(this.tokenSignList);
    }

    public List<TokenSign> tokenSignListCopyByDevice(String device) {
        if (device == null) {
            return this.tokenSignListCopy();
        }
        ArrayList<TokenSign> list = new ArrayList<TokenSign>();
        for (TokenSign tokenSign : this.tokenSignListCopy()) {
            if (!SaFoxUtil.equals(tokenSign.getDevice(), device)) continue;
            list.add(tokenSign);
        }
        return list;
    }

    public TokenSign getTokenSign(String tokenValue) {
        for (TokenSign tokenSign : this.tokenSignListCopy()) {
            if (!SaFoxUtil.equals(tokenSign.getValue(), tokenValue)) continue;
            return tokenSign;
        }
        return null;
    }

    public void addTokenSign(TokenSign tokenSign) {
        if (this.getTokenSign(tokenSign.getValue()) != null) {
            return;
        }
        this.tokenSignList.add(tokenSign);
        this.update();
    }

    public void addTokenSign(String tokenValue, String device) {
        this.addTokenSign(new TokenSign(tokenValue, device));
    }

    public void removeTokenSign(String tokenValue) {
        TokenSign tokenSign = this.getTokenSign(tokenValue);
        if (this.tokenSignList.remove(tokenSign)) {
            this.update();
        }
    }

    public void update() {
        SaManager.getSaTokenDao().updateSession(this);
    }

    public void logout() {
        SaManager.getSaTokenDao().deleteSession(this.id);
        SaTokenEventCenter.doLogoutSession(this.id);
    }

    public void logoutByTokenSignCountToZero() {
        if (this.tokenSignList.size() == 0) {
            this.logout();
        }
    }

    public long getTimeout() {
        return SaManager.getSaTokenDao().getSessionTimeout(this.id);
    }

    public void updateTimeout(long timeout) {
        SaManager.getSaTokenDao().updateSessionTimeout(this.id, timeout);
    }

    public void updateMinTimeout(long minTimeout) {
        long min = this.trans(minTimeout);
        long curr = this.trans(this.getTimeout());
        if (curr < min) {
            this.updateTimeout(minTimeout);
        }
    }

    public void updateMaxTimeout(long maxTimeout) {
        long max = this.trans(maxTimeout);
        long curr = this.trans(this.getTimeout());
        if (curr > max) {
            this.updateTimeout(maxTimeout);
        }
    }

    protected long trans(long value) {
        return value == -1L ? Long.MAX_VALUE : value;
    }

    @Override
    public Object get(String key) {
        return this.dataMap.get(key);
    }

    @Override
    public SaSession set(String key, Object value) {
        this.dataMap.put(key, value);
        this.update();
        return this;
    }

    @Override
    public SaSession setByNull(String key, Object value) {
        if (!this.has(key)) {
            this.dataMap.put(key, value);
            this.update();
        }
        return this;
    }

    @Override
    public SaSession delete(String key) {
        this.dataMap.remove(key);
        this.update();
        return this;
    }

    public Set<String> keys() {
        return this.dataMap.keySet();
    }

    public void clear() {
        this.dataMap.clear();
        this.update();
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public void refreshDataMap(Map<String, Object> dataMap) {
        this.dataMap.clear();
        this.dataMap.putAll(dataMap);
        this.update();
    }
}

