/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.listener;

import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.listener.SaTokenListener;
import cn.dev33.satoken.listener.SaTokenListenerForConsolePrint;
import cn.dev33.satoken.stp.SaLoginModel;
import java.util.ArrayList;
import java.util.List;

public class SaTokenEventCenter {
    private static List<SaTokenListener> listenerList = new ArrayList<SaTokenListener>();

    public static List<SaTokenListener> getListenerList() {
        return listenerList;
    }

    public static void setListenerList(List<SaTokenListener> listenerList) {
        if (listenerList == null) {
            throw new SaTokenException("\u91cd\u7f6e\u7684\u4fa6\u542c\u5668\u96c6\u5408\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        SaTokenEventCenter.listenerList = listenerList;
    }

    public static void registerListener(SaTokenListener listener) {
        if (listener == null) {
            throw new SaTokenException("\u6ce8\u518c\u7684\u4fa6\u542c\u5668\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        listenerList.add(listener);
    }

    public static void registerListenerList(List<SaTokenListener> listenerList) {
        if (listenerList == null) {
            throw new SaTokenException("\u6ce8\u518c\u7684\u4fa6\u542c\u5668\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        for (SaTokenListener listener : listenerList) {
            if (listener != null) continue;
            throw new SaTokenException("\u6ce8\u518c\u7684\u4fa6\u542c\u5668\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        SaTokenEventCenter.listenerList.addAll(listenerList);
    }

    public static void removeListener(SaTokenListener listener) {
        listenerList.remove(listener);
    }

    public static void removeListener(Class<? extends SaTokenListener> cls) {
        ArrayList<SaTokenListener> listenerListCopy = new ArrayList<SaTokenListener>(listenerList);
        for (SaTokenListener listener : listenerListCopy) {
            if (!cls.isAssignableFrom(listener.getClass())) continue;
            listenerList.remove(listener);
        }
    }

    public static void clearListener() {
        listenerList.clear();
    }

    public static boolean hasListener(SaTokenListener listener) {
        return listenerList.contains(listener);
    }

    public static boolean hasListener(Class<? extends SaTokenListener> cls) {
        for (SaTokenListener listener : listenerList) {
            if (!cls.isAssignableFrom(listener.getClass())) continue;
            return true;
        }
        return false;
    }

    public static void doLogin(String loginType, Object loginId, String tokenValue, SaLoginModel loginModel) {
        for (SaTokenListener listener : listenerList) {
            listener.doLogin(loginType, loginId, tokenValue, loginModel);
        }
    }

    public static void doLogout(String loginType, Object loginId, String tokenValue) {
        for (SaTokenListener listener : listenerList) {
            listener.doLogout(loginType, loginId, tokenValue);
        }
    }

    public static void doKickout(String loginType, Object loginId, String tokenValue) {
        for (SaTokenListener listener : listenerList) {
            listener.doKickout(loginType, loginId, tokenValue);
        }
    }

    public static void doReplaced(String loginType, Object loginId, String tokenValue) {
        for (SaTokenListener listener : listenerList) {
            listener.doReplaced(loginType, loginId, tokenValue);
        }
    }

    public static void doDisable(String loginType, Object loginId, String service, int level, long disableTime) {
        for (SaTokenListener listener : listenerList) {
            listener.doDisable(loginType, loginId, service, level, disableTime);
        }
    }

    public static void doUntieDisable(String loginType, Object loginId, String service) {
        for (SaTokenListener listener : listenerList) {
            listener.doUntieDisable(loginType, loginId, service);
        }
    }

    public static void doCreateSession(String id) {
        for (SaTokenListener listener : listenerList) {
            listener.doCreateSession(id);
        }
    }

    public static void doLogoutSession(String id) {
        for (SaTokenListener listener : listenerList) {
            listener.doLogoutSession(id);
        }
    }

    public static void doRenewTimeout(String tokenValue, Object loginId, long timeout) {
        for (SaTokenListener listener : listenerList) {
            listener.doRenewTimeout(tokenValue, loginId, timeout);
        }
    }

    static {
        listenerList.add(new SaTokenListenerForConsolePrint());
    }
}

