/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.session;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.session.TokenSign;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class SaSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private long createTime;
    private Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();
    private List<TokenSign> tokenSignList = new Vector<TokenSign>();

    public SaSession() {
    }

    public SaSession(String id) {
        this.id = id;
        this.createTime = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public List<TokenSign> getTokenSignList() {
        return new Vector<TokenSign>(this.tokenSignList);
    }

    public TokenSign getTokenSign(String tokenValue) {
        for (TokenSign tokenSign : this.getTokenSignList()) {
            if (!tokenSign.getValue().equals(tokenValue)) continue;
            return tokenSign;
        }
        return null;
    }

    public void addTokenSign(TokenSign tokenSign) {
        for (TokenSign tokenSign2 : this.getTokenSignList()) {
            if (!tokenSign2.getValue().equals(tokenSign.getValue())) continue;
            return;
        }
        this.tokenSignList.add(tokenSign);
        this.update();
    }

    public void removeTokenSign(String tokenValue) {
        TokenSign tokenSign = this.getTokenSign(tokenValue);
        if (this.tokenSignList.remove(tokenSign)) {
            this.update();
        }
    }

    public void setAttribute(String key, Object value) {
        this.dataMap.put(key, value);
        this.update();
    }

    public Object getAttribute(String key) {
        return this.dataMap.get(key);
    }

    public Object getAttribute(String key, Object defaultValue) {
        Object value = this.getAttribute(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void removeAttribute(String key) {
        this.dataMap.remove(key);
        this.update();
    }

    public void clearAttribute() {
        this.dataMap.clear();
        this.update();
    }

    public boolean containsAttribute(String key) {
        return this.dataMap.keySet().contains(key);
    }

    public Set<String> attributeKeys() {
        return this.dataMap.keySet();
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public void update() {
        SaTokenManager.getSaTokenDao().updateSession(this);
    }

    public void logout() {
        SaTokenManager.getSaTokenDao().deleteSession(this.id);
    }

    public void logoutByTokenSignCountToZero() {
        if (this.tokenSignList.size() == 0) {
            this.logout();
        }
    }
}

