/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.cookie;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SaTokenCookieUtil {
    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static void addCookie(HttpServletResponse response, String name, String value, String path, int timeout) {
        Cookie cookie = new Cookie(name, value);
        if (path == null) {
            path = "/";
        }
        cookie.setPath(path);
        cookie.setMaxAge(timeout);
        response.addCookie(cookie);
    }

    public static void delCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !name.equals(cookie.getName())) continue;
                SaTokenCookieUtil.addCookie(response, name, null, null, 0);
                return;
            }
        }
    }

    public static void updateCookie(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !name.equals(cookie.getName())) continue;
                SaTokenCookieUtil.addCookie(response, name, value, cookie.getPath(), cookie.getMaxAge());
                return;
            }
        }
    }
}

