/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.spring.boot.config;

import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.extension.query.AssembleDbAnnotationHandler;
import cn.crane4j.extension.query.DataSourceProvider;
import cn.crane4j.spring.boot.config.Crane4jAutoConfiguration;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={Crane4jAutoConfiguration.class, DataSourceAutoConfiguration.class})
@ConditionalOnClass(value={AssembleDbAnnotationHandler.class})
public class Crane4jDataSourceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Crane4jDataSourceAutoConfiguration.class);

    @ConditionalOnMissingBean(value={AssembleDbAnnotationHandler.class})
    @ConditionalOnBean(value={DataSource.class})
    @Bean
    public AssembleDbAnnotationHandler assembleDbAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, MethodInvokerContainerCreator methodInvokerContainerCreator, Map<String, DataSource> dataSourceMap) {
        log.info("enable datasource for @AssembleDb annotation: {}", (Object)String.join((CharSequence)", ", dataSourceMap.keySet()));
        DataSourceProvider dataSourceProvider = dataSourceMap.size() == 1 ? DataSourceProvider.of((DataSource)dataSourceMap.values().iterator().next()) : DataSourceProvider.of(dataSourceMap);
        return new AssembleDbAnnotationHandler(annotationFinder, globalConfiguration, methodInvokerContainerCreator, dataSourceProvider);
    }
}

