/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.spring.boot.config;

import cn.crane4j.core.cache.AbstractMapCacheManager;
import cn.crane4j.core.cache.CacheDefinition;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.cache.GuavaCacheManager;
import cn.crane4j.core.condition.ConditionOnContainerParser;
import cn.crane4j.core.condition.ConditionOnExpressionParser;
import cn.crane4j.core.condition.ConditionOnPropertyNotEmptyParser;
import cn.crane4j.core.condition.ConditionOnPropertyNotNullParser;
import cn.crane4j.core.condition.ConditionOnPropertyParser;
import cn.crane4j.core.condition.ConditionOnTargetTypeParser;
import cn.crane4j.core.condition.ConditionParser;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.container.lifecycle.ContainerInstanceLifecycleProcessor;
import cn.crane4j.core.container.lifecycle.ContainerRegisterLogger;
import cn.crane4j.core.executor.AsyncBeanOperationExecutor;
import cn.crane4j.core.executor.AsyncBeanOperationRecursiveExecutor;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.DisorderedBeanOperationExecutor;
import cn.crane4j.core.executor.DisorderedBeanOperationRecursiveExecutor;
import cn.crane4j.core.executor.OrderedBeanOperationExecutor;
import cn.crane4j.core.executor.OrderedBeanOperationRecursiveExecutor;
import cn.crane4j.core.executor.handler.ManyToManyAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToManyAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToOneAssembleOperationHandler;
import cn.crane4j.core.executor.handler.ReflectiveDisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.ConditionalTypeHierarchyBeanOperationParser;
import cn.crane4j.core.parser.handler.AssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleEnumAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleKeyAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleMethodAnnotationHandler;
import cn.crane4j.core.parser.handler.DisassembleAnnotationHandler;
import cn.crane4j.core.parser.handler.OperationAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.CollJoinAsStringMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.OverwriteMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.OverwriteNotNullMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.parser.handler.strategy.ReferenceMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.SimplePropertyMappingStrategyManager;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.ContainerAdapterRegister;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jTemplate;
import cn.crane4j.core.support.DefaultContainerAdapterRegister;
import cn.crane4j.core.support.OperateTemplate;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.SimpleTypeResolver;
import cn.crane4j.core.support.Sorted;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.aop.AutoOperateProxy;
import cn.crane4j.core.support.aop.MethodArgumentAutoOperateSupport;
import cn.crane4j.core.support.aop.MethodResultAutoOperateSupport;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.auto.ClassBasedAutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.auto.ComposableAutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.auto.MethodBasedAutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.container.CacheableMethodContainerFactory;
import cn.crane4j.core.support.container.ContainerMethodAnnotationProcessor;
import cn.crane4j.core.support.container.DefaultMethodContainerFactory;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.support.expression.MethodBasedExpressionEvaluator;
import cn.crane4j.core.support.operator.ArgAutoOperateProxyMethodFactory;
import cn.crane4j.core.support.operator.DynamicContainerOperatorProxyMethodFactory;
import cn.crane4j.core.support.operator.OperationAnnotationProxyMethodFactory;
import cn.crane4j.core.support.operator.OperatorProxyFactory;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.support.operator.ParametersFillProxyMethodFactory;
import cn.crane4j.core.support.proxy.DefaultProxyFactory;
import cn.crane4j.core.support.proxy.ProxyFactory;
import cn.crane4j.core.support.reflect.AsmReflectivePropertyOperator;
import cn.crane4j.core.support.reflect.CacheablePropertyOperator;
import cn.crane4j.core.support.reflect.ChainAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.MapAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.PropertyOperatorHolder;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.core.util.StringUtils;
import cn.crane4j.extension.spring.BeanAwareAssembleMethodAnnotationHandler;
import cn.crane4j.extension.spring.BeanMethodContainerRegistrar;
import cn.crane4j.extension.spring.Crane4jApplicationContext;
import cn.crane4j.extension.spring.MergedAnnotationFinder;
import cn.crane4j.extension.spring.NamedComponentAliasProcessor;
import cn.crane4j.extension.spring.SoftConcurrentMapCacheManager;
import cn.crane4j.extension.spring.SpringCacheableContainerProcessor;
import cn.crane4j.extension.spring.SpringConverterManager;
import cn.crane4j.extension.spring.SpringParameterNameFinder;
import cn.crane4j.extension.spring.ValueResolveAssembleAnnotationHandler;
import cn.crane4j.extension.spring.aop.MethodArgumentAutoOperateAdvisor;
import cn.crane4j.extension.spring.aop.MethodResultAutoOperateAdvisor;
import cn.crane4j.extension.spring.expression.SpelExpressionContext;
import cn.crane4j.extension.spring.expression.SpelExpressionEvaluator;
import cn.crane4j.extension.spring.scanner.ClassScanner;
import cn.crane4j.extension.spring.scanner.ScannedContainerRegistrar;
import cn.crane4j.extension.spring.util.ContainerResolveUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Role;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringValueResolver;

@AutoConfiguration
@EnableConfigurationProperties(value={Properties.class})
public class Crane4jAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Crane4jAutoConfiguration.class);
    public static final String CRANE_PREFIX = "crane4j";

    @Bean
    public NamedComponentAliasProcessor namedComponentAliasProcessor() {
        return new NamedComponentAliasProcessor();
    }

    @ConditionalOnMissingBean(value={ClassScanner.class})
    @Bean
    public ClassScanner classScanner() {
        return ClassScanner.INSTANCE;
    }

    @ConditionalOnBean(value={ConversionService.class})
    @ConditionalOnMissingBean(value={ConverterManager.class})
    @Bean
    public SpringConverterManager springConverterManager(ConversionService conversionService) {
        return new SpringConverterManager(conversionService);
    }

    @ConditionalOnMissingBean(value={ConversionService.class, ConverterManager.class})
    @Bean
    public SpringConverterManager newSpringConverterManager() {
        log.info("No ConversionService or ConverterManager bean found, use default ConversionService.");
        return new SpringConverterManager(DefaultConversionService.getSharedInstance());
    }

    @Primary
    @ConditionalOnMissingBean
    @Bean
    public Crane4jApplicationContext crane4jApplicationContext(ApplicationContext applicationContext, Properties properties) {
        Crane4jApplicationContext context = new Crane4jApplicationContext(applicationContext);
        context.setAllowContainerOverriding(properties.isAllowContainerOverriding());
        return context;
    }

    @ConditionalOnMissingBean
    @Bean
    public ScannedContainerRegistrar scannedContainerRegister() {
        return new ScannedContainerRegistrar();
    }

    @Bean
    public PropertyOperator propertyOperator(Properties properties, ConverterManager converterManager) {
        ReflectivePropertyOperator operator = properties.isEnableAsmReflect() && System.getProperty("java.version").contains("1.8") ? new AsmReflectivePropertyOperator(converterManager) : new ReflectivePropertyOperator(converterManager);
        operator = new CacheablePropertyOperator((PropertyOperator)operator);
        if (properties.isEnableMapOperate()) {
            operator = new MapAccessiblePropertyOperator((PropertyOperator)operator);
        }
        if (properties.isEnableChainOperate()) {
            operator = new ChainAccessiblePropertyOperator((PropertyOperator)operator);
        }
        return new PropertyOperatorHolder((PropertyOperator)operator);
    }

    @ConditionalOnMissingBean(value={AnnotationFinder.class})
    @Bean
    public MergedAnnotationFinder mergedAnnotationFinder() {
        return new MergedAnnotationFinder();
    }

    @ConditionalOnMissingBean(value={TypeResolver.class})
    @Bean
    public SimpleTypeResolver simpleTypeResolver() {
        return new SimpleTypeResolver();
    }

    @ConditionalOnMissingBean(value={ExpressionEvaluator.class})
    @Bean
    public SpelExpressionEvaluator spelExpressionEvaluator() {
        return new SpelExpressionEvaluator((ExpressionParser)new SpelExpressionParser());
    }

    @Primary
    @ConditionalOnMissingBean(value={AbstractMapCacheManager.class})
    @Bean
    public AbstractMapCacheManager mapCacheManager() {
        return AbstractMapCacheManager.newWeakConcurrentMapCacheManager();
    }

    @ConditionalOnMissingBean(value={GuavaCacheManager.class})
    @Bean
    public GuavaCacheManager guavaCacheManager() {
        return new GuavaCacheManager();
    }

    @ConditionalOnMissingBean
    @Bean
    public SoftConcurrentMapCacheManager softConcurrentMapCacheManager() {
        return new SoftConcurrentMapCacheManager();
    }

    @Order(value=0)
    @Bean
    public ContainerInstanceLifecycleProcessor containerInstanceLifecycleProcessor() {
        return new ContainerInstanceLifecycleProcessor();
    }

    @Order(value=1)
    @Bean
    public ContainerRegisterLogger containerRegisterLogger() {
        Logger logger = LoggerFactory.getLogger(ContainerRegisterLogger.class);
        return new ContainerRegisterLogger((arg_0, arg_1) -> ((Logger)logger).debug(arg_0, arg_1));
    }

    @Order(value=2)
    @ConditionalOnMissingBean
    @Bean
    public SpringCacheableContainerProcessor springCacheableContainerProcessor(Crane4jApplicationContext configuration, Properties properties) {
        SpringCacheableContainerProcessor processor = new SpringCacheableContainerProcessor(configuration);
        Map definitions = properties.getCaches().stream().collect(Collectors.toMap(CacheDefinition::getName, Function.identity()));
        processor.setCacheDefinitionRetriever((d, c) -> (CacheDefinition)definitions.get(c.getNamespace()));
        return processor;
    }

    @ConditionalOnMissingBean
    @Bean
    public OperateTemplate operateTemplate(BeanOperationParser parser, BeanOperationExecutor executor, TypeResolver typeResolver) {
        return new OperateTemplate(parser, executor, typeResolver);
    }

    @ConditionalOnMissingBean(value={ParameterNameFinder.class})
    @Bean
    public SpringParameterNameFinder springParameterNameFinder() {
        return new SpringParameterNameFinder((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
    }

    @Bean
    public DefaultContainerAdapterRegister defaultContainerAdapterRegister() {
        return DefaultContainerAdapterRegister.INSTANCE;
    }

    @ConditionalOnMissingBean(value={MethodBasedAutoOperateAnnotatedElementResolver.class})
    @Bean
    public MethodBasedAutoOperateAnnotatedElementResolver methodBasedAutoOperateAnnotatedElementResolver(Crane4jGlobalConfiguration crane4jGlobalConfiguration, TypeResolver typeResolver) {
        return new MethodBasedAutoOperateAnnotatedElementResolver(crane4jGlobalConfiguration, typeResolver);
    }

    @ConditionalOnMissingBean(value={ClassBasedAutoOperateAnnotatedElementResolver.class})
    @Bean
    public ClassBasedAutoOperateAnnotatedElementResolver classBasedAutoOperateAnnotatedElementResolver(Crane4jGlobalConfiguration crane4jGlobalConfiguration, ExpressionEvaluator expressionEvaluator) {
        return new ClassBasedAutoOperateAnnotatedElementResolver(crane4jGlobalConfiguration, expressionEvaluator, SpelExpressionContext::new);
    }

    @Primary
    @Bean
    public ComposableAutoOperateAnnotatedElementResolver composableAutoOperateAnnotatedElementResolver(Collection<AutoOperateAnnotatedElementResolver> autoOperateAnnotatedElementResolvers) {
        return new ComposableAutoOperateAnnotatedElementResolver(new ArrayList<AutoOperateAnnotatedElementResolver>(autoOperateAnnotatedElementResolvers));
    }

    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="crane4j", name={"enable-method-container"}, havingValue="true", matchIfMissing=true)
    @Bean
    public BeanMethodContainerRegistrar beanMethodContainerPostProcessor(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration) {
        return new BeanMethodContainerRegistrar(annotationFinder, configuration);
    }

    @ConditionalOnMissingBean
    @Bean
    public Crane4jInitializer crane4jInitializer(ClassScanner classScanner, PropertyOperator propertyOperator, ApplicationContext applicationContext, AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration, Properties properties) {
        return new Crane4jInitializer(propertyOperator, applicationContext, properties, annotationFinder, configuration, classScanner);
    }

    @Bean
    @ConditionalOnMissingBean
    public Crane4jTemplate crane4jService(Crane4jGlobalConfiguration configuration, AnnotationFinder annotationFinder, PropertyOperator propertyOperator, OperateTemplate operateTemplate, OperatorProxyFactory operatorProxyFactory, ContainerMethodAnnotationProcessor containerMethodAnnotationProcessor, @Nullable AutoOperateProxy autoOperateProxy) {
        return Crane4jTemplate.builder().configuration(configuration).annotationFinder(annotationFinder).propertyOperator(propertyOperator).autoOperateProxy(Optional.ofNullable(autoOperateProxy).orElseGet(() -> ConfigurationUtil.createAutoOperateProxy((Crane4jGlobalConfiguration)configuration))).operateTemplate(operateTemplate).operatorProxyFactory(operatorProxyFactory).containerMethodAnnotationProcessor(containerMethodAnnotationProcessor).build();
    }

    @ConditionalOnMissingBean
    @Bean
    public SimplePropertyMappingStrategyManager simplePropertyMappingStrategyManager(Collection<PropertyMappingStrategy> propertyMappingStrategies) {
        SimplePropertyMappingStrategyManager manager = new SimplePropertyMappingStrategyManager();
        propertyMappingStrategies.forEach(arg_0 -> ((SimplePropertyMappingStrategyManager)manager).addPropertyMappingStrategy(arg_0));
        return manager;
    }

    @Bean
    public CollJoinAsStringMappingStrategy joinAsStringMappingStrategy() {
        return CollJoinAsStringMappingStrategy.INSTANCE;
    }

    @Bean
    public OverwriteNotNullMappingStrategy overwriteNotNullMappingStrategy() {
        return OverwriteNotNullMappingStrategy.INSTANCE;
    }

    @Bean
    public OverwriteMappingStrategy overwriteMappingStrategy() {
        return OverwriteMappingStrategy.INSTANCE;
    }

    @Bean
    public ReferenceMappingStrategy referenceMappingStrategy(PropertyOperator propertyOperator) {
        return new ReferenceMappingStrategy(propertyOperator);
    }

    @ConditionalOnMissingBean(value={BeanResolver.class})
    @Bean
    public BeanFactoryResolver beanFactoryResolver(ApplicationContext applicationContext) {
        return new BeanFactoryResolver((BeanFactory)applicationContext);
    }

    @ConditionalOnMissingBean(value={AssembleAnnotationHandler.class})
    @Bean
    public ValueResolveAssembleAnnotationHandler valueResolveAssembleAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration, ExpressionEvaluator evaluator, BeanResolver beanResolver, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        return new ValueResolveAssembleAnnotationHandler(annotationFinder, configuration, evaluator, beanResolver, propertyMappingStrategyManager);
    }

    @ConditionalOnMissingBean(value={AssembleMethodAnnotationHandler.class})
    @Bean
    public BeanAwareAssembleMethodAnnotationHandler beanAwareAssembleMethodAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, PropertyMappingStrategyManager propertyMappingStrategyManager, Collection<MethodContainerFactory> methodContainerFactories, ApplicationContext applicationContext) {
        return new BeanAwareAssembleMethodAnnotationHandler(annotationFinder, globalConfiguration, methodContainerFactories, applicationContext, propertyMappingStrategyManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AssembleEnumAnnotationHandler assembleEnumAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, PropertyOperator propertyOperator, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        return new AssembleEnumAnnotationHandler(annotationFinder, globalConfiguration, propertyOperator, propertyMappingStrategyManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AssembleKeyAnnotationHandler assembleKeyAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration, PropertyMappingStrategyManager propertyMappingStrategyManager, @Nullable Map<String, AssembleKeyAnnotationHandler.ValueMapperProvider> providers) {
        AssembleKeyAnnotationHandler handler = new AssembleKeyAnnotationHandler(annotationFinder, configuration, propertyMappingStrategyManager);
        if (CollectionUtils.isNotEmpty(providers)) {
            providers.forEach((arg_0, arg_1) -> ((AssembleKeyAnnotationHandler)handler).registerValueMapperProvider(arg_0, arg_1));
        }
        return handler;
    }

    @ConditionalOnMissingBean
    @Bean
    public DisassembleAnnotationHandler disassembleAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration) {
        return new DisassembleAnnotationHandler(annotationFinder, configuration);
    }

    @ConditionalOnBean(value={ExpressionEvaluator.class})
    @ConditionalOnMissingBean
    @Bean
    public ConditionOnExpressionParser conditionOnExpressionParser(AnnotationFinder annotationFinder, ExpressionEvaluator expressionEvaluator, BeanFactoryResolver beanFactoryResolver) {
        ConditionOnExpressionParser.ContextFactory contextFactory = (t, op) -> {
            SpelExpressionContext context = new SpelExpressionContext();
            context.setBeanResolver((BeanResolver)beanFactoryResolver);
            return context;
        };
        return new ConditionOnExpressionParser(annotationFinder, expressionEvaluator, contextFactory);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConditionOnPropertyNotNullParser conditionOnPropertyNotNullParser(AnnotationFinder annotationFinder, PropertyOperator propertyOperator) {
        return new ConditionOnPropertyNotNullParser(annotationFinder, propertyOperator);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConditionOnPropertyNotEmptyParser conditionOnPropertyNotEmptyParser(AnnotationFinder annotationFinder, PropertyOperator propertyOperator) {
        return new ConditionOnPropertyNotEmptyParser(annotationFinder, propertyOperator);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConditionOnPropertyParser conditionOnPropertyParser(AnnotationFinder annotationFinder, PropertyOperator propertyOperator, ConverterManager converterManager) {
        return new ConditionOnPropertyParser(annotationFinder, propertyOperator, converterManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConditionOnContainerParser conditionOnContainerParser(AnnotationFinder annotationFinder, ContainerManager containerManager) {
        return new ConditionOnContainerParser(annotationFinder, containerManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConditionOnTargetTypeParser conditionOnTargetTypeParser(AnnotationFinder annotationFinder) {
        return new ConditionOnTargetTypeParser(annotationFinder);
    }

    @ConditionalOnMissingBean
    @Bean
    public ConditionalTypeHierarchyBeanOperationParser conditionalTypeHierarchyBeanOperationParser(Collection<OperationAnnotationHandler> handlers, Collection<ConditionParser> parsers) {
        ConditionalTypeHierarchyBeanOperationParser parser = new ConditionalTypeHierarchyBeanOperationParser();
        handlers.forEach(arg_0 -> ((ConditionalTypeHierarchyBeanOperationParser)parser).addOperationAnnotationHandler(arg_0));
        parsers.forEach(arg_0 -> ((ConditionalTypeHierarchyBeanOperationParser)parser).registerConditionParser(arg_0));
        return parser;
    }

    @Primary
    @ConditionalOnMissingBean
    @Bean
    public DisorderedBeanOperationExecutor disorderedBeanOperationExecutor(ContainerManager containerManager) {
        return new DisorderedBeanOperationExecutor(containerManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public DisorderedBeanOperationRecursiveExecutor disorderedBeanOperationRecursiveExecutor(ContainerManager containerManager) {
        return new DisorderedBeanOperationRecursiveExecutor(containerManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public AsyncBeanOperationExecutor asyncBeanOperationExecutor(ContainerManager containerManager) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        int processors = Runtime.getRuntime().availableProcessors();
        executor.setCorePoolSize(processors);
        executor.setMaxPoolSize(processors);
        executor.setQueueCapacity(1);
        executor.setThreadNamePrefix("crane4j-async-executor");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setAllowCoreThreadTimeOut(true);
        executor.initialize();
        return new AsyncBeanOperationExecutor(containerManager, (Executor)executor);
    }

    @ConditionalOnMissingBean
    @Bean
    public AsyncBeanOperationRecursiveExecutor asyncBeanOperationRecursiveExecutor(ContainerManager containerManager) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        int processors = Runtime.getRuntime().availableProcessors();
        executor.setCorePoolSize(processors);
        executor.setMaxPoolSize(processors);
        executor.setQueueCapacity(1);
        executor.setThreadNamePrefix("crane4j-async-executor");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.setAllowCoreThreadTimeOut(true);
        executor.initialize();
        return new AsyncBeanOperationRecursiveExecutor(containerManager, (Executor)executor);
    }

    @ConditionalOnMissingBean
    @Bean
    public OrderedBeanOperationExecutor orderedBeanOperationExecutor(ContainerManager containerManager) {
        return new OrderedBeanOperationExecutor(containerManager, Comparator.comparing(Sorted::getSort));
    }

    @ConditionalOnMissingBean
    @Bean
    public OrderedBeanOperationRecursiveExecutor orderedBeanOperationRecursiveExecutor(ContainerManager containerManager) {
        return new OrderedBeanOperationRecursiveExecutor(containerManager, Comparator.comparing(Sorted::getSort));
    }

    @ConditionalOnMissingBean
    @Bean
    public MethodInvokerContainerCreator methodInvokerContainerCreator(PropertyOperator propertyOperator, ConverterManager converterManager) {
        return new MethodInvokerContainerCreator(propertyOperator, converterManager);
    }

    @Order
    @ConditionalOnMissingBean(value={CacheManager.class})
    @Bean
    public DefaultMethodContainerFactory defaultMethodContainerFactory(MethodInvokerContainerCreator methodInvokerContainerCreator, AnnotationFinder annotationFinder) {
        return new DefaultMethodContainerFactory(methodInvokerContainerCreator, annotationFinder);
    }

    @Order(value=0x7FFFFFFE)
    @ConditionalOnBean(value={CacheManager.class})
    @Bean
    public CacheableMethodContainerFactory cacheableMethodContainerFactory(Crane4jGlobalConfiguration configuration, MethodInvokerContainerCreator methodInvokerContainerCreator, AnnotationFinder annotationFinder) {
        return new CacheableMethodContainerFactory(methodInvokerContainerCreator, annotationFinder, configuration);
    }

    @Primary
    @Bean
    public OneToOneAssembleOperationHandler oneToOneAssembleOperationHandler(PropertyOperator propertyOperator, ConverterManager converterManager, Properties properties) {
        OneToOneAssembleOperationHandler handler = new OneToOneAssembleOperationHandler(propertyOperator, converterManager);
        handler.setIgnoreNullKey(properties.isIgnoreNullKeyWhenAssembling());
        return handler;
    }

    @Bean
    public ManyToManyAssembleOperationHandler manyToManyAssembleOperationHandler(PropertyOperator propertyOperator, ConverterManager converterManager) {
        return new ManyToManyAssembleOperationHandler(propertyOperator, converterManager);
    }

    @Bean
    public OneToManyAssembleOperationHandler oneToManyAssembleOperationHandler(PropertyOperator propertyOperator, ConverterManager converterManager) {
        return new OneToManyAssembleOperationHandler(propertyOperator, converterManager);
    }

    @Primary
    @ConditionalOnMissingBean
    @Bean
    public ReflectiveDisassembleOperationHandler reflectiveDisassembleOperationHandler(PropertyOperator propertyOperator) {
        return new ReflectiveDisassembleOperationHandler(propertyOperator);
    }

    @ConditionalOnMissingBean
    @Bean
    public DefaultProxyFactory defaultProxyFactory() {
        return DefaultProxyFactory.INSTANCE;
    }

    @Lazy
    @ConditionalOnMissingBean(value={OperatorProxyMethodFactory.class})
    @Bean
    public OperatorProxyFactory operatorProxyFactory(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration, ProxyFactory proxyFactory, Collection<OperatorProxyMethodFactory> factories) {
        OperatorProxyFactory factory = OperatorProxyFactory.builder().globalConfiguration(configuration).annotationFinder(annotationFinder).proxyFactory(proxyFactory).build();
        factories.forEach(arg_0 -> ((OperatorProxyFactory)factory).addProxyMethodFactory(arg_0));
        return factory;
    }

    @ConditionalOnBean(value={OperatorProxyFactory.class})
    @ConditionalOnMissingBean
    @Bean
    public OperationAnnotationProxyMethodFactory operationAnnotationProxyMethodFactory(ConverterManager converterManager) {
        return new OperationAnnotationProxyMethodFactory(converterManager);
    }

    @ConditionalOnBean(value={OperatorProxyFactory.class})
    @ConditionalOnMissingBean
    @Order
    @Bean
    public DynamicContainerOperatorProxyMethodFactory dynamicContainerOperatorProxyMethodFactory(ConverterManager converterManager, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder, ContainerAdapterRegister containerAdapterRegister) {
        return new DynamicContainerOperatorProxyMethodFactory(converterManager, parameterNameFinder, annotationFinder, containerAdapterRegister);
    }

    @ConditionalOnBean(value={OperatorProxyFactory.class})
    @ConditionalOnMissingBean
    @Order
    @Bean
    public ParametersFillProxyMethodFactory parametersFillProxyMethodFactory(BeanOperationParser beanOperationParser) {
        return new ParametersFillProxyMethodFactory(beanOperationParser);
    }

    @ConditionalOnBean(value={OperatorProxyFactory.class})
    @ConditionalOnMissingBean
    @Order
    @Bean
    public ArgAutoOperateProxyMethodFactory argAutoOperateProxyMethodFactory(AutoOperateAnnotatedElementResolver elementResolver, MethodBasedExpressionEvaluator expressionExecuteDelegate, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder) {
        return new ArgAutoOperateProxyMethodFactory(elementResolver, expressionExecuteDelegate, parameterNameFinder, annotationFinder);
    }

    @ConditionalOnMissingBean
    @Bean
    public MethodBasedExpressionEvaluator methodBaseExpressionEvaluator(ExpressionEvaluator expressionEvaluator, ParameterNameFinder parameterNameFinder, BeanResolver beanResolver) {
        return new MethodBasedExpressionEvaluator(parameterNameFinder, expressionEvaluator, method -> {
            SpelExpressionContext context = new SpelExpressionContext(method);
            context.setBeanResolver(beanResolver);
            return context;
        });
    }

    @ConditionalOnMissingBean
    @Bean
    public MethodResultAutoOperateSupport methodResultAutoOperateSupport(AutoOperateAnnotatedElementResolver autoOperateAnnotatedElementResolver, MethodBasedExpressionEvaluator methodBasedExpressionEvaluator, AnnotationFinder annotationFinder) {
        return new MethodResultAutoOperateSupport(autoOperateAnnotatedElementResolver, methodBasedExpressionEvaluator, annotationFinder);
    }

    @Role(value=2)
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="crane4j", name={"enable-method-result-auto-operate"}, havingValue="true", matchIfMissing=true)
    @Bean
    public MethodResultAutoOperateAdvisor methodResultAutoOperateAdvisor(ObjectProvider<MethodResultAutoOperateSupport> methodResultAutoOperateSupport) {
        return new MethodResultAutoOperateAdvisor(methodResultAutoOperateSupport);
    }

    @ConditionalOnMissingBean
    @Bean
    public MethodArgumentAutoOperateSupport methodArgumentAutoOperateSupport(MethodBasedExpressionEvaluator methodBasedExpressionEvaluator, AutoOperateAnnotatedElementResolver autoOperateAnnotatedElementResolver, ParameterNameFinder parameterNameDiscoverer, AnnotationFinder annotationFinder) {
        return new MethodArgumentAutoOperateSupport(autoOperateAnnotatedElementResolver, methodBasedExpressionEvaluator, parameterNameDiscoverer, annotationFinder);
    }

    @Role(value=2)
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="crane4j", name={"enable-method-argument-auto-operate"}, havingValue="true", matchIfMissing=true)
    @Bean
    public MethodArgumentAutoOperateAdvisor methodArgumentAutoOperateAdvisor(ObjectProvider<MethodArgumentAutoOperateSupport> methodArgumentAutoOperateSupport) {
        return new MethodArgumentAutoOperateAdvisor(methodArgumentAutoOperateSupport);
    }

    @ConditionalOnMissingBean
    @Bean
    public ProxyFactory proxyFactory() {
        return DefaultProxyFactory.INSTANCE;
    }

    @ConditionalOnMissingBean
    @Bean
    public AutoOperateProxy autoOperateProxy(MethodArgumentAutoOperateSupport methodArgumentAutoOperateSupport, MethodResultAutoOperateSupport methodResultAutoOperateSupport, AnnotationFinder annotationFinder, ProxyFactory proxyFactory) {
        return new AutoOperateProxy(methodArgumentAutoOperateSupport, methodResultAutoOperateSupport, annotationFinder, proxyFactory);
    }

    public static class Crane4jInitializer
    implements Ordered,
    ApplicationRunner,
    EmbeddedValueResolverAware {
        private static final Logger log = LoggerFactory.getLogger(Crane4jInitializer.class);
        public static final int CRANE4J_INITIALIZER_ORDER = 0;
        private final PropertyOperator propertyOperator;
        private final ApplicationContext applicationContext;
        private final Properties properties;
        private final AnnotationFinder annotationFinder;
        private final Crane4jGlobalConfiguration configuration;
        private final ClassScanner classScanner;
        private StringValueResolver embeddedValueResolver;

        public int getOrder() {
            return 0;
        }

        public void run(ApplicationArguments args) {
            this.loadContainerEnum();
            this.loadConstantClass();
            this.loadOperateEntity();
            log.info("crane4j component initialization completed.");
        }

        private void loadConstantClass() {
            ContainerResolveUtils.loadConstantClass(this.loadTypes(this.properties.getContainerConstantPackages()), (ContainerManager)this.configuration, (AnnotationFinder)this.annotationFinder);
        }

        private void loadContainerEnum() {
            ContainerResolveUtils.loadContainerEnum(this.loadTypes(this.properties.getContainerEnumPackages()), (boolean)this.properties.isOnlyLoadAnnotatedEnum(), (ContainerManager)this.configuration, (AnnotationFinder)this.annotationFinder, (PropertyOperator)this.propertyOperator);
        }

        private void loadOperateEntity() {
            this.loadTypes(this.properties.getOperateEntityPackages()).forEach(type -> this.applicationContext.getBeansOfType(BeanOperationParser.class).values().forEach(parser -> parser.parse((AnnotatedElement)type)));
        }

        private Set<Class<?>> loadTypes(Collection<String> packages) {
            return packages.stream().map(arg_0 -> ((StringValueResolver)this.embeddedValueResolver).resolveStringValue(arg_0)).filter(StringUtils::isNotEmpty).map(xva$0 -> this.classScanner.scan(new String[]{xva$0})).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        public Crane4jInitializer(PropertyOperator propertyOperator, ApplicationContext applicationContext, Properties properties, AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration, ClassScanner classScanner) {
            this.propertyOperator = propertyOperator;
            this.applicationContext = applicationContext;
            this.properties = properties;
            this.annotationFinder = annotationFinder;
            this.configuration = configuration;
            this.classScanner = classScanner;
        }

        public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
            this.embeddedValueResolver = embeddedValueResolver;
        }
    }

    @ConfigurationProperties(prefix="crane4j")
    public static class Properties {
        private boolean enableMapOperate = true;
        private boolean enableChainOperate = true;
        private boolean enableAsmReflect = false;
        private Set<String> containerEnumPackages = new LinkedHashSet<String>();
        private boolean onlyLoadAnnotatedEnum = false;
        private boolean ignoreNullKeyWhenAssembling = true;
        private Set<String> containerConstantPackages = new LinkedHashSet<String>();
        private Set<String> operateEntityPackages = new LinkedHashSet<String>();
        private boolean enableMethodArgumentAutoOperate = true;
        private boolean enableMethodResultAutoOperate = true;
        private boolean enableMethodContainer = true;
        private boolean allowContainerOverriding = false;
        private List<ContainerCacheProperties> caches = new ArrayList<ContainerCacheProperties>();

        public boolean isEnableMapOperate() {
            return this.enableMapOperate;
        }

        public boolean isEnableChainOperate() {
            return this.enableChainOperate;
        }

        public boolean isEnableAsmReflect() {
            return this.enableAsmReflect;
        }

        public Set<String> getContainerEnumPackages() {
            return this.containerEnumPackages;
        }

        public boolean isOnlyLoadAnnotatedEnum() {
            return this.onlyLoadAnnotatedEnum;
        }

        public boolean isIgnoreNullKeyWhenAssembling() {
            return this.ignoreNullKeyWhenAssembling;
        }

        public Set<String> getContainerConstantPackages() {
            return this.containerConstantPackages;
        }

        public Set<String> getOperateEntityPackages() {
            return this.operateEntityPackages;
        }

        public boolean isEnableMethodArgumentAutoOperate() {
            return this.enableMethodArgumentAutoOperate;
        }

        public boolean isEnableMethodResultAutoOperate() {
            return this.enableMethodResultAutoOperate;
        }

        public boolean isEnableMethodContainer() {
            return this.enableMethodContainer;
        }

        public boolean isAllowContainerOverriding() {
            return this.allowContainerOverriding;
        }

        public List<ContainerCacheProperties> getCaches() {
            return this.caches;
        }

        public Properties setEnableMapOperate(boolean enableMapOperate) {
            this.enableMapOperate = enableMapOperate;
            return this;
        }

        public Properties setEnableChainOperate(boolean enableChainOperate) {
            this.enableChainOperate = enableChainOperate;
            return this;
        }

        public Properties setEnableAsmReflect(boolean enableAsmReflect) {
            this.enableAsmReflect = enableAsmReflect;
            return this;
        }

        public Properties setContainerEnumPackages(Set<String> containerEnumPackages) {
            this.containerEnumPackages = containerEnumPackages;
            return this;
        }

        public Properties setOnlyLoadAnnotatedEnum(boolean onlyLoadAnnotatedEnum) {
            this.onlyLoadAnnotatedEnum = onlyLoadAnnotatedEnum;
            return this;
        }

        public Properties setIgnoreNullKeyWhenAssembling(boolean ignoreNullKeyWhenAssembling) {
            this.ignoreNullKeyWhenAssembling = ignoreNullKeyWhenAssembling;
            return this;
        }

        public Properties setContainerConstantPackages(Set<String> containerConstantPackages) {
            this.containerConstantPackages = containerConstantPackages;
            return this;
        }

        public Properties setOperateEntityPackages(Set<String> operateEntityPackages) {
            this.operateEntityPackages = operateEntityPackages;
            return this;
        }

        public Properties setEnableMethodArgumentAutoOperate(boolean enableMethodArgumentAutoOperate) {
            this.enableMethodArgumentAutoOperate = enableMethodArgumentAutoOperate;
            return this;
        }

        public Properties setEnableMethodResultAutoOperate(boolean enableMethodResultAutoOperate) {
            this.enableMethodResultAutoOperate = enableMethodResultAutoOperate;
            return this;
        }

        public Properties setEnableMethodContainer(boolean enableMethodContainer) {
            this.enableMethodContainer = enableMethodContainer;
            return this;
        }

        public Properties setAllowContainerOverriding(boolean allowContainerOverriding) {
            this.allowContainerOverriding = allowContainerOverriding;
            return this;
        }

        public Properties setCaches(List<ContainerCacheProperties> caches) {
            this.caches = caches;
            return this;
        }

        public static class ContainerCacheProperties
        implements CacheDefinition {
            private String namespace;
            private String cacheManager;
            private Long expireTime;
            private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

            public String getName() {
                return this.namespace;
            }

            public String getNamespace() {
                return this.namespace;
            }

            public String getCacheManager() {
                return this.cacheManager;
            }

            public Long getExpireTime() {
                return this.expireTime;
            }

            public TimeUnit getTimeUnit() {
                return this.timeUnit;
            }

            public ContainerCacheProperties setNamespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public ContainerCacheProperties setCacheManager(String cacheManager) {
                this.cacheManager = cacheManager;
                return this;
            }

            public ContainerCacheProperties setExpireTime(Long expireTime) {
                this.expireTime = expireTime;
                return this;
            }

            public ContainerCacheProperties setTimeUnit(TimeUnit timeUnit) {
                this.timeUnit = timeUnit;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ContainerCacheProperties)) {
                    return false;
                }
                ContainerCacheProperties other = (ContainerCacheProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expireTime = this.getExpireTime();
                Long other$expireTime = other.getExpireTime();
                if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
                    return false;
                }
                String this$namespace = this.getNamespace();
                String other$namespace = other.getNamespace();
                if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                    return false;
                }
                String this$cacheManager = this.getCacheManager();
                String other$cacheManager = other.getCacheManager();
                if (this$cacheManager == null ? other$cacheManager != null : !this$cacheManager.equals(other$cacheManager)) {
                    return false;
                }
                TimeUnit this$timeUnit = this.getTimeUnit();
                TimeUnit other$timeUnit = other.getTimeUnit();
                return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ContainerCacheProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expireTime = this.getExpireTime();
                result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
                String $namespace = this.getNamespace();
                result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
                String $cacheManager = this.getCacheManager();
                result = result * 59 + ($cacheManager == null ? 43 : $cacheManager.hashCode());
                TimeUnit $timeUnit = this.getTimeUnit();
                result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
                return result;
            }

            public String toString() {
                return "Crane4jAutoConfiguration.Properties.ContainerCacheProperties(namespace=" + this.getNamespace() + ", cacheManager=" + this.getCacheManager() + ", expireTime=" + this.getExpireTime() + ", timeUnit=" + (Object)((Object)this.getTimeUnit()) + ")";
            }
        }
    }
}

