/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.aop;

import cn.crane4j.annotation.ArgAutoOperate;
import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.aop.MethodArgumentAutoOperateSupport;
import cn.crane4j.extension.spring.aop.AutoOperatePointcut;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class MethodArgumentAutoOperateAdvisor
implements PointcutAdvisor,
MethodInterceptor,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MethodArgumentAutoOperateAdvisor.class);
    private final ObjectProvider<MethodArgumentAutoOperateSupport> methodArgumentAutoOperateSupport;
    private final Pointcut pointcut = AutoOperatePointcut.forAnnotatedMethod((m, c) -> m.getParameterCount() > 0 && (AnnotatedElementUtils.isAnnotated((AnnotatedElement)m, ArgAutoOperate.class) || Arrays.stream(m.getParameters()).anyMatch(p -> p.isAnnotationPresent(AutoOperate.class))));

    public void destroy() {
        this.methodArgumentAutoOperateSupport.ifAvailable(MethodArgumentAutoOperateSupport::destroy);
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        try {
            ((MethodArgumentAutoOperateSupport)this.methodArgumentAutoOperateSupport.getObject()).beforeMethodInvoke(method, methodInvocation.getArguments());
        }
        catch (Exception ex) {
            log.error("cannot auto operate input arguments for method [{}]", (Object)method, (Object)ex);
        }
        return methodInvocation.proceed();
    }

    public @NonNull Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return false;
    }

    public ObjectProvider<MethodArgumentAutoOperateSupport> getMethodArgumentAutoOperateSupport() {
        return this.methodArgumentAutoOperateSupport;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public MethodArgumentAutoOperateAdvisor(ObjectProvider<MethodArgumentAutoOperateSupport> methodArgumentAutoOperateSupport) {
        this.methodArgumentAutoOperateSupport = methodArgumentAutoOperateSupport;
    }
}

