/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.core.support.NamedComponent;
import cn.crane4j.core.util.Asserts;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class NamedComponentAliasProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(NamedComponentAliasProcessor.class);
    private ConfigurableListableBeanFactory configurableListableBeanFactory;

    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        String name;
        if (bean instanceof NamedComponent && !this.configurableListableBeanFactory.containsBean(name = ((NamedComponent)bean).getName())) {
            this.configurableListableBeanFactory.registerAlias(beanName, name);
            log.debug("Register named component alias: {} -> {}", (Object)name, (Object)beanName);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
        Asserts.isTrue((boolean)(beanFactory instanceof ConfigurableListableBeanFactory), (String)"The bean factory must be an instance of ConfigurableListableBeanFactory", (Object[])new Object[0]);
        this.configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }
}

