/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CollectionUtils {
    public static <T> List<Collection<T>> split(Collection<T> list, int size) {
        return CollectionUtils.split(list, size, ls -> ls);
    }

    public static <T, C extends Collection<T>> List<C> split(Collection<T> list, int size, Function<List<T>, C> mapper) {
        int listSize;
        if (size <= 0) {
            throw new IllegalArgumentException("size must be greater than 0");
        }
        if (Objects.isNull(list) || (listSize = list.size()) == 0) {
            return Collections.emptyList();
        }
        if (listSize == size) {
            return Collections.singletonList(mapper.apply(new ArrayList<T>(list)));
        }
        ArrayList<C> result = new ArrayList<C>();
        ArrayList<T> subList = new ArrayList<T>(size);
        for (T t : list) {
            subList.add(t);
            if (subList.size() != size) continue;
            result.add(mapper.apply(subList));
            subList = new ArrayList(size);
        }
        if (!subList.isEmpty()) {
            result.add(mapper.apply(subList));
        }
        return result;
    }

    public static <T> T getFirstNotNull(Iterator<T> iterator) {
        if (Objects.isNull(iterator)) {
            return null;
        }
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!Objects.nonNull(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T getFirstNotNull(Iterable<T> iterable) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        return CollectionUtils.getFirstNotNull(iterable.iterator());
    }

    public static <K, V> Map<V, K> reverse(Map<K, V> map) {
        if (CollectionUtils.isEmpty(map)) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static <T, C extends Collection<T>> C defaultIfEmpty(C collection, C defaultCollection) {
        return CollectionUtils.isEmpty(collection) ? defaultCollection : collection;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollectionUtils.isEmpty(coll1) || CollectionUtils.isEmpty(coll2)) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object obj : coll1) {
                if (!coll2.contains(obj)) continue;
                return true;
            }
            return false;
        }
        for (Object obj : coll2) {
            if (!coll1.contains(obj)) continue;
            return true;
        }
        return false;
    }

    public static boolean notContainsAny(Collection<?> coll1, Collection<?> coll2) {
        return !CollectionUtils.containsAny(coll1, coll2);
    }

    public static <T> T get(Collection<T> collection, int index) {
        if (Objects.isNull(collection)) {
            return null;
        }
        if (collection instanceof List) {
            if (index < 0 || index >= collection.size()) {
                return null;
            }
            return (T)((List)collection).get(index);
        }
        return CollectionUtils.get(collection.iterator(), index);
    }

    public static <T> T get(Iterable<T> iterable, int index) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        return CollectionUtils.get(iterable.iterator(), index);
    }

    public static <T> T get(Iterator<T> iterable, int index) {
        if (Objects.isNull(iterable)) {
            return null;
        }
        int i = 0;
        while (iterable.hasNext()) {
            T next = iterable.next();
            if (i == index) {
                return next;
            }
            ++i;
        }
        return null;
    }

    public static <T, C extends Collection<T>> @NonNull C addAll(C collection, T ... elements) {
        if (Objects.isNull(collection)) {
            return (C)Collections.emptyList();
        }
        if (Objects.isNull(elements) || elements.length == 0) {
            return collection;
        }
        collection.addAll(Arrays.asList(elements));
        return collection;
    }

    public static <T, C extends Collection<T>> @NonNull C addAll(C collection, Collection<T> elements) {
        if (Objects.isNull(collection)) {
            return (C)Collections.emptyList();
        }
        if (Objects.isNull(elements) || elements.isEmpty()) {
            return collection;
        }
        collection.addAll(elements);
        return collection;
    }

    @SafeVarargs
    public static <T, C extends Collection<T>> C newCollection(Supplier<C> collectionFactory, T ... elements) {
        Collection collection = (Collection)collectionFactory.get();
        Objects.requireNonNull(collection, "the collection obtained from the collection factory cannot be null");
        if (Objects.isNull(elements) || elements.length == 0) {
            return (C)collection;
        }
        collection.addAll(Arrays.asList(elements));
        return (C)collection;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return iterator == null || !iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return !CollectionUtils.isEmpty(iterator);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return iterable == null || CollectionUtils.isEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return !CollectionUtils.isEmpty(iterable);
    }

    public static <K, V> ConcurrentMap<K, V> newWeakConcurrentMap() {
        return new MapMaker().concurrencyLevel(Runtime.getRuntime().availableProcessors()).weakKeys().weakValues().makeMap();
    }

    public static Collection<?> adaptObjectToCollection(Object obj) {
        if (Objects.isNull(obj)) {
            return Collections.emptyList();
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj.getClass().isArray()) {
            return Arrays.asList((Object[])obj);
        }
        if (obj instanceof Iterable) {
            List results = CollectionUtils.newCollection(ArrayList::new, new Object[0]);
            ((Iterable)obj).forEach(results::add);
            return results;
        }
        if (obj instanceof Iterator) {
            List results = CollectionUtils.newCollection(ArrayList::new, new Object[0]);
            ((Iterator)obj).forEachRemaining(results::add);
            return results;
        }
        return Collections.singletonList(obj);
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V value = map.get(key);
        if (null == value) {
            map.putIfAbsent(key, mappingFunction.apply(key));
            value = map.get(key);
        }
        return value;
    }

    private CollectionUtils() {
    }
}

