/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_TO_WRAPPER_TYPE = new HashMap(16);
    private static final Map<Class<?>, Class<?>> WRAPPER_TYPE_TO_PRIMITIVE_TYPE = new HashMap(16);

    public static boolean isPrimitiveTypeOrWrapperType(Class<?> type) {
        return PRIMITIVE_TYPE_TO_WRAPPER_TYPE.containsKey(type) || WRAPPER_TYPE_TO_PRIMITIVE_TYPE.containsKey(type);
    }

    public static boolean isObjectOrVoid(Class<?> clazz) {
        return Objects.equals(Object.class, clazz) || Objects.equals(Void.TYPE, clazz);
    }

    public static boolean isJdkClass(Class<?> clazz) {
        Objects.requireNonNull(clazz, "class name must not null");
        Package objectPackage = clazz.getPackage();
        if (Objects.isNull(objectPackage)) {
            return false;
        }
        String objectPackageName = objectPackage.getName();
        return objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || clazz.getClassLoader() == null;
    }

    public static Class<?> forName(String className) throws Crane4jException {
        Objects.requireNonNull(className, "class name must not null");
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new Crane4jException(e);
        }
    }

    public static Class<?> forName(@Nullable String className, Class<?> defaultClass) {
        if (StringUtils.isNotEmpty(className)) {
            return ClassUtils.forName(className);
        }
        return defaultClass;
    }

    public static <T> T newInstance(@NonNull Class<?> type, Object ... args) {
        Objects.requireNonNull(type, "type must not null");
        try {
            Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
            ReflectUtils.setAccessible(constructor);
            return (T)constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new Crane4jException(e);
        }
    }

    public static boolean isInstantiable(Class<?> type, @Nullable Consumer<Throwable> fallback) {
        try {
            Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
            ReflectUtils.setAccessible(constructor);
            constructor.newInstance(new Object[0]);
            return true;
        }
        catch (Exception e) {
            if (Objects.nonNull(fallback)) {
                fallback.accept(e);
            }
            return false;
        }
    }

    public static String packageToPath(String packagePath) {
        Objects.requireNonNull(packagePath, "packagePath must not null");
        return packagePath.replace(".", "/");
    }

    private ClassUtils() {
    }

    static {
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Character.TYPE, Character.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Double.TYPE, Double.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Float.TYPE, Float.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Long.TYPE, Long.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Short.TYPE, Short.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.put(Void.TYPE, Void.class);
        PRIMITIVE_TYPE_TO_WRAPPER_TYPE.forEach((key, value) -> WRAPPER_TYPE_TO_PRIMITIVE_TYPE.put((Class<?>)value, (Class<?>)key));
    }
}

