/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.exception.Crane4jException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class Asserts {
    public static void isEquals(Object obj1, Object obj2, Supplier<RuntimeException> ex) {
        if (!Objects.equals(obj1, obj2)) {
            throw ex.get();
        }
    }

    public static void isEquals(Object obj1, Object obj2, String message, Object ... args) {
        Asserts.isEquals(obj1, obj2, () -> new Crane4jException(message, args));
    }

    public static void isNotEquals(Object obj1, Object obj2, Supplier<RuntimeException> ex) {
        if (Objects.equals(obj1, obj2)) {
            throw ex.get();
        }
    }

    public static void isNotEquals(Object obj1, Object obj2, String message, Object ... args) {
        Asserts.isNotEquals(obj1, obj2, () -> new Crane4jException(message, args));
    }

    public static void isTrue(boolean expression, Supplier<RuntimeException> ex) {
        if (!expression) {
            throw ex.get();
        }
    }

    public static void isTrue(boolean expression, String message, Object ... args) {
        Asserts.isTrue(expression, () -> new Crane4jException(message, args));
    }

    public static void isFalse(boolean expression, Supplier<RuntimeException> ex) {
        if (expression) {
            throw ex.get();
        }
    }

    public static void isFalse(boolean expression, String message, Object ... args) {
        Asserts.isFalse(expression, () -> new Crane4jException(message, args));
    }

    public static void isNotEmpty(Object object, Supplier<RuntimeException> ex) {
        if (object == null) {
            throw ex.get();
        }
        if ("".equals(object)) {
            throw ex.get();
        }
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            throw ex.get();
        }
        if (object instanceof Map && ((Map)object).isEmpty()) {
            throw ex.get();
        }
        if (object instanceof Object[] && ((Object[])object).length == 0) {
            throw ex.get();
        }
    }

    public static void isNotEmpty(Object object, String message, Object ... args) {
        Asserts.isNotEmpty(object, () -> new Crane4jException(message, args));
    }

    public static void isEmpty(Object object, Supplier<RuntimeException> ex) {
        if (object == null) {
            return;
        }
        if ("".equals(object)) {
            return;
        }
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return;
        }
        if (object instanceof Map && ((Map)object).isEmpty()) {
            return;
        }
        if (object instanceof Object[] && ((Object[])object).length == 0) {
            return;
        }
        throw ex.get();
    }

    public static void isEmpty(Object object, String message, Object ... args) {
        Asserts.isEmpty(object, () -> new Crane4jException(message, args));
    }

    public static void isNotNull(Object object, Supplier<RuntimeException> ex) {
        if (object == null) {
            throw ex.get();
        }
    }

    public static void isNotNull(Object object, String message, Object ... args) {
        Asserts.isNotNull(object, () -> new Crane4jException(message, args));
    }

    public static void isNull(Object object, Supplier<RuntimeException> ex) {
        if (object != null) {
            throw ex.get();
        }
    }

    public static void isNull(Object object, String message, Object ... args) {
        Asserts.isNull(object, () -> new Crane4jException(message, args));
    }

    private Asserts() {
    }
}

