/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.ParameterConvertibleMethodInvoker;
import cn.crane4j.core.support.reflect.AbstractPropDesc;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.ReflectiveFieldAdapterMethodInvoker;
import cn.crane4j.core.support.reflect.ReflectiveMethodInvoker;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReflectivePropertyOperator
implements PropertyOperator {
    public static final ReflectivePropertyOperator INSTANCE = new ReflectivePropertyOperator();
    protected @Nullable ConverterManager converterManager;
    protected boolean throwIfNoAnyMatched = false;

    public ReflectivePropertyOperator(@Nullable ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ReflectivePropertyOperator() {
        this(null);
    }

    @Override
    public @NonNull PropDesc getPropertyDescriptor(Class<?> targetType) {
        return new ReflectivePropDesc(targetType, this.converterManager, this.throwIfNoAnyMatched);
    }

    public void setConverterManager(@Nullable ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setThrowIfNoAnyMatched(boolean throwIfNoAnyMatched) {
        this.throwIfNoAnyMatched = throwIfNoAnyMatched;
    }

    protected static class ReflectivePropDesc
    extends AbstractPropDesc {
        protected final @Nullable ConverterManager converterManager;
        private final boolean throwIfNoAnyMatched;

        public ReflectivePropDesc(Class<?> beanType, @Nullable ConverterManager converterManager, boolean throwIfNoAnyMatched) {
            super(beanType);
            this.converterManager = converterManager;
            this.throwIfNoAnyMatched = throwIfNoAnyMatched;
        }

        @Override
        public @Nullable MethodInvoker findGetter(String propertyName) {
            Method method = ReflectivePropDesc.findGetterMethod(this.beanType, propertyName);
            MethodInvoker methodInvoker = this.resolveInvokerForMethod(propertyName, method);
            if (methodInvoker != null) {
                return methodInvoker;
            }
            Field field = ReflectUtils.getField(this.beanType, propertyName);
            MethodInvoker methodInvokerForGetter = this.resolveGetterInvokerForField(propertyName, field);
            if (methodInvokerForGetter != null) {
                return methodInvokerForGetter;
            }
            Asserts.isFalse(this.throwIfNoAnyMatched, "No getter method found for property [{}] in [{}] ", propertyName, this.beanType.getName());
            return null;
        }

        @Override
        public @Nullable MethodInvoker findSetter(String propertyName) {
            Method method = ReflectivePropDesc.findSetterMethod(this.beanType, propertyName);
            MethodInvoker methodInvoker = this.resolveInvokerForMethod(propertyName, method);
            if (methodInvoker != null) {
                return methodInvoker;
            }
            Field field = ReflectUtils.getField(this.beanType, propertyName);
            MethodInvoker methodInvokerForSetter = this.resolveSetterInvokerForField(propertyName, field);
            if (methodInvokerForSetter != null) {
                return methodInvokerForSetter;
            }
            Asserts.isFalse(this.throwIfNoAnyMatched, "No setter method found for property [{}] in [{}] ", propertyName, this.beanType.getName());
            return null;
        }

        protected final @Nullable MethodInvoker resolveInvokerForMethod(String propertyName, @Nullable Method method) {
            if (Objects.isNull(method)) {
                return null;
            }
            MethodInvoker invoker = this.createInvokerForMethod(propertyName, method);
            if (Objects.isNull(invoker)) {
                return null;
            }
            if (Objects.isNull(this.converterManager)) {
                return invoker;
            }
            return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, method.getParameterTypes());
        }

        protected @Nullable MethodInvoker createInvokerForMethod(String propertyName, Method method) {
            return ReflectiveMethodInvoker.create(null, method, false);
        }

        protected final @Nullable MethodInvoker resolveSetterInvokerForField(String propertyName, @Nullable Field field) {
            if (Objects.isNull(field)) {
                return null;
            }
            MethodInvoker invoker = this.createSetterInvokerForField(propertyName, field);
            if (Objects.isNull(invoker)) {
                return null;
            }
            if (Objects.isNull(this.converterManager)) {
                return invoker;
            }
            return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, new Class[]{field.getType()});
        }

        protected MethodInvoker createSetterInvokerForField(String propertyName, Field field) {
            return ReflectiveFieldAdapterMethodInvoker.createSetter(field);
        }

        protected final MethodInvoker resolveGetterInvokerForField(String propertyName, @Nullable Field field) {
            if (Objects.isNull(field)) {
                return null;
            }
            return this.createGetterInvokerForField(propertyName, field);
        }

        protected MethodInvoker createGetterInvokerForField(String propertyName, Field field) {
            return ReflectiveFieldAdapterMethodInvoker.createGetter(field);
        }

        private static @Nullable Method findSetterMethod(Class<?> targetType, String propertyName) {
            Field field = ReflectUtils.getField(targetType, propertyName);
            if (Objects.isNull(field)) {
                return ReflectUtils.findSetterMethod(targetType, propertyName).orElse(null);
            }
            return ReflectUtils.findSetterMethod(targetType, field).orElse(null);
        }

        private static @Nullable Method findGetterMethod(Class<?> targetType, String propertyName) {
            Field field = ReflectUtils.getField(targetType, propertyName);
            if (Objects.isNull(field)) {
                return ReflectUtils.findGetterMethod(targetType, propertyName).orElse(null);
            }
            return ReflectUtils.findGetterMethod(targetType, field).orElse(null);
        }
    }
}

