/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.support.reflect.PropertyOperator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MapAccessiblePropertyOperator
implements PropertyOperator {
    private static final MapPropDesc MAP_PROP_DESC = new MapPropDesc();
    private final PropertyOperator delegate;

    @Override
    public @NonNull PropDesc getPropertyDescriptor(Class<?> targetType) {
        return Map.class.isAssignableFrom(targetType) ? MAP_PROP_DESC : this.delegate.getPropertyDescriptor(targetType);
    }

    public MapAccessiblePropertyOperator(PropertyOperator delegate) {
        this.delegate = delegate;
    }

    private static class MapPropDesc
    implements PropDesc {
        private MapPropDesc() {
        }

        @Override
        public Class<?> getBeanType() {
            return Map.class;
        }

        @Override
        public @Nullable MethodInvoker getGetter(String propertyName) {
            return (t, args) -> MapPropDesc.castMap(t).get(propertyName);
        }

        @Override
        public @Nullable MethodInvoker getSetter(String propertyName) {
            return (t, arg) -> MapPropDesc.castMap(t).put(propertyName, arg[0]);
        }

        private static Map<String, Object> castMap(Object target) {
            return (Map)target;
        }
    }
}

