/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.AbstractPropDesc;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChainAccessiblePropertyOperator
implements PropertyOperator {
    protected final PropertyOperator delegate;
    private final Function<String, String[]> splitter;

    public ChainAccessiblePropertyOperator(PropertyOperator delegate) {
        this(delegate, new DefaultSplitter("."));
    }

    @Override
    public @NonNull PropDesc getPropertyDescriptor(Class<?> targetType) {
        PropDesc delegateDesc = this.delegate.getPropertyDescriptor(targetType);
        return new ChainAccessPropDesc(targetType, delegateDesc);
    }

    protected MethodInvoker chainSetter(String[] splitPropertyChain) {
        return (target, args) -> {
            int deep;
            int targetDeep = splitPropertyChain.length - 1;
            for (deep = 0; deep < targetDeep; ++deep) {
                if (Objects.isNull(target)) {
                    return null;
                }
                String targetProp = splitPropertyChain[deep];
                target = this.delegate.readProperty(target.getClass(), target, targetProp);
            }
            if (deep == targetDeep && Objects.nonNull(target)) {
                this.delegate.writeProperty(target.getClass(), target, splitPropertyChain[targetDeep], args[0]);
            }
            return null;
        };
    }

    protected MethodInvoker chainGetter(String[] splitPropertyChain) {
        return (target, args) -> {
            for (String prop : splitPropertyChain) {
                if (Objects.isNull(target)) {
                    return null;
                }
                target = this.delegate.readProperty(target.getClass(), target, prop);
            }
            return target;
        };
    }

    public ChainAccessiblePropertyOperator(PropertyOperator delegate, Function<String, String[]> splitter) {
        this.delegate = delegate;
        this.splitter = splitter;
    }

    public static class DefaultSplitter
    implements Function<String, String[]> {
        private final String separator;
        private final Map<String, String[]> caches = CollectionUtils.newWeakConcurrentMap();

        @Override
        public String[] apply(String propertyName) {
            return CollectionUtils.computeIfAbsent(this.caches, propertyName, p -> propertyName.split("\\" + this.separator));
        }

        public DefaultSplitter(String separator) {
            this.separator = separator;
        }
    }

    protected class ChainAccessPropDesc
    extends AbstractPropDesc {
        private final PropDesc delegate;

        public ChainAccessPropDesc(Class<?> beanType, PropDesc delegate) {
            super(beanType);
            this.delegate = delegate;
        }

        @Override
        public @Nullable MethodInvoker getGetter(String propertyName) {
            String[] properties = (String[])ChainAccessiblePropertyOperator.this.splitter.apply(propertyName);
            if (properties.length <= 1) {
                return this.delegate.getGetter(propertyName);
            }
            return super.getGetter(propertyName);
        }

        @Override
        public @Nullable MethodInvoker getSetter(String propertyName) {
            String[] properties = (String[])ChainAccessiblePropertyOperator.this.splitter.apply(propertyName);
            if (properties.length <= 1) {
                return this.delegate.getSetter(propertyName);
            }
            return super.getSetter(propertyName);
        }

        @Override
        public @Nullable MethodInvoker findGetter(String propertyName) {
            String[] properties = (String[])ChainAccessiblePropertyOperator.this.splitter.apply(propertyName);
            return ChainAccessiblePropertyOperator.this.chainGetter(properties);
        }

        @Override
        protected @Nullable MethodInvoker findSetter(String propertyName) {
            String[] properties = (String[])ChainAccessiblePropertyOperator.this.splitter.apply(propertyName);
            return ChainAccessiblePropertyOperator.this.chainSetter(properties);
        }
    }
}

