/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.ChainAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.PropertyOperator;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CacheableChainAccessiblePropertyOperator
extends ChainAccessiblePropertyOperator {
    public CacheableChainAccessiblePropertyOperator(PropertyOperator delegate) {
        super(delegate);
    }

    public CacheableChainAccessiblePropertyOperator(PropertyOperator delegate, Function<String, String[]> splitter) {
        super(delegate, splitter);
    }

    @Override
    protected MethodInvoker chainGetter(String[] splitPropertyChain) {
        return new ChainGetter(splitPropertyChain);
    }

    @Override
    protected MethodInvoker chainSetter(String[] splitPropertyChain) {
        return new ChainSetter(splitPropertyChain);
    }

    private class ChainSetter
    implements MethodInvoker {
        private final String[] splitPropertyChain;
        private volatile boolean initialized = false;
        private MethodInvoker[] getterCaches;
        private MethodInvoker setterCache;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object target, Object ... args) {
            if (!this.initialized) {
                ChainSetter chainSetter = this;
                synchronized (chainSetter) {
                    if (!this.initialized) {
                        return this.invokeAndInit(target, args);
                    }
                }
            }
            return this.invokeIfInitialized(target, args);
        }

        private Object invokeAndInit(Object target, Object ... args) {
            int deep;
            int targetDeep = this.splitPropertyChain.length - 1;
            this.getterCaches = new MethodInvoker[targetDeep];
            for (deep = 0; deep < targetDeep; ++deep) {
                if (Objects.isNull(target)) {
                    return null;
                }
                String targetProp = this.splitPropertyChain[deep];
                MethodInvoker getter = CacheableChainAccessiblePropertyOperator.this.delegate.findGetter(target.getClass(), targetProp);
                if (Objects.isNull(getter)) {
                    return null;
                }
                this.getterCaches[deep] = getter;
                target = getter.invoke(target, new Object[0]);
            }
            if (deep == targetDeep && Objects.nonNull(target)) {
                this.setterCache = CacheableChainAccessiblePropertyOperator.this.delegate.findSetter(target.getClass(), this.splitPropertyChain[targetDeep]);
                if (Objects.isNull(this.setterCache)) {
                    return null;
                }
                this.setterCache.invoke(target, args[0]);
                this.initialized = true;
            }
            return target;
        }

        private @Nullable Object invokeIfInitialized(Object target, Object[] args) {
            for (MethodInvoker getter : this.getterCaches) {
                if (Objects.isNull(target)) {
                    return null;
                }
                target = getter.invoke(target, new Object[0]);
            }
            return Objects.nonNull(target) ? this.setterCache.invoke(target, args) : null;
        }

        public ChainSetter(String[] splitPropertyChain) {
            this.splitPropertyChain = splitPropertyChain;
        }
    }

    private class ChainGetter
    implements MethodInvoker {
        private final String[] splitPropertyChain;
        private volatile boolean initialized = false;
        private MethodInvoker[] getterCaches;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object target, Object ... args) {
            if (!this.initialized) {
                ChainGetter chainGetter = this;
                synchronized (chainGetter) {
                    if (!this.initialized) {
                        return this.invokeAndInit(target);
                    }
                }
            }
            return this.invokeIfInitialized(target);
        }

        private synchronized Object invokeAndInit(Object target) {
            this.getterCaches = new MethodInvoker[this.splitPropertyChain.length];
            for (int i = 0; i < this.splitPropertyChain.length; ++i) {
                if (Objects.isNull(target)) {
                    return null;
                }
                MethodInvoker getter = CacheableChainAccessiblePropertyOperator.this.delegate.findGetter(target.getClass(), this.splitPropertyChain[i]);
                if (Objects.isNull(getter)) {
                    return null;
                }
                this.getterCaches[i] = getter;
                target = getter.invoke(target, new Object[0]);
            }
            this.initialized = true;
            return target;
        }

        private @Nullable Object invokeIfInitialized(Object target) {
            for (MethodInvoker getter : this.getterCaches) {
                if (Objects.isNull(target)) {
                    return null;
                }
                target = getter.invoke(target, new Object[0]);
            }
            return target;
        }

        public ChainGetter(String[] splitPropertyChain) {
            this.splitPropertyChain = splitPropertyChain;
        }
    }
}

