/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.util.CollectionUtils;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractPropDesc
implements PropDesc {
    private static final MethodInvoker NULL = (target, args) -> null;
    private final ConcurrentMap<String, MethodInvoker> getterCache = CollectionUtils.newWeakConcurrentMap();
    private final ConcurrentMap<String, MethodInvoker> setterCache = CollectionUtils.newWeakConcurrentMap();
    protected final Class<?> beanType;

    @Override
    public @Nullable MethodInvoker getGetter(String propertyName) {
        MethodInvoker invoker = this.obtainInvokerFromCache(this.getterCache, propertyName, this::findGetter);
        return invoker == NULL ? null : invoker;
    }

    @Override
    public @Nullable MethodInvoker getSetter(String propertyName) {
        MethodInvoker invoker = this.obtainInvokerFromCache(this.setterCache, propertyName, this::findSetter);
        return invoker == NULL ? null : invoker;
    }

    private MethodInvoker obtainInvokerFromCache(ConcurrentMap<String, MethodInvoker> cache, String propertyName, Function<String, MethodInvoker> invokerSupplier) {
        return CollectionUtils.computeIfAbsent(cache, propertyName, prop -> {
            MethodInvoker invoker = (MethodInvoker)invokerSupplier.apply((String)prop);
            return invoker == null ? NULL : invoker;
        });
    }

    protected abstract @Nullable MethodInvoker findGetter(String var1);

    protected abstract @Nullable MethodInvoker findSetter(String var1);

    public AbstractPropDesc(Class<?> beanType) {
        this.beanType = beanType;
    }

    @Override
    public Class<?> getBeanType() {
        return this.beanType;
    }
}

