/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.operator;

import cn.crane4j.annotation.Operator;
import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.SimpleAnnotationFinder;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.support.proxy.DefaultProxyFactory;
import cn.crane4j.core.support.proxy.ProxyFactory;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(OperatorProxyFactory.class);
    private static final Object NULL = new Object();
    private final Crane4jGlobalConfiguration globalConfiguration;
    private final AnnotationFinder annotationFinder;
    private final List<OperatorProxyMethodFactory> proxyMethodFactories = new ArrayList<OperatorProxyMethodFactory>(8);
    private final ProxyFactory proxyFactory;
    private final Map<Class<?>, Object> proxyCaches = new ConcurrentHashMap(8);

    public void addProxyMethodFactory(OperatorProxyMethodFactory proxyMethodFactory) {
        this.proxyMethodFactories.remove(proxyMethodFactory);
        this.proxyMethodFactories.add(proxyMethodFactory);
        this.proxyMethodFactories.sort(Crane4jGlobalSorter.INSTANCE);
    }

    public <T> @Nullable T get(Class<T> operatorType) {
        Asserts.isTrue(Objects.nonNull(operatorType) && operatorType.isInterface(), "the operator type [{}] must be an interface.", operatorType);
        Object proxy = CollectionUtils.computeIfAbsent(this.proxyCaches, operatorType, this::doGetProxy);
        return (T)(proxy == NULL ? null : proxy);
    }

    private Object doGetProxy(Class<?> operatorType) {
        Operator annotation = this.annotationFinder.findAnnotation(operatorType, Operator.class);
        if (Objects.isNull(annotation)) {
            return NULL;
        }
        BeanOperationExecutor executor = this.globalConfiguration.getBeanOperationExecutor(annotation.executor(), annotation.executorType());
        BeanOperationParser parser = this.globalConfiguration.getBeanOperationsParser(annotation.parser(), annotation.executorType());
        log.debug("create operator proxy for interface [{}].", operatorType);
        OperatorProxy proxy = this.createOperatorProxy(operatorType, parser, executor);
        return Proxy.newProxyInstance(operatorType.getClassLoader(), new Class[]{operatorType, ProxiedOperator.class}, (InvocationHandler)proxy);
    }

    private <T> OperatorProxy createOperatorProxy(Class<T> operatorType, BeanOperationParser beanOperationParser, BeanOperationExecutor beanOperationExecutor) {
        HashMap<String, MethodInvoker> proxyMethods = new HashMap<String, MethodInvoker>(8);
        ReflectUtils.traverseTypeHierarchy(operatorType, type -> Stream.of(ReflectUtils.getDeclaredMethods(type)).filter(method -> !method.isDefault()).map(beanOperationParser::parse).forEach(operations -> {
            this.checkOperationOfMethod((BeanOperations)operations);
            Method method = (Method)operations.getSource();
            MethodInvoker invoker = this.createOperatorMethod((BeanOperations)operations, method, beanOperationExecutor);
            proxyMethods.put(method.toString(), invoker);
        }));
        return this.doCreateOperatorProxy(operatorType, proxyMethods);
    }

    @NonNull
    protected <T> OperatorProxy doCreateOperatorProxy(Class<T> operatorType, Map<String, MethodInvoker> proxyMethods) {
        return new OperatorProxy(proxyMethods, operatorType);
    }

    private void checkOperationOfMethod(BeanOperations operations) {
        Method method = (Method)operations.getSource();
        if (method.getParameterCount() < 1) {
            throw new Crane4jException("The number of parameters for the operator method is greater than or equal to 1,but the number of parameters for the [{}] method is [{}].", method, method.getParameterCount());
        }
        if (operations.isEmpty()) {
            throw new Crane4jException("Unable to resolve any valid operation configuration from operator method [{}].", method);
        }
    }

    private MethodInvoker createOperatorMethod(BeanOperations beanOperations, Method method, BeanOperationExecutor beanOperationExecutor) {
        return this.proxyMethodFactories.stream().map(factory -> factory.get(beanOperations, method, beanOperationExecutor)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new Crane4jException("Cannot create proxy for method [{}]", method));
    }

    private static AnnotationFinder $default$annotationFinder() {
        return SimpleAnnotationFinder.INSTANCE;
    }

    private static ProxyFactory $default$proxyFactory() {
        return DefaultProxyFactory.INSTANCE;
    }

    OperatorProxyFactory(Crane4jGlobalConfiguration globalConfiguration, AnnotationFinder annotationFinder, ProxyFactory proxyFactory) {
        this.globalConfiguration = globalConfiguration;
        this.annotationFinder = annotationFinder;
        this.proxyFactory = proxyFactory;
    }

    public static OperatorProxyFactoryBuilder builder() {
        return new OperatorProxyFactoryBuilder();
    }

    public static class OperatorProxyFactoryBuilder {
        private Crane4jGlobalConfiguration globalConfiguration;
        private boolean annotationFinder$set;
        private AnnotationFinder annotationFinder$value;
        private boolean proxyFactory$set;
        private ProxyFactory proxyFactory$value;

        OperatorProxyFactoryBuilder() {
        }

        public OperatorProxyFactoryBuilder globalConfiguration(Crane4jGlobalConfiguration globalConfiguration) {
            this.globalConfiguration = globalConfiguration;
            return this;
        }

        public OperatorProxyFactoryBuilder annotationFinder(AnnotationFinder annotationFinder) {
            this.annotationFinder$value = annotationFinder;
            this.annotationFinder$set = true;
            return this;
        }

        public OperatorProxyFactoryBuilder proxyFactory(ProxyFactory proxyFactory) {
            this.proxyFactory$value = proxyFactory;
            this.proxyFactory$set = true;
            return this;
        }

        public OperatorProxyFactory build() {
            AnnotationFinder annotationFinder$value = this.annotationFinder$value;
            if (!this.annotationFinder$set) {
                annotationFinder$value = OperatorProxyFactory.$default$annotationFinder();
            }
            ProxyFactory proxyFactory$value = this.proxyFactory$value;
            if (!this.proxyFactory$set) {
                proxyFactory$value = OperatorProxyFactory.$default$proxyFactory();
            }
            return new OperatorProxyFactory(this.globalConfiguration, annotationFinder$value, proxyFactory$value);
        }

        public String toString() {
            return "OperatorProxyFactory.OperatorProxyFactoryBuilder(globalConfiguration=" + this.globalConfiguration + ", annotationFinder$value=" + this.annotationFinder$value + ", proxyFactory$value=" + this.proxyFactory$value + ")";
        }
    }

    public static interface ProxiedOperator {
    }

    protected static class OperatorProxy
    implements InvocationHandler {
        private final Map<String, MethodInvoker> proxiedMethods;
        private final Class<?> proxyClass;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            MethodInvoker invoker = this.proxiedMethods.get(method.toString());
            if (Objects.nonNull(invoker)) {
                return invoker.invoke(proxy, args);
            }
            throw new Crane4jException("The method [{}] cannot be called, because it is not a method declared in the proxy class [{}] or Object.class", method, this.proxyClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ProxiedOperator && Proxy.isProxyClass(o.getClass())) {
                o = Proxy.getInvocationHandler(o);
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorProxy that = (OperatorProxy)o;
            return Objects.equals(this.proxiedMethods, that.proxiedMethods) && Objects.equals(this.proxyClass, that.proxyClass);
        }

        public int hashCode() {
            return Objects.hash(this.proxiedMethods, this.proxyClass);
        }

        public String toString() {
            return "OperatorProxyFactory.OperatorProxy(proxyClass=" + this.proxyClass + ")";
        }

        public OperatorProxy(Map<String, MethodInvoker> proxiedMethods, Class<?> proxyClass) {
            this.proxiedMethods = proxiedMethods;
            this.proxyClass = proxyClass;
        }
    }
}

