/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.operator;

import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.ParameterConvertibleMethodInvoker;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.util.ArrayUtils;
import cn.crane4j.core.util.CollectionUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationAnnotationProxyMethodFactory
implements OperatorProxyMethodFactory {
    private static final Logger log = LoggerFactory.getLogger(OperationAnnotationProxyMethodFactory.class);
    private final ConverterManager converterManager;

    @Override
    public int getSort() {
        return 0;
    }

    @Override
    public @Nullable MethodInvoker get(BeanOperations beanOperations, Method method, BeanOperationExecutor beanOperationExecutor) {
        if (beanOperations.isEmpty()) {
            return null;
        }
        ProxyMethod invoker = new ProxyMethod(beanOperations, beanOperationExecutor);
        log.info("create operation annotation proxy method for method: {}", (Object)method);
        return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, method.getParameterTypes());
    }

    public OperationAnnotationProxyMethodFactory(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    private static class ProxyMethod
    implements MethodInvoker {
        private final BeanOperations operations;
        private final BeanOperationExecutor beanOperationExecutor;

        @Override
        public Object invoke(Object target, Object ... args) {
            if (ArrayUtils.isNotEmpty(args)) {
                for (Object arg : args) {
                    if (!Objects.nonNull(arg)) continue;
                    this.beanOperationExecutor.execute(CollectionUtils.adaptObjectToCollection(arg), this.operations);
                }
            }
            return null;
        }

        public ProxyMethod(BeanOperations operations, BeanOperationExecutor beanOperationExecutor) {
            this.operations = operations;
            this.beanOperationExecutor = beanOperationExecutor;
        }
    }
}

