/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container.query;

import cn.crane4j.annotation.MappingType;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.support.container.query.AbstractQueryContainerProvider;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNamespaceResolvableQueryContainerProvider<T>
extends AbstractQueryContainerProvider<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractNamespaceResolvableQueryContainerProvider.class);
    protected static final String NAMESPACE_TEMPLATE = "@{}#{}#{}#{}";
    protected final Map<String, MappingType> mappingTypes = new ConcurrentHashMap<String, MappingType>(8);
    protected static final String NULL = "NULL";

    protected AbstractNamespaceResolvableQueryContainerProvider(MethodInvokerContainerCreator methodInvokerContainerCreator) {
        super(methodInvokerContainerCreator);
    }

    public void setMappingType(String namespace, MappingType mappingType) {
        this.mappingTypes.put(namespace, mappingType);
    }

    @Override
    public String determineNamespace(String name, @Nullable String keyProperty, @Nullable List<String> properties) {
        Asserts.isNotNull(name, "name must not be null", new Object[0]);
        String prefix = this.getClass().getSimpleName();
        String key = StringUtils.isEmpty(keyProperty) ? NULL : keyProperty;
        String props = CollectionUtils.isEmpty(properties) ? NULL : String.join((CharSequence)",", properties);
        return StringUtils.format(NAMESPACE_TEMPLATE, prefix, name, key, props);
    }

    @Override
    protected AbstractQueryContainerProvider.QueryInfo resolveQueryInfo(String namespace) {
        String[] parts = namespace.split("#");
        if (parts.length != 4) {
            log.warn("cannot resolve query info for namespace: {}", (Object)namespace);
            return null;
        }
        String name = parts[1];
        String key = StringUtils.isEmpty(parts[2]) || Objects.equals(parts[2], NULL) ? null : parts[2];
        List<String> props = StringUtils.isEmpty(parts[3]) || Objects.equals(parts[3], NULL) ? null : Arrays.asList(parts[3].split(","));
        QueryInfoImpl queryInfo = new QueryInfoImpl(name, key, props);
        MappingType mappingType = this.mappingTypes.get(namespace);
        if (Objects.nonNull(mappingType)) {
            queryInfo.setMappingType(mappingType);
        }
        return queryInfo;
    }

    protected static class QueryInfoImpl
    implements AbstractQueryContainerProvider.QueryInfo {
        private final String repository;
        private final @Nullable String keyProperty;
        private final @Nullable List<String> properties;
        private MappingType mappingType = MappingType.ONE_TO_ONE;

        @Override
        public String getRepository() {
            return this.repository;
        }

        @Override
        public @Nullable String getKeyProperty() {
            return this.keyProperty;
        }

        @Override
        public @Nullable List<String> getProperties() {
            return this.properties;
        }

        @Override
        public MappingType getMappingType() {
            return this.mappingType;
        }

        public QueryInfoImpl(String repository, @Nullable String keyProperty, @Nullable List<String> properties) {
            this.repository = repository;
            this.keyProperty = keyProperty;
            this.properties = properties;
        }

        public void setMappingType(MappingType mappingType) {
            this.mappingType = mappingType;
        }
    }
}

