/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container;

import cn.crane4j.annotation.DuplicateStrategy;
import cn.crane4j.annotation.MappingType;
import cn.crane4j.core.container.MethodInvokerContainer;
import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.ParameterConvertibleMethodInvoker;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.ReflectiveMethodInvoker;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInvokerContainerCreator {
    private static final Logger log = LoggerFactory.getLogger(MethodInvokerContainerCreator.class);
    protected final PropertyOperator propertyOperator;
    protected final ConverterManager converterManager;

    public MethodInvokerContainer createContainer(MethodInvokerContainerCreation containerCreation) {
        Object target = containerCreation.getTarget();
        Method method = containerCreation.getMethod();
        String namespace = MethodInvokerContainerCreator.getNamespace(method, containerCreation.getNamespace());
        MappingType mappingType = containerCreation.getMappingType();
        MethodInvoker methodInvoker = Optional.ofNullable(containerCreation.getMethodInvoker()).orElseGet(() -> this.adaptMethodToInvoker(target, method));
        MethodInvokerContainer container = this.doCreateContainer(containerCreation, mappingType, target, methodInvoker, method, namespace);
        String extractProperty = containerCreation.getOn();
        if (StringUtils.isNotEmpty(extractProperty)) {
            MethodInvoker extractor = (t, args) -> this.propertyOperator.readProperty(t.getClass(), t, extractProperty);
            container.setExtractor(extractor);
        }
        if (Objects.isNull(method)) {
            log.info("create method invoker container [{}], mapping type is [{}]", (Object)container.getNamespace(), (Object)mappingType);
        } else {
            log.info("create method invoker container [{}] for method [{}], mapping type is [{}]", new Object[]{container.getNamespace(), method, mappingType});
        }
        return container;
    }

    private MethodInvokerContainer doCreateContainer(MethodInvokerContainerCreation containerCreation, MappingType mappingType, Object target, MethodInvoker methodInvoker, Method method, String namespace) {
        MethodInvokerContainer container;
        if (mappingType == MappingType.NO_MAPPING) {
            container = this.doCreateNoMappingContainer(target, methodInvoker, method, namespace);
        } else if (mappingType == MappingType.ORDER_OF_KEYS) {
            Asserts.isNotNull(method, "method must not be null when mapping type is [{}]", mappingType);
            container = MethodInvokerContainerCreator.isSingleParameterMethod(method) ? this.doCreateSingleKeyContainer(target, methodInvoker, namespace) : this.doCreateOrderOfKeysContainer(target, methodInvoker, method, namespace);
        } else if (mappingType == MappingType.ONE_TO_ONE) {
            container = this.doCreateOneToOneContainer(target, methodInvoker, method, namespace, containerCreation.getResultType(), containerCreation.getResultKey(), containerCreation.getDuplicateStrategy());
        } else if (mappingType == MappingType.ONE_TO_MANY) {
            container = this.doCreateOneToManyContainer(target, methodInvoker, method, namespace, containerCreation.getResultType(), containerCreation.getResultKey(), containerCreation.getDuplicateStrategy());
        } else {
            throw new Crane4jException("Unsupported mapping type [{}] for method container [{}]", mappingType, containerCreation.getNamespace());
        }
        return container;
    }

    private static boolean isSingleParameterMethod(@NonNull Method method) {
        return method.getParameterCount() == 1 && !Collection.class.isAssignableFrom(method.getParameterTypes()[0]);
    }

    protected MethodInvokerContainer doCreateSingleKeyContainer(@Nullable Object target, MethodInvoker methodInvoker, String namespace) {
        return MethodInvokerContainer.singleKey(namespace, methodInvoker, target);
    }

    protected MethodInvokerContainer doCreateNoMappingContainer(@Nullable Object target, MethodInvoker methodInvoker, @Nullable Method method, String namespace) {
        if (Objects.nonNull(method)) {
            Asserts.isTrue(Map.class.isAssignableFrom(method.getReturnType()), "method [{}] must return a map type when mapping type is [{}]", method, MappingType.NO_MAPPING);
        }
        return MethodInvokerContainer.create(namespace, methodInvoker, target, true);
    }

    protected MethodInvokerContainer doCreateOrderOfKeysContainer(@Nullable Object target, MethodInvoker methodInvoker, @Nullable Method method, String namespace) {
        return MethodInvokerContainer.create(namespace, methodInvoker, target, false);
    }

    protected MethodInvokerContainer doCreateOneToOneContainer(@Nullable Object target, MethodInvoker methodInvoker, @Nullable Method method, String namespace, Class<?> resultType, String resultKey, DuplicateStrategy duplicateStrategy) {
        MethodInvokerContainer.KeyExtractor keyExtractor = this.getKeyExtractor(resultType, resultKey, namespace);
        return MethodInvokerContainer.oneToOne(namespace, methodInvoker, target, keyExtractor, duplicateStrategy);
    }

    protected MethodInvokerContainer doCreateOneToManyContainer(@Nullable Object target, MethodInvoker methodInvoker, @Nullable Method method, String namespace, Class<?> resultType, String resultKey, DuplicateStrategy duplicateStrategy) {
        MethodInvokerContainer.KeyExtractor keyExtractor = this.getKeyExtractor(resultType, resultKey, namespace);
        return MethodInvokerContainer.oneToMany(namespace, methodInvoker, target, keyExtractor);
    }

    protected @NonNull MethodInvoker adaptMethodToInvoker(Object target, Method method) {
        ReflectiveMethodInvoker invoker = ReflectiveMethodInvoker.create(target, method, false);
        return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, method.getParameterTypes());
    }

    protected @Nullable MethodInvokerContainer.KeyExtractor getKeyExtractor(Class<?> resultType, String resultKey, String namespace) {
        if (MethodInvokerContainerCreator.canExtractKey(resultType, resultKey)) {
            MethodInvoker keyGetter = this.findKeyGetter(resultType, resultKey);
            MethodInvokerContainer.KeyExtractor keyExtractor = x$0 -> keyGetter.invoke(x$0, new Object[0]);
            return keyExtractor;
        }
        throw new Crane4jException("Failed to parse the method container [{}], because the extractor that gets the key [{}] from the return value type [{}] could not be obtained. Does the property exist in the return value type and is it readable?", namespace, resultKey, resultType);
    }

    private static boolean canExtractKey(Class<?> resultType, String resultKey) {
        return !ClassUtils.isPrimitiveTypeOrWrapperType(resultType) && !Objects.equals(String.class, resultType) && StringUtils.isNotEmpty(resultKey);
    }

    protected static @NonNull String getNamespace(@Nullable Method method, String namespace) {
        if (StringUtils.isEmpty(namespace)) {
            Objects.requireNonNull(method, "method must not be null");
            return method.getName();
        }
        return namespace;
    }

    protected MethodInvoker findKeyGetter(Class<?> resultType, String resultKey) {
        MethodInvoker keyGetter = this.propertyOperator.findGetter(resultType, resultKey);
        Asserts.isNotNull(keyGetter, "cannot find getter method [{}] on [{}]", resultKey, resultType);
        return keyGetter;
    }

    public MethodInvokerContainerCreator(PropertyOperator propertyOperator, ConverterManager converterManager) {
        this.propertyOperator = propertyOperator;
        this.converterManager = converterManager;
    }

    public static class MethodInvokerContainerCreation {
        private final @Nullable Object target;
        private final @Nullable Method method;
        private final MethodInvoker methodInvoker;
        private final MappingType mappingType;
        private final @Nullable String namespace;
        private final Class<?> resultType;
        private final String resultKey;
        private final DuplicateStrategy duplicateStrategy;
        private final @Nullable String on;

        MethodInvokerContainerCreation(@Nullable Object target, @Nullable Method method, MethodInvoker methodInvoker, MappingType mappingType, @Nullable String namespace, Class<?> resultType, String resultKey, DuplicateStrategy duplicateStrategy, @Nullable String on) {
            this.target = target;
            this.method = method;
            this.methodInvoker = methodInvoker;
            this.mappingType = mappingType;
            this.namespace = namespace;
            this.resultType = resultType;
            this.resultKey = resultKey;
            this.duplicateStrategy = duplicateStrategy;
            this.on = on;
        }

        public static MethodInvokerContainerCreationBuilder builder() {
            return new MethodInvokerContainerCreationBuilder();
        }

        public @Nullable Object getTarget() {
            return this.target;
        }

        public @Nullable Method getMethod() {
            return this.method;
        }

        public MethodInvoker getMethodInvoker() {
            return this.methodInvoker;
        }

        public MappingType getMappingType() {
            return this.mappingType;
        }

        public @Nullable String getNamespace() {
            return this.namespace;
        }

        public Class<?> getResultType() {
            return this.resultType;
        }

        public String getResultKey() {
            return this.resultKey;
        }

        public DuplicateStrategy getDuplicateStrategy() {
            return this.duplicateStrategy;
        }

        public @Nullable String getOn() {
            return this.on;
        }

        public static class MethodInvokerContainerCreationBuilder {
            private Object target;
            private Method method;
            private MethodInvoker methodInvoker;
            private MappingType mappingType;
            private String namespace;
            private Class<?> resultType;
            private String resultKey;
            private DuplicateStrategy duplicateStrategy;
            private String on;

            MethodInvokerContainerCreationBuilder() {
            }

            public MethodInvokerContainerCreationBuilder target(@Nullable Object target) {
                this.target = target;
                return this;
            }

            public MethodInvokerContainerCreationBuilder method(@Nullable Method method) {
                this.method = method;
                return this;
            }

            public MethodInvokerContainerCreationBuilder methodInvoker(MethodInvoker methodInvoker) {
                this.methodInvoker = methodInvoker;
                return this;
            }

            public MethodInvokerContainerCreationBuilder mappingType(MappingType mappingType) {
                this.mappingType = mappingType;
                return this;
            }

            public MethodInvokerContainerCreationBuilder namespace(@Nullable String namespace) {
                this.namespace = namespace;
                return this;
            }

            public MethodInvokerContainerCreationBuilder resultType(Class<?> resultType) {
                this.resultType = resultType;
                return this;
            }

            public MethodInvokerContainerCreationBuilder resultKey(String resultKey) {
                this.resultKey = resultKey;
                return this;
            }

            public MethodInvokerContainerCreationBuilder duplicateStrategy(DuplicateStrategy duplicateStrategy) {
                this.duplicateStrategy = duplicateStrategy;
                return this;
            }

            public MethodInvokerContainerCreationBuilder on(@Nullable String on) {
                this.on = on;
                return this;
            }

            public MethodInvokerContainerCreation build() {
                return new MethodInvokerContainerCreation(this.target, this.method, this.methodInvoker, this.mappingType, this.namespace, this.resultType, this.resultKey, this.duplicateStrategy, this.on);
            }

            public String toString() {
                return "MethodInvokerContainerCreator.MethodInvokerContainerCreation.MethodInvokerContainerCreationBuilder(target=" + this.target + ", method=" + this.method + ", methodInvoker=" + this.methodInvoker + ", mappingType=" + this.mappingType + ", namespace=" + this.namespace + ", resultType=" + this.resultType + ", resultKey=" + this.resultKey + ", duplicateStrategy=" + this.duplicateStrategy + ", on=" + this.on + ")";
            }
        }
    }
}

