/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.auto;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElement;
import cn.crane4j.core.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultAutoOperateAnnotatedElement
implements AutoOperateAnnotatedElement {
    private final AutoOperate annotation;
    private final AnnotatedElement element;
    private final MethodInvoker extractor;
    private final Predicate<? super KeyTriggerOperation> filter;
    private final @Nullable BeanOperations beanOperations;
    private final BeanOperationExecutor executor;
    private final Function<Object, BeanOperations> parser;

    public static DefaultAutoOperateAnnotatedElement forStaticTypeOperation(AutoOperate annotation, AnnotatedElement element, MethodInvoker extractor, Predicate<? super KeyTriggerOperation> filter, BeanOperations operations, BeanOperationExecutor executor) {
        return new DefaultAutoOperateAnnotatedElement(annotation, element, extractor, filter, operations, executor, null);
    }

    public static DefaultAutoOperateAnnotatedElement forDynamicTypeOperation(AutoOperate annotation, AnnotatedElement element, MethodInvoker extractor, Predicate<? super KeyTriggerOperation> filter, BeanOperationExecutor executor, Function<Object, BeanOperations> parser) {
        return new DefaultAutoOperateAnnotatedElement(annotation, element, extractor, filter, null, executor, parser);
    }

    @Override
    public void execute(Object data) {
        BeanOperations bo;
        Object target = this.extractor.invoke(data, new Object[0]);
        if (Objects.isNull(target)) {
            return;
        }
        BeanOperations beanOperations = bo = Objects.isNull(this.beanOperations) ? this.parser.apply(target) : this.beanOperations;
        if (Objects.nonNull(bo) && !bo.isEmpty()) {
            this.executor.execute(CollectionUtils.adaptObjectToCollection(target), bo, this.filter);
        }
    }

    protected DefaultAutoOperateAnnotatedElement(AutoOperate annotation, AnnotatedElement element, MethodInvoker extractor, Predicate<? super KeyTriggerOperation> filter, @Nullable BeanOperations beanOperations, BeanOperationExecutor executor, Function<Object, BeanOperations> parser) {
        this.annotation = annotation;
        this.element = element;
        this.extractor = extractor;
        this.filter = filter;
        this.beanOperations = beanOperations;
        this.executor = executor;
        this.parser = parser;
    }

    @Override
    public AutoOperate getAnnotation() {
        return this.annotation;
    }

    @Override
    public AnnotatedElement getElement() {
        return this.element;
    }

    public MethodInvoker getExtractor() {
        return this.extractor;
    }

    @Override
    public @Nullable BeanOperations getBeanOperations() {
        return this.beanOperations;
    }
}

