/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.auto;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.auto.AbstractAutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.auto.DefaultAutoOperateAnnotatedElement;
import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassBasedAutoOperateAnnotatedElementResolver
extends AbstractAutoOperateAnnotatedElementResolver {
    private final ExpressionEvaluator expressionEvaluator;
    private final Function<Object, ExpressionContext> contextFactory;

    public ClassBasedAutoOperateAnnotatedElementResolver(Crane4jGlobalConfiguration configuration, ExpressionEvaluator expressionEvaluator, Function<Object, ExpressionContext> contextFactory) {
        super(configuration);
        this.expressionEvaluator = expressionEvaluator;
        this.contextFactory = contextFactory;
    }

    @Override
    public boolean support(AnnotatedElement element, @Nullable AutoOperate annotation) {
        return element instanceof Class;
    }

    @Override
    protected @Nullable AutoOperateAnnotatedElement createAutoOperateAnnotatedElement(AnnotatedElement element, AutoOperate annotation, BeanOperationParser parser, BeanOperationExecutor executor, MethodInvoker extractor, Predicate<? super KeyTriggerOperation> filter) {
        if (!this.support(element, annotation)) {
            return null;
        }
        Class type = ClassUtils.isObjectOrVoid(annotation.type()) ? (Class)element : annotation.type();
        BeanOperations beanOperations = parser.parse(type);
        if (beanOperations.isEmpty()) {
            return null;
        }
        DefaultAutoOperateAnnotatedElement result = DefaultAutoOperateAnnotatedElement.forStaticTypeOperation(annotation, type, extractor, filter, beanOperations, executor);
        return StringUtils.isEmpty(annotation.condition()) ? result : new ConditionalAutoOperateElement(result);
    }

    @Override
    protected MethodInvoker resolveExtractor(AnnotatedElement element, AutoOperate annotation) {
        String on = annotation.on();
        if (StringUtils.isEmpty(on)) {
            return (t, args) -> t;
        }
        return (t, args) -> Optional.ofNullable(this.configuration.getPropertyOperator()).map(po -> po.findGetter(t.getClass(), on)).orElseThrow(() -> new Crane4jException("Cannot find getter for [{}] on [{}]", on, t.getClass())).invoke(t, args);
    }

    private class ConditionalAutoOperateElement
    implements AutoOperateAnnotatedElement {
        private final DefaultAutoOperateAnnotatedElement delegate;

        @Override
        public AutoOperate getAnnotation() {
            return this.delegate.getAnnotation();
        }

        @Override
        public AnnotatedElement getElement() {
            return this.delegate.getElement();
        }

        @Override
        public @Nullable BeanOperations getBeanOperations() {
            return this.delegate.getBeanOperations();
        }

        @Override
        public void execute(Object data) {
            Optional.ofNullable(data).map(t -> this.delegate.getExtractor().invoke(t, new Object[0])).filter(t -> this.canApply(this.delegate.getAnnotation().condition(), t)).ifPresent(this.delegate::execute);
        }

        private boolean canApply(String condition, Object data) {
            if (StringUtils.isEmpty(condition)) {
                return true;
            }
            ExpressionContext expressionContext = (ExpressionContext)ClassBasedAutoOperateAnnotatedElementResolver.this.contextFactory.apply(data);
            return Boolean.TRUE.equals(ClassBasedAutoOperateAnnotatedElementResolver.this.expressionEvaluator.execute(condition, Boolean.class, expressionContext));
        }

        public ConditionalAutoOperateElement(DefaultAutoOperateAnnotatedElement delegate) {
            this.delegate = delegate;
        }
    }
}

