/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler;

import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.handler.OperationAnnotationHandler;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.parser.operation.SimpleKeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.core.util.MultiMap;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStandardOperationAnnotationHandler<A extends Annotation>
implements OperationAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractStandardOperationAnnotationHandler.class);
    protected final Class<A> annotationType;
    protected final AnnotationFinder annotationFinder;
    protected @org.checkerframework.checker.nullness.qual.NonNull Comparator<KeyTriggerOperation> operationComparator;

    @Override
    public void resolve(BeanOperationParser parser, BeanOperations beanOperations) {
        AnnotatedElement source = beanOperations.getSource();
        log.debug("resolve operations from [{}]", (Object)source);
        List<KeyTriggerOperation> operations = this.parseOperations(parser, beanOperations).stream().sorted(this.operationComparator).collect(Collectors.toList());
        this.doResolve(beanOperations, operations);
    }

    protected abstract void doResolve(BeanOperations var1, List<KeyTriggerOperation> var2);

    private List<KeyTriggerOperation> parseOperations(BeanOperationParser parser, BeanOperations beanOperations) {
        AnnotatedElement source = beanOperations.getSource();
        MultiMap<AnnotatedElement, A> annotations = MultiMap.arrayListMultimap();
        if (source instanceof Class) {
            Class beanType = (Class)source;
            annotations.putAll(beanType, this.parseAnnotationForClass(beanType));
            annotations.putAll(this.parseAnnotationForFields(beanType));
            annotations.putAll(this.parseAnnotationForMethods(beanType));
        } else {
            annotations.putAll(source, this.parseAnnotationForElement(source));
        }
        return annotations.entries().stream().map(e -> {
            AnnotatedElement element = (AnnotatedElement)e.getKey();
            Annotation annotation = (Annotation)e.getValue();
            StandardAnnotation<Annotation> standardAnnotation = this.getStandardAnnotation(beanOperations, element, annotation);
            return this.createOperation(parser, beanOperations, standardAnnotation);
        }).filter(Objects::nonNull).sorted(this.operationComparator).collect(Collectors.toList());
    }

    protected Set<A> parseAnnotationForElement(AnnotatedElement element) {
        return this.annotationFinder.getAllAnnotations(element, this.annotationType);
    }

    protected Set<A> parseAnnotationForClass(Class<?> beanType) {
        return this.parseAnnotationForElement(beanType);
    }

    protected MultiMap<AnnotatedElement, A> parseAnnotationForMethods(Class<?> beanType) {
        MultiMap result = MultiMap.arrayListMultimap();
        AnnotatedElement[] methods = (Method[])Stream.of(ReflectUtils.getDeclaredMethods(beanType)).filter(method -> method.getParameterCount() == 0).filter(method -> !Objects.equals(method.getReturnType(), Void.TYPE)).toArray(Method[]::new);
        ReflectUtils.scanAllAnnotationFromElements((AnnotationFinder)this.annotationFinder, this.annotationType, (AnnotatedElement[])methods, result::put);
        return result;
    }

    protected MultiMap<AnnotatedElement, A> parseAnnotationForFields(Class<?> beanType) {
        MultiMap result = MultiMap.arrayListMultimap();
        ReflectUtils.scanAllAnnotationFromElements((AnnotationFinder)this.annotationFinder, this.annotationType, (AnnotatedElement[])ReflectUtils.getDeclaredFields(beanType), result::put);
        return result;
    }

    protected KeyTriggerOperation createOperation(BeanOperationParser parser, BeanOperations beanOperations, StandardAnnotation<A> standardAnnotation) {
        AnnotatedElement element = standardAnnotation.getAnnotatedElement();
        return ((SimpleKeyTriggerOperation.SimpleKeyTriggerOperationBuilder)((SimpleKeyTriggerOperation.SimpleKeyTriggerOperationBuilder)((SimpleKeyTriggerOperation.SimpleKeyTriggerOperationBuilder)((SimpleKeyTriggerOperation.SimpleKeyTriggerOperationBuilder)((SimpleKeyTriggerOperation.SimpleKeyTriggerOperationBuilder)SimpleKeyTriggerOperation.builder().id(this.parseId(standardAnnotation))).key(this.parseKey(standardAnnotation))).sort(this.parseSort(standardAnnotation))).groups(this.parseGroups(standardAnnotation))).source(element)).build();
    }

    protected String parseId(StandardAnnotation<A> standardAnnotation) {
        AnnotatedElement element = standardAnnotation.getAnnotatedElement();
        String id = standardAnnotation.getId();
        return StringUtils.isNotEmpty(id) ? id : ConfigurationUtil.getElementIdentifier(element, standardAnnotation.getKey());
    }

    protected String parseKey(StandardAnnotation<A> standardAnnotation) {
        AnnotatedElement element = standardAnnotation.getAnnotatedElement();
        return ConfigurationUtil.getElementIdentifier(element, standardAnnotation.getKey());
    }

    protected int parseSort(StandardAnnotation<A> standardAnnotation) {
        AnnotatedElement element = standardAnnotation.getAnnotatedElement();
        return Crane4jGlobalSorter.INSTANCE.getSortValue(element, standardAnnotation.getSort());
    }

    protected Set<String> parseGroups(StandardAnnotation<A> standardAnnotation) {
        return Stream.of(standardAnnotation.getGroups()).collect(Collectors.toSet());
    }

    protected abstract StandardAnnotation<A> getStandardAnnotation(BeanOperations var1, AnnotatedElement var2, A var3);

    public AbstractStandardOperationAnnotationHandler(Class<A> annotationType, AnnotationFinder annotationFinder, @org.checkerframework.checker.nullness.qual.NonNull Comparator<KeyTriggerOperation> operationComparator) {
        if (operationComparator == null) {
            throw new NullPointerException("operationComparator is marked non-null but is null");
        }
        this.annotationType = annotationType;
        this.annotationFinder = annotationFinder;
        this.operationComparator = operationComparator;
    }

    public void setOperationComparator(@org.checkerframework.checker.nullness.qual.NonNull Comparator<KeyTriggerOperation> operationComparator) {
        if (operationComparator == null) {
            throw new NullPointerException("operationComparator is marked non-null but is null");
        }
        this.operationComparator = operationComparator;
    }

    public static class StandardAnnotationAdapter<A extends Annotation>
    implements StandardAnnotation<A> {
        @NonNull
        private final AnnotatedElement annotatedElement;
        @NonNull
        private final A annotation;
        @NonNull
        private final String id;
        @NonNull
        private final String key;
        private final int sort;
        @NonNull
        private final String[] groups;

        protected StandardAnnotationAdapter(StandardAnnotationAdapterBuilder<A, ?, ?> b) {
            this.annotatedElement = ((StandardAnnotationAdapterBuilder)b).annotatedElement;
            if (this.annotatedElement == null) {
                throw new NullPointerException("annotatedElement is marked non-null but is null");
            }
            this.annotation = ((StandardAnnotationAdapterBuilder)b).annotation;
            if (this.annotation == null) {
                throw new NullPointerException("annotation is marked non-null but is null");
            }
            this.id = ((StandardAnnotationAdapterBuilder)b).id;
            if (this.id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.key = ((StandardAnnotationAdapterBuilder)b).key;
            if (this.key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.sort = ((StandardAnnotationAdapterBuilder)b).sort;
            this.groups = ((StandardAnnotationAdapterBuilder)b).groups;
            if (this.groups == null) {
                throw new NullPointerException("groups is marked non-null but is null");
            }
        }

        public static <A extends Annotation> StandardAnnotationAdapterBuilder<A, ?, ?> builder() {
            return new StandardAnnotationAdapterBuilderImpl();
        }

        @Override
        @NonNull
        public AnnotatedElement getAnnotatedElement() {
            return this.annotatedElement;
        }

        @Override
        @NonNull
        public A getAnnotation() {
            return this.annotation;
        }

        @Override
        @NonNull
        public String getId() {
            return this.id;
        }

        @Override
        @NonNull
        public String getKey() {
            return this.key;
        }

        @Override
        public int getSort() {
            return this.sort;
        }

        @Override
        @NonNull
        public String[] getGroups() {
            return this.groups;
        }

        private static final class StandardAnnotationAdapterBuilderImpl<A extends Annotation>
        extends StandardAnnotationAdapterBuilder<A, StandardAnnotationAdapter<A>, StandardAnnotationAdapterBuilderImpl<A>> {
            private StandardAnnotationAdapterBuilderImpl() {
            }

            @Override
            protected StandardAnnotationAdapterBuilderImpl<A> self() {
                return this;
            }

            @Override
            public StandardAnnotationAdapter<A> build() {
                return new StandardAnnotationAdapter(this);
            }
        }

        public static abstract class StandardAnnotationAdapterBuilder<A extends Annotation, C extends StandardAnnotationAdapter<A>, B extends StandardAnnotationAdapterBuilder<A, C, B>> {
            private AnnotatedElement annotatedElement;
            private A annotation;
            private String id;
            private String key;
            private int sort;
            private String[] groups;

            public B annotatedElement(@NonNull AnnotatedElement annotatedElement) {
                if (annotatedElement == null) {
                    throw new NullPointerException("annotatedElement is marked non-null but is null");
                }
                this.annotatedElement = annotatedElement;
                return this.self();
            }

            public B annotation(@NonNull A annotation) {
                if (annotation == null) {
                    throw new NullPointerException("annotation is marked non-null but is null");
                }
                this.annotation = annotation;
                return this.self();
            }

            public B id(@NonNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id = id;
                return this.self();
            }

            public B key(@NonNull String key) {
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                this.key = key;
                return this.self();
            }

            public B sort(int sort) {
                this.sort = sort;
                return this.self();
            }

            public B groups(@NonNull String[] groups) {
                if (groups == null) {
                    throw new NullPointerException("groups is marked non-null but is null");
                }
                this.groups = groups;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public String toString() {
                return "AbstractStandardOperationAnnotationHandler.StandardAnnotationAdapter.StandardAnnotationAdapterBuilder(annotatedElement=" + this.annotatedElement + ", annotation=" + this.annotation + ", id=" + this.id + ", key=" + this.key + ", sort=" + this.sort + ", groups=" + Arrays.deepToString(this.groups) + ")";
            }
        }
    }

    public static interface StandardAnnotation<A> {
        public AnnotatedElement getAnnotatedElement();

        public A getAnnotation();

        public String getId();

        public String getKey();

        public int getSort();

        public String[] getGroups();
    }
}

