/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler;

import cn.crane4j.annotation.Mapping;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.executor.handler.key.KeyResolver;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.PropertyMapping;
import cn.crane4j.core.parser.SimplePropertyMapping;
import cn.crane4j.core.parser.handler.AbstractStandardOperationAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.OverwriteNotNullMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.parser.operation.SimpleAssembleOperation;
import cn.crane4j.core.parser.operation.SimpleKeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStandardAssembleAnnotationHandler<A extends Annotation>
extends AbstractStandardOperationAnnotationHandler<A> {
    private static final Logger log = LoggerFactory.getLogger(AbstractStandardAssembleAnnotationHandler.class);
    protected final Crane4jGlobalConfiguration globalConfiguration;
    private final PropertyMappingStrategyManager propertyMappingStrategyManager;

    protected AbstractStandardAssembleAnnotationHandler(Class<A> annotationType, AnnotationFinder annotationFinder, @NonNull Comparator<KeyTriggerOperation> operationComparator, Crane4jGlobalConfiguration globalConfiguration, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        super(annotationType, annotationFinder, operationComparator);
        this.globalConfiguration = globalConfiguration;
        this.propertyMappingStrategyManager = propertyMappingStrategyManager;
    }

    @Override
    protected void doResolve(BeanOperations beanOperations, List<KeyTriggerOperation> operations) {
        operations.stream().map(AssembleOperation.class::cast).forEach(beanOperations::addAssembleOperations);
    }

    @Override
    protected @Nullable AssembleOperation createOperation(BeanOperationParser parser, BeanOperations beanOperations, AbstractStandardOperationAnnotationHandler.StandardAnnotation<A> standardAnnotation) {
        StandardAssembleAnnotation standardAssembleAnnotation = (StandardAssembleAnnotation)standardAnnotation;
        KeyTriggerOperation keyTriggerOperation = super.createOperation(parser, beanOperations, standardAnnotation);
        Class<?> keyType = this.parseKeyType(standardAssembleAnnotation);
        keyType = ClassUtils.isObjectOrVoid(keyType) ? null : keyType;
        AssembleOperationHandler assembleOperationHandler = this.parseAssembleOperationHandler(standardAssembleAnnotation);
        Set propertyMappings = this.parsePropertyMappings(standardAssembleAnnotation, keyTriggerOperation.getKey());
        propertyMappings = propertyMappings.isEmpty() ? (Set)CollectionUtils.newCollection(LinkedHashSet::new, new SimplePropertyMapping("", keyTriggerOperation.getKey())) : propertyMappings;
        PropertyMappingStrategy propertyMappingStrategy = this.parserPropertyMappingStrategy(standardAssembleAnnotation);
        String namespace = this.getContainerNamespace(standardAssembleAnnotation);
        SimpleKeyTriggerOperation operation = ((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)((SimpleAssembleOperation.SimpleAssembleOperationBuilder)SimpleAssembleOperation.builder().id(keyTriggerOperation.getId())).key(keyTriggerOperation.getKey())).sort(keyTriggerOperation.getSort())).groups(keyTriggerOperation.getGroups())).source(keyTriggerOperation.getSource())).keyDescription(standardAssembleAnnotation.getKeyDesc())).propertyMappings(propertyMappings)).container(namespace)).assembleOperationHandler(assembleOperationHandler)).propertyMappingStrategy(propertyMappingStrategy)).keyType(keyType)).build();
        KeyResolver keyResolver = this.determineKeyResolver(standardAssembleAnnotation, assembleOperationHandler, (AssembleOperation)((Object)operation));
        operation.setKeyResolver(keyResolver);
        return operation;
    }

    protected KeyResolver determineKeyResolver(StandardAssembleAnnotation<A> standardAssembleAnnotation, AssembleOperationHandler operationHandler, AssembleOperation operation) {
        KeyResolver keyResolver;
        Class<?> keyResolverType = standardAssembleAnnotation.getKeyResolver();
        if (Objects.isNull(keyResolverType) || ClassUtils.isObjectOrVoid(keyResolverType)) {
            keyResolver = operationHandler.determineKeyResolver(operation);
        } else {
            Asserts.isTrue(KeyResolver.class.isAssignableFrom(keyResolverType), "key resolver must be a subclass of KeyResolver: [{}]", keyResolverType);
            keyResolver = this.globalConfiguration.getKeyResolver(keyResolverType);
        }
        Asserts.isNotNull(keyResolver, "cannot determine key resolver for annotation [{}] on [{}]", ((Annotation)standardAssembleAnnotation.getAnnotation()).getClass().getSimpleName(), standardAssembleAnnotation.getAnnotatedElement());
        if (keyResolver instanceof KeyResolver.OperationAware) {
            ((KeyResolver.OperationAware)((Object)keyResolver)).setAssembleOperation(operation);
        }
        return keyResolver;
    }

    protected abstract String getContainerNamespace(StandardAssembleAnnotation<A> var1);

    @Override
    protected abstract StandardAssembleAnnotation<A> getStandardAnnotation(BeanOperations var1, AnnotatedElement var2, A var3);

    protected AssembleOperationHandler parseAssembleOperationHandler(StandardAssembleAnnotation<A> standardAnnotation) {
        return this.globalConfiguration.getAssembleOperationHandler(standardAnnotation.getHandler(), standardAnnotation.getHandlerType());
    }

    protected Set<PropertyMapping> parsePropertyMappings(StandardAssembleAnnotation<A> standardAnnotation, String key) {
        Class<?>[] propTemplates;
        List<PropertyMapping> templateMappings;
        Mapping[] props = standardAnnotation.getProps();
        Set<PropertyMapping> propertyMappings = Stream.of(props).map(m -> ConfigurationUtil.createPropertyMapping(m, key)).collect(Collectors.toSet());
        Set<PropertyMapping> propMappings = this.parsePropToMapping(standardAnnotation, key);
        if (CollectionUtils.isNotEmpty(propMappings)) {
            propertyMappings.addAll(propMappings);
        }
        if (CollectionUtils.isNotEmpty(templateMappings = ConfigurationUtil.parsePropTemplateClasses(propTemplates = standardAnnotation.getMappingTemplates(), this.annotationFinder))) {
            propertyMappings.addAll(templateMappings);
        }
        return propertyMappings;
    }

    protected Set<PropertyMapping> parsePropToMapping(StandardAssembleAnnotation<A> standardAnnotation, String key) {
        String[] props = standardAnnotation.getProp();
        return Stream.of(props).map(SimplePropertyMapping::of).collect(Collectors.toSet());
    }

    protected @NonNull PropertyMappingStrategy parserPropertyMappingStrategy(StandardAssembleAnnotation<A> standardAnnotation) {
        String propertyMappingStrategyName = standardAnnotation.getPropertyMappingStrategy();
        if (StringUtils.isEmpty(propertyMappingStrategyName)) {
            return OverwriteNotNullMappingStrategy.INSTANCE;
        }
        PropertyMappingStrategy propertyMappingStrategy = this.propertyMappingStrategyManager.getPropertyMappingStrategy(propertyMappingStrategyName);
        if (Objects.isNull(propertyMappingStrategy)) {
            propertyMappingStrategy = OverwriteNotNullMappingStrategy.INSTANCE;
            if (StringUtils.isEmpty(propertyMappingStrategyName)) {
                log.warn("unable to find property mapping strategy [{}], use default strategy [{}]", (Object)standardAnnotation.getPropertyMappingStrategy(), (Object)propertyMappingStrategy.getName());
            }
        }
        return propertyMappingStrategy;
    }

    protected @Nullable Class<?> parseKeyType(StandardAssembleAnnotation<A> standardAnnotation) {
        Class<?> keyType = standardAnnotation.getKeyType();
        return ClassUtils.isObjectOrVoid(keyType) ? null : keyType;
    }

    public static class StandardAssembleAnnotationAdapter<A extends Annotation>
    extends AbstractStandardOperationAnnotationHandler.StandardAnnotationAdapter<A>
    implements StandardAssembleAnnotation<A> {
        private final Class<?> keyType;
        private final String handler;
        private final Class<?> handlerType;
        private final Class<?>[] mappingTemplates;
        private final Mapping[] props;
        private final String[] prop;
        private final String propertyMappingStrategy;
        private final @Nullable Class<?> keyResolver;
        private final @Nullable String keyDesc;

        private static <A extends Annotation> Class<?> $default$keyType() {
            return Object.class;
        }

        private static <A extends Annotation> String $default$handler() {
            return "";
        }

        private static <A extends Annotation> Class<?> $default$handlerType() {
            return Object.class;
        }

        private static <A extends Annotation> Class<?>[] $default$mappingTemplates() {
            return new Class[0];
        }

        private static <A extends Annotation> Mapping[] $default$props() {
            return new Mapping[0];
        }

        private static <A extends Annotation> String[] $default$prop() {
            return new String[0];
        }

        private static <A extends Annotation> String $default$propertyMappingStrategy() {
            return "";
        }

        private static <A extends Annotation> Class<?> $default$keyResolver() {
            return null;
        }

        private static <A extends Annotation> String $default$keyDesc() {
            return null;
        }

        protected StandardAssembleAnnotationAdapter(StandardAssembleAnnotationAdapterBuilder<A, ?, ?> b) {
            super(b);
            this.keyType = ((StandardAssembleAnnotationAdapterBuilder)b).keyType$set ? ((StandardAssembleAnnotationAdapterBuilder)b).keyType$value : StandardAssembleAnnotationAdapter.$default$keyType();
            this.handler = ((StandardAssembleAnnotationAdapterBuilder)b).handler$set ? ((StandardAssembleAnnotationAdapterBuilder)b).handler$value : StandardAssembleAnnotationAdapter.$default$handler();
            this.handlerType = ((StandardAssembleAnnotationAdapterBuilder)b).handlerType$set ? ((StandardAssembleAnnotationAdapterBuilder)b).handlerType$value : StandardAssembleAnnotationAdapter.$default$handlerType();
            this.mappingTemplates = ((StandardAssembleAnnotationAdapterBuilder)b).mappingTemplates$set ? ((StandardAssembleAnnotationAdapterBuilder)b).mappingTemplates$value : StandardAssembleAnnotationAdapter.$default$mappingTemplates();
            this.props = ((StandardAssembleAnnotationAdapterBuilder)b).props$set ? ((StandardAssembleAnnotationAdapterBuilder)b).props$value : StandardAssembleAnnotationAdapter.$default$props();
            this.prop = ((StandardAssembleAnnotationAdapterBuilder)b).prop$set ? ((StandardAssembleAnnotationAdapterBuilder)b).prop$value : StandardAssembleAnnotationAdapter.$default$prop();
            this.propertyMappingStrategy = ((StandardAssembleAnnotationAdapterBuilder)b).propertyMappingStrategy$set ? ((StandardAssembleAnnotationAdapterBuilder)b).propertyMappingStrategy$value : StandardAssembleAnnotationAdapter.$default$propertyMappingStrategy();
            this.keyResolver = ((StandardAssembleAnnotationAdapterBuilder)b).keyResolver$set ? ((StandardAssembleAnnotationAdapterBuilder)b).keyResolver$value : StandardAssembleAnnotationAdapter.$default$keyResolver();
            this.keyDesc = ((StandardAssembleAnnotationAdapterBuilder)b).keyDesc$set ? ((StandardAssembleAnnotationAdapterBuilder)b).keyDesc$value : StandardAssembleAnnotationAdapter.$default$keyDesc();
        }

        public static <A extends Annotation> StandardAssembleAnnotationAdapterBuilder<A, ?, ?> builder() {
            return new StandardAssembleAnnotationAdapterBuilderImpl();
        }

        @Override
        public Class<?> getKeyType() {
            return this.keyType;
        }

        @Override
        public String getHandler() {
            return this.handler;
        }

        @Override
        public Class<?> getHandlerType() {
            return this.handlerType;
        }

        @Override
        public Class<?>[] getMappingTemplates() {
            return this.mappingTemplates;
        }

        @Override
        public Mapping[] getProps() {
            return this.props;
        }

        @Override
        public String[] getProp() {
            return this.prop;
        }

        @Override
        public String getPropertyMappingStrategy() {
            return this.propertyMappingStrategy;
        }

        @Override
        public @Nullable Class<?> getKeyResolver() {
            return this.keyResolver;
        }

        @Override
        public @Nullable String getKeyDesc() {
            return this.keyDesc;
        }

        private static final class StandardAssembleAnnotationAdapterBuilderImpl<A extends Annotation>
        extends StandardAssembleAnnotationAdapterBuilder<A, StandardAssembleAnnotationAdapter<A>, StandardAssembleAnnotationAdapterBuilderImpl<A>> {
            private StandardAssembleAnnotationAdapterBuilderImpl() {
            }

            @Override
            protected StandardAssembleAnnotationAdapterBuilderImpl<A> self() {
                return this;
            }

            @Override
            public StandardAssembleAnnotationAdapter<A> build() {
                return new StandardAssembleAnnotationAdapter(this);
            }
        }

        public static abstract class StandardAssembleAnnotationAdapterBuilder<A extends Annotation, C extends StandardAssembleAnnotationAdapter<A>, B extends StandardAssembleAnnotationAdapterBuilder<A, C, B>>
        extends AbstractStandardOperationAnnotationHandler.StandardAnnotationAdapter.StandardAnnotationAdapterBuilder<A, C, B> {
            private boolean keyType$set;
            private Class<?> keyType$value;
            private boolean handler$set;
            private String handler$value;
            private boolean handlerType$set;
            private Class<?> handlerType$value;
            private boolean mappingTemplates$set;
            private Class<?>[] mappingTemplates$value;
            private boolean props$set;
            private Mapping[] props$value;
            private boolean prop$set;
            private String[] prop$value;
            private boolean propertyMappingStrategy$set;
            private String propertyMappingStrategy$value;
            private boolean keyResolver$set;
            private Class<?> keyResolver$value;
            private boolean keyDesc$set;
            private String keyDesc$value;

            public B keyType(Class<?> keyType) {
                this.keyType$value = keyType;
                this.keyType$set = true;
                return (B)this.self();
            }

            public B handler(String handler) {
                this.handler$value = handler;
                this.handler$set = true;
                return (B)this.self();
            }

            public B handlerType(Class<?> handlerType) {
                this.handlerType$value = handlerType;
                this.handlerType$set = true;
                return (B)this.self();
            }

            public B mappingTemplates(Class<?>[] mappingTemplates) {
                this.mappingTemplates$value = mappingTemplates;
                this.mappingTemplates$set = true;
                return (B)this.self();
            }

            public B props(Mapping[] props) {
                this.props$value = props;
                this.props$set = true;
                return (B)this.self();
            }

            public B prop(String[] prop) {
                this.prop$value = prop;
                this.prop$set = true;
                return (B)this.self();
            }

            public B propertyMappingStrategy(String propertyMappingStrategy) {
                this.propertyMappingStrategy$value = propertyMappingStrategy;
                this.propertyMappingStrategy$set = true;
                return (B)this.self();
            }

            public B keyResolver(@Nullable Class<?> keyResolver) {
                this.keyResolver$value = keyResolver;
                this.keyResolver$set = true;
                return (B)this.self();
            }

            public B keyDesc(@Nullable String keyDesc) {
                this.keyDesc$value = keyDesc;
                this.keyDesc$set = true;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder(super=" + super.toString() + ", keyType$value=" + this.keyType$value + ", handler$value=" + this.handler$value + ", handlerType$value=" + this.handlerType$value + ", mappingTemplates$value=" + Arrays.deepToString(this.mappingTemplates$value) + ", props$value=" + Arrays.deepToString(this.props$value) + ", prop$value=" + Arrays.deepToString(this.prop$value) + ", propertyMappingStrategy$value=" + this.propertyMappingStrategy$value + ", keyResolver$value=" + this.keyResolver$value + ", keyDesc$value=" + this.keyDesc$value + ")";
            }
        }
    }

    public static interface StandardAssembleAnnotation<A extends Annotation>
    extends AbstractStandardOperationAnnotationHandler.StandardAnnotation<A> {
        public Class<?> getKeyType();

        public String getHandler();

        public Class<?> getHandlerType();

        public Class<?>[] getMappingTemplates();

        public Mapping[] getProps();

        public String[] getProp();

        public String getPropertyMappingStrategy();

        public @Nullable Class<?> getKeyResolver();

        public @Nullable String getKeyDesc();
    }
}

