/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler;

import cn.crane4j.core.container.ConfigurableContainerProvider;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.container.PartitionContainerProvider;
import cn.crane4j.core.parser.handler.AbstractStandardAssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.util.Asserts;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractInternalProviderAssembleAnnotationHandler<A extends Annotation>
extends AbstractStandardAssembleAnnotationHandler<A> {
    public static final String INTERNAL_PROVIDER_SUFFIX = ".InternalProvider";
    protected final ConfigurableContainerProvider internalContainerProvider = this.createInternalContainerProvider();

    protected AbstractInternalProviderAssembleAnnotationHandler(Class<A> annotationType, AnnotationFinder annotationFinder, @NonNull Comparator<KeyTriggerOperation> operationComparator, Crane4jGlobalConfiguration globalConfiguration, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        super(annotationType, annotationFinder, operationComparator, globalConfiguration, propertyMappingStrategyManager);
        globalConfiguration.registerContainerProvider(this.getInternalContainerProviderName(), this.internalContainerProvider);
    }

    @Override
    protected String getContainerNamespace(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<A> standardAnnotation) {
        Annotation annotation = (Annotation)standardAnnotation.getAnnotation();
        String namespace = this.determineNamespace(standardAnnotation);
        if (!this.internalContainerProvider.containsContainer(namespace)) {
            Container<Object> container = this.createContainer(standardAnnotation, namespace);
            Asserts.isNotNull(container, "cannot resolve container for annotation [{}]", annotation);
            this.internalContainerProvider.registerContainer(container);
        }
        return ContainerManager.canonicalNamespace(namespace, this.getInternalContainerProviderName());
    }

    protected abstract @NonNull Container<Object> createContainer(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<A> var1, String var2);

    protected abstract String determineNamespace(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<A> var1);

    protected @NonNull ConfigurableContainerProvider createInternalContainerProvider() {
        return new PartitionContainerProvider();
    }

    public String getInternalContainerProviderName() {
        return this.getClass().getSimpleName() + INTERNAL_PROVIDER_SUFFIX;
    }
}

