/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler.key;

import cn.crane4j.core.executor.handler.key.KeyResolver;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropertyOperator;
import java.util.Objects;

public class ReflectivePropertyKeyResolver
implements KeyResolver {
    private final PropertyOperator propertyOperator;

    public static KeyResolver create(PropertyOperator propertyOperator) {
        return new ReflectivePropertyKeyResolver(propertyOperator);
    }

    public static KeyResolver create(PropertyOperator propertyOperator, ConverterManager converterManager) {
        return new Convertible(propertyOperator, converterManager);
    }

    @Override
    public Object resolve(Object target, AssembleOperation operation) {
        return this.propertyOperator.readProperty(target.getClass(), target, operation.getKey());
    }

    private ReflectivePropertyKeyResolver(PropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
    }

    private static class Convertible
    extends ReflectivePropertyKeyResolver {
        private final ConverterManager converterManager;

        public Convertible(PropertyOperator propertyOperator, ConverterManager converterManager) {
            super(propertyOperator);
            this.converterManager = converterManager;
        }

        @Override
        public Object resolve(Object target, AssembleOperation operation) {
            Object key = super.resolve(target, operation);
            return Objects.isNull(key) ? null : this.converterManager.convert(key, operation.getKeyType());
        }
    }
}

