/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler;

import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.operation.DisassembleOperation;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;

public class ReflectiveDisassembleOperationHandler
implements DisassembleOperationHandler {
    private final PropertyOperator propertyOperator;

    @Override
    public Collection<Object> process(DisassembleOperation operation, Collection<?> targets) {
        if (CollectionUtils.isEmpty(targets)) {
            return Collections.emptyList();
        }
        MethodInvoker getter = this.propertyOperator.findGetter(operation.getSourceType(), operation.getKey());
        Asserts.isNotNull(getter, "cannot find getter for [{}] on [{}]", operation.getKey(), operation.getSourceType());
        Deque deque = targets.stream().filter(Objects::nonNull).map(x$0 -> getter.invoke(x$0, new Object[0])).collect(Collectors.toCollection(LinkedList::new));
        ArrayList<Object> result = new ArrayList<Object>();
        while (!deque.isEmpty()) {
            Object item = deque.removeFirst();
            if (Objects.isNull(item)) continue;
            if (item instanceof Collection || item.getClass().isArray()) {
                deque.addAll(CollectionUtils.adaptObjectToCollection(item));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public ReflectiveDisassembleOperationHandler(PropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
    }
}

