/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.executor.handler.AbstractAssembleOperationHandler;
import cn.crane4j.core.executor.handler.key.KeyResolver;
import cn.crane4j.core.executor.handler.key.ReflectiveSeparablePropertyKeyResolver;
import cn.crane4j.core.parser.PropertyMapping;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ManyToManyAssembleOperationHandler
extends AbstractAssembleOperationHandler {
    private static final String DEFAULT_KEY_SEPARATOR = ",";
    protected final PropertyOperator propertyOperator;
    protected final ConverterManager converterManager;

    @Override
    protected Map<Object, Object> getSourcesFromContainer(Container<?> container, Collection<AbstractAssembleOperationHandler.Target> targets) {
        Set keys = targets.stream().map(AbstractAssembleOperationHandler.Target::getKey).map(k -> (Collection)k).flatMap(Collection::stream).collect(Collectors.toSet());
        return container.get(keys);
    }

    @Override
    protected Object getTheAssociatedSource(AbstractAssembleOperationHandler.Target target, Map<Object, Object> sources) {
        return ((Collection)target.getKey()).stream().map(sources::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    protected void completeMapping(Object source, AbstractAssembleOperationHandler.Target target) {
        AssembleOperation operation = target.getExecution().getOperation();
        PropertyMappingStrategy propertyMappingStrategy = operation.getPropertyMappingStrategy();
        Collection sources = CollectionUtils.adaptObjectToCollection(source);
        Set<PropertyMapping> mappings = operation.getPropertyMappings();
        for (PropertyMapping mapping : mappings) {
            Collection sourceValues = !mapping.hasSource() ? sources : (Collection)sources.stream().map(s -> this.propertyOperator.readProperty(s.getClass(), s, mapping.getSource())).collect(Collectors.toList());
            Object origin = target.getOrigin();
            propertyMappingStrategy.doMapping(operation, origin, source, sourceValues, mapping, sv -> this.propertyOperator.writeProperty(origin.getClass(), origin, mapping.getReference(), sourceValues));
        }
    }

    @Override
    public KeyResolver determineKeyResolver(AssembleOperation operation) {
        KeyResolver specifiedkeyResolver = operation.getKeyResolver();
        if (Objects.nonNull(specifiedkeyResolver)) {
            return specifiedkeyResolver;
        }
        Asserts.isNotEmpty(operation.getKey(), "The key must be specified for the operation config on [{}]", operation.getSource());
        String separator = StringUtils.emptyToDefault(operation.getKeyDescription(), DEFAULT_KEY_SEPARATOR);
        return new ReflectiveSeparablePropertyKeyResolver(this.propertyOperator, this.converterManager, separator);
    }

    public ManyToManyAssembleOperationHandler(PropertyOperator propertyOperator, ConverterManager converterManager) {
        this.propertyOperator = propertyOperator;
        this.converterManager = converterManager;
    }
}

