/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.exception.OperationExecuteException;
import cn.crane4j.core.executor.AbstractBeanOperationRecursiveExecutor;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.BeanOperationExecutor;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class AsyncBeanOperationRecursiveExecutor
extends AbstractBeanOperationRecursiveExecutor {
    private final Executor executor;

    public AsyncBeanOperationRecursiveExecutor(ContainerManager containerManager, Executor executor) {
        super(containerManager);
        this.executor = executor;
    }

    @Override
    protected void doExecuteAssembleOperations(List<AssembleExecution> executions, BeanOperationExecutor.Options options) throws OperationExecuteException {
        CompletableFuture[] tasks = (CompletableFuture[])executions.stream().map(execution -> () -> this.doExecuteOperations((AssembleExecution)execution)).map(task -> CompletableFuture.runAsync(task, this.executor)).toArray(CompletableFuture[]::new);
        try {
            CompletableFuture.allOf(tasks).join();
        }
        catch (Exception e) {
            throw new OperationExecuteException(e);
        }
    }

    private void doExecuteOperations(AssembleExecution execution) {
        Container<?> container = execution.getContainer();
        AsyncBeanOperationRecursiveExecutor.tryExecuteAssembleExecution(execution.getHandler(), container, Collections.singletonList(execution));
    }
}

