/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.exception.OperationExecuteException;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.MultiMap;
import cn.crane4j.core.util.TimerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanOperationExecutor
implements BeanOperationExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractBeanOperationExecutor.class);
    protected final ContainerManager containerManager;
    protected int batchSize = -1;
    protected boolean enableExecuteNotActiveOperation = false;

    @Override
    public void execute(Collection<?> targets, BeanOperations operations, BeanOperationExecutor.Options options) {
        if (CollectionUtils.isEmpty(targets) || Objects.isNull(operations)) {
            return;
        }
        if (!operations.isActive() && !this.enableExecuteNotActiveOperation) {
            log.warn("bean operation of [{}] is still not ready, abort execution of the operation", (Object)operations.getSource());
            return;
        }
        this.doExecute(targets, operations, options);
    }

    public abstract void doExecute(@NonNull Collection<?> var1, @NonNull BeanOperations var2, BeanOperationExecutor.Options var3);

    protected final MultiMap<BeanOperations, Object> executeDisassembleOperations(BeanOperations operations, BeanOperationExecutor.Options options, MultiMap<BeanOperations, Object> targetWithOps) {
        targetWithOps.asMap().forEach((ops, targets) -> this.beforeDisassembleOperation((Collection<?>)targets, operations, options));
        Predicate<? super KeyTriggerOperation> filter = options.getFilter();
        return TimerUtil.getExecutionTime(log.isDebugEnabled(), time -> log.debug("disassemble operations completed in {} ms", (Object)time), () -> this.doExecuteDisassembleOperations(filter, targetWithOps));
    }

    protected abstract MultiMap<BeanOperations, Object> doExecuteDisassembleOperations(Predicate<? super KeyTriggerOperation> var1, MultiMap<BeanOperations, Object> var2);

    protected final void executeAssembleOperations(BeanOperationExecutor.Options options, MultiMap<BeanOperations, Object> targetWithOps) {
        this.beforeAssembleOperation(targetWithOps);
        ArrayList executions = new ArrayList();
        Predicate<? super KeyTriggerOperation> filter = options.getFilter();
        targetWithOps.asMap().forEach((op, ts) -> {
            List<AssembleExecution> executionsOfOp = this.combineExecutions(options, filter, (BeanOperations)op, (Collection<Object>)ts);
            if (CollectionUtils.isNotEmpty(executionsOfOp)) {
                executions.addAll(executionsOfOp);
            }
        });
        TimerUtil.getExecutionTime(log.isDebugEnabled(), time -> log.debug("assemble operations completed in {} ms", (Object)time), () -> this.doExecuteAssembleOperations(executions, options));
    }

    protected abstract void doExecuteAssembleOperations(List<AssembleExecution> var1, BeanOperationExecutor.Options var2) throws OperationExecuteException;

    private @NonNull List<AssembleExecution> combineExecutions(BeanOperationExecutor.Options options, Predicate<? super KeyTriggerOperation> filter, BeanOperations beanOperations, Collection<Object> targets) {
        List<Collection<Object>> batches = this.batchSize > 1 ? CollectionUtils.split(targets, this.batchSize) : Collections.singletonList(targets);
        return batches.stream().map(batch -> this.doCombineExecutions(options, filter, beanOperations, (Collection<Object>)batch)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected @NonNull List<AssembleExecution> doCombineExecutions(BeanOperationExecutor.Options options, Predicate<? super KeyTriggerOperation> filter, BeanOperations beanOperations, Collection<Object> targets) {
        return beanOperations.getAssembleOperations().stream().filter(filter).map(p -> this.createAssembleExecution(beanOperations, (AssembleOperation)p, targets, options)).collect(Collectors.toList());
    }

    private AssembleExecution createAssembleExecution(BeanOperations beanOperations, AssembleOperation operation, Collection<Object> targets, BeanOperationExecutor.Options options) {
        targets = this.filterTargetsForSupportedOperation(targets, operation);
        String namespace = operation.getContainer();
        Container<?> container = options.getContainer(this.containerManager, namespace);
        Asserts.isNotNull(container, "container [{}] not found", namespace);
        return AssembleExecution.create(beanOperations, operation, container, targets);
    }

    protected void beforeAssembleOperation(MultiMap<BeanOperations, Object> targetWithOperations) {
    }

    protected void beforeDisassembleOperation(Collection<?> targets, BeanOperations operations, BeanOperationExecutor.Options options) {
    }

    protected void afterOperationsCompletion(MultiMap<BeanOperations, Object> targetWithOperations) {
    }

    protected <T> @NonNull Collection<T> filterTargetsForSupportedOperation(Collection<T> targets, KeyTriggerOperation operation) {
        return targets;
    }

    protected static void tryExecuteAssembleExecution(AssembleOperationHandler handler, Container<?> container, Collection<AssembleExecution> executions) {
        try {
            handler.process(container, executions);
        }
        catch (Exception ex) {
            log.warn("execute operation fail: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public AbstractBeanOperationExecutor(ContainerManager containerManager) {
        this.containerManager = containerManager;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setEnableExecuteNotActiveOperation(boolean enableExecuteNotActiveOperation) {
        this.enableExecuteNotActiveOperation = enableExecuteNotActiveOperation;
    }
}

