/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.ConstantContainerBuilder;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.EnumContainerBuilder;
import cn.crane4j.core.container.ImmutableMapContainer;
import cn.crane4j.core.container.LambdaContainer;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.DataProvider;
import cn.crane4j.core.support.SimpleAnnotationFinder;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.Asserts;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class Containers {
    public static <K> Container<K> empty() {
        return Container.empty();
    }

    public static <K> Container<K> empty(String namespace) {
        Containers.checkNamespace(namespace);
        return Containers.forMap(namespace, Collections.emptyMap());
    }

    public static <K> ImmutableMapContainer<K> forMap(String namespace, Map<K, ?> data) {
        Containers.checkNamespace(namespace);
        return ImmutableMapContainer.forMap(namespace, data);
    }

    public static <K> ImmutableMapContainer<K> forEmptyData(String namespace) {
        Containers.checkNamespace(namespace);
        return ImmutableMapContainer.forMap(namespace, Collections.emptyMap());
    }

    public static <K> LambdaContainer<K> forLambda(String namespace, DataProvider<K, ?> lambda) {
        Containers.checkNamespace(namespace);
        return LambdaContainer.forLambda(namespace, lambda);
    }

    public static Container<Object> forConstantClass(Class<?> constantClass, AnnotationFinder annotationFinder) {
        return ConstantContainerBuilder.of(constantClass).annotationFinder(annotationFinder).build();
    }

    public static Container<Object> forConstantClass(Class<?> constantClass) {
        return Containers.forConstantClass(constantClass, SimpleAnnotationFinder.INSTANCE);
    }

    public static <K, T extends Enum<?>> Container<K> forEnum(String namespace, Class<T> enumType, Function<? super T, K> keyGetter) {
        return EnumContainerBuilder.of(enumType).enableContainerEnumAnnotation(false).namespace(namespace).keyGetter(keyGetter).build();
    }

    public static <K> Container<K> forEnum(Class<? extends Enum<?>> enumType, AnnotationFinder annotationFinder, PropertyOperator propertyOperator) {
        return EnumContainerBuilder.of(enumType).annotationFinder(annotationFinder).propertyOperator(propertyOperator).build();
    }

    public static <K> Container<K> forEnum(Class<? extends Enum<?>> enumType) {
        return Containers.forEnum(enumType, SimpleAnnotationFinder.INSTANCE, ReflectivePropertyOperator.INSTANCE);
    }

    private static void checkNamespace(String namespace) {
        Asserts.isNotEmpty(namespace, "namespace must not be empty", new Object[0]);
    }

    private Containers() {
    }
}

