/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.ConfigurableContainerProvider;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDefinition;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.LimitedContainer;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import cn.crane4j.core.util.StringUtils;
import java.util.Collection;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ContainerManager
extends ConfigurableContainerProvider {
    public static final String PROVIDER_NAME_PREFIX = "&&";

    public static String canonicalNamespace(String namespace, @Nullable String providerName) {
        return StringUtils.isEmpty(providerName) ? namespace : providerName + PROVIDER_NAME_PREFIX + namespace;
    }

    public void clear();

    public boolean registerContainerLifecycleProcessor(ContainerLifecycleProcessor var1);

    public Collection<ContainerLifecycleProcessor> getContainerLifecycleProcessors();

    public void registerContainerProvider(String var1, ContainerProvider var2);

    public <T extends ContainerProvider> @Nullable T getContainerProvider(String var1);

    public ContainerDefinition registerContainer(ContainerDefinition var1);

    default public ContainerDefinition registerContainer(String namespace, Supplier<Container<Object>> factory) {
        ContainerDefinition.SimpleContainerDefinition definition = new ContainerDefinition.SimpleContainerDefinition(namespace, null, factory);
        return this.registerContainer(definition);
    }

    @Override
    default public ContainerDefinition registerContainer(@NonNull Container<?> container) {
        ContainerDefinition definition = this.registerContainer(container.getNamespace(), () -> container);
        definition.setLimited(container instanceof LimitedContainer);
        return definition;
    }

    @Override
    public <K> @Nullable Container<K> getContainer(String var1);

    public Collection<Container<Object>> getAllLimitedContainers();

    default public <K> @Nullable Container<K> getContainer(String providerName, String namespace) {
        return this.getContainer(ContainerManager.canonicalNamespace(namespace, providerName));
    }
}

