/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.condition;

import cn.crane4j.annotation.condition.ConditionType;
import cn.crane4j.core.condition.Condition;
import cn.crane4j.core.condition.ConditionParser;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.util.ArrayUtils;
import cn.crane4j.core.util.CollectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractConditionParser<A extends Annotation>
implements ConditionParser {
    private final Set<AnnotatedElement> ignored = Collections.newSetFromMap(CollectionUtils.newWeakConcurrentMap());
    private final AnnotationFinder annotationFinder;
    protected final Class<A> annotationType;

    @Override
    public final @NonNull List<Condition> parse(AnnotatedElement element, KeyTriggerOperation operation) {
        if (this.ignored.contains(element)) {
            return Collections.emptyList();
        }
        List<Condition> results = this.doParse(element, operation);
        if (results.isEmpty()) {
            this.ignored.add(element);
            return Collections.emptyList();
        }
        return results;
    }

    private @NonNull List<Condition> doParse(AnnotatedElement element, KeyTriggerOperation operation) {
        Set<A> annotations = this.annotationFinder.getAllAnnotations(element, this.annotationType);
        if (annotations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Condition> results = new ArrayList<Condition>();
        annotations.forEach(annotation -> {
            ConditionDescriptor descriptor = this.getConditionDescriptor(annotation);
            if (!this.canApply(annotation, descriptor.getBoundOperationIds(), operation)) {
                return;
            }
            AbstractCondition condition = this.createCondition(element, annotation);
            if (Objects.isNull(condition)) {
                return;
            }
            condition.setSort(descriptor.getSort()).setType(descriptor.getType());
            results.add(descriptor.isNegate() ? condition.negate() : condition);
        });
        return results;
    }

    protected boolean canApply(A annotation, String[] boundOperationIds, KeyTriggerOperation operation) {
        return ArrayUtils.isEmpty(boundOperationIds) || ArrayUtils.contains(boundOperationIds, operation.getId());
    }

    protected abstract @Nullable AbstractCondition createCondition(AnnotatedElement var1, A var2);

    protected @NonNull ConditionDescriptor getConditionDescriptor(A annotation) {
        return new ConditionDescriptor();
    }

    public AbstractConditionParser(AnnotationFinder annotationFinder, Class<A> annotationType) {
        this.annotationFinder = annotationFinder;
        this.annotationType = annotationType;
    }

    protected static class ConditionDescriptor {
        private static final String[] EMPTY_ID_ARRAY = new String[0];
        private String[] boundOperationIds;
        private ConditionType type;
        private boolean negate;
        private int sort;

        private static String[] $default$boundOperationIds() {
            return EMPTY_ID_ARRAY;
        }

        private static ConditionType $default$type() {
            return ConditionType.AND;
        }

        private static boolean $default$negate() {
            return false;
        }

        private static int $default$sort() {
            return Integer.MAX_VALUE;
        }

        protected ConditionDescriptor(ConditionDescriptorBuilder<?, ?> b) {
            this.boundOperationIds = ((ConditionDescriptorBuilder)b).boundOperationIds$set ? ((ConditionDescriptorBuilder)b).boundOperationIds$value : ConditionDescriptor.$default$boundOperationIds();
            this.type = ((ConditionDescriptorBuilder)b).type$set ? ((ConditionDescriptorBuilder)b).type$value : ConditionDescriptor.$default$type();
            this.negate = ((ConditionDescriptorBuilder)b).negate$set ? ((ConditionDescriptorBuilder)b).negate$value : ConditionDescriptor.$default$negate();
            this.sort = ((ConditionDescriptorBuilder)b).sort$set ? ((ConditionDescriptorBuilder)b).sort$value : ConditionDescriptor.$default$sort();
        }

        public static ConditionDescriptorBuilder<?, ?> builder() {
            return new ConditionDescriptorBuilderImpl();
        }

        public String[] getBoundOperationIds() {
            return this.boundOperationIds;
        }

        public ConditionType getType() {
            return this.type;
        }

        public boolean isNegate() {
            return this.negate;
        }

        public int getSort() {
            return this.sort;
        }

        public ConditionDescriptor() {
            this.boundOperationIds = ConditionDescriptor.$default$boundOperationIds();
            this.type = ConditionDescriptor.$default$type();
            this.negate = ConditionDescriptor.$default$negate();
            this.sort = ConditionDescriptor.$default$sort();
        }

        private static final class ConditionDescriptorBuilderImpl
        extends ConditionDescriptorBuilder<ConditionDescriptor, ConditionDescriptorBuilderImpl> {
            private ConditionDescriptorBuilderImpl() {
            }

            @Override
            protected ConditionDescriptorBuilderImpl self() {
                return this;
            }

            @Override
            public ConditionDescriptor build() {
                return new ConditionDescriptor(this);
            }
        }

        public static abstract class ConditionDescriptorBuilder<C extends ConditionDescriptor, B extends ConditionDescriptorBuilder<C, B>> {
            private boolean boundOperationIds$set;
            private String[] boundOperationIds$value;
            private boolean type$set;
            private ConditionType type$value;
            private boolean negate$set;
            private boolean negate$value;
            private boolean sort$set;
            private int sort$value;

            public B boundOperationIds(String[] boundOperationIds) {
                this.boundOperationIds$value = boundOperationIds;
                this.boundOperationIds$set = true;
                return this.self();
            }

            public B type(ConditionType type) {
                this.type$value = type;
                this.type$set = true;
                return this.self();
            }

            public B negate(boolean negate) {
                this.negate$value = negate;
                this.negate$set = true;
                return this.self();
            }

            public B sort(int sort) {
                this.sort$value = sort;
                this.sort$set = true;
                return this.self();
            }

            protected abstract B self();

            public abstract C build();

            public String toString() {
                return "AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder(boundOperationIds$value=" + Arrays.deepToString(this.boundOperationIds$value) + ", type$value=" + this.type$value + ", negate$value=" + this.negate$value + ", sort$value=" + this.sort$value + ")";
            }
        }
    }

    protected static abstract class AbstractCondition
    implements Condition {
        private ConditionType type = ConditionType.AND;
        private int sort = Integer.MAX_VALUE;

        protected AbstractCondition() {
        }

        @Override
        public ConditionType getType() {
            return this.type;
        }

        @Override
        public int getSort() {
            return this.sort;
        }

        private AbstractCondition setType(ConditionType type) {
            this.type = type;
            return this;
        }

        private AbstractCondition setSort(int sort) {
            this.sort = sort;
            return this;
        }
    }
}

