/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.cache;

import cn.crane4j.core.cache.AbstractCacheManager;
import cn.crane4j.core.util.Asserts;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GuavaCacheManager
extends AbstractCacheManager {
    private @NonNull CacheFactory cacheFactory = DefaultCacheFactory.INSTANCE;

    @Override
    public String getName() {
        return "GuavaCacheManager";
    }

    protected <K> @NonNull GuavaCacheObject<K> doCreateCache(String name, Long expireTime, TimeUnit timeUnit) {
        Cache<Object, Object> cache = this.cacheFactory.getCache(expireTime, timeUnit);
        Asserts.isNotNull(cache, "Cache factory must not be null", new Object[0]);
        return new GuavaCacheObject(name, cache);
    }

    public void setCacheFactory(@NonNull CacheFactory cacheFactory) {
        if (cacheFactory == null) {
            throw new NullPointerException("cacheFactory is marked non-null but is null");
        }
        this.cacheFactory = cacheFactory;
    }

    protected static class GuavaCacheObject<K>
    extends AbstractCacheManager.AbstractCacheObject<K> {
        private final Cache<Object, Object> cache;

        public GuavaCacheObject(String name, Cache<Object, Object> cache) {
            super(name);
            this.cache = cache;
        }

        @Override
        public @Nullable Object get(K key) {
            return this.cache.getIfPresent(key);
        }

        @Override
        public void put(K key, Object value) {
            this.cache.put(key, value);
        }

        @Override
        public void putIfAbsent(K key, Object value) {
            this.cache.get(key, () -> value);
        }

        @Override
        public void remove(K key) {
            this.cache.invalidate(key);
        }

        @Override
        public void clear() {
            this.cache.invalidateAll();
        }
    }

    public static class DefaultCacheFactory
    implements CacheFactory {
        public static final DefaultCacheFactory INSTANCE = new DefaultCacheFactory();

        @Override
        public Cache<Object, Object> getCache(Long expireTime, TimeUnit timeUnit) {
            Asserts.isNotEquals(expireTime, 0L, "Expire time must not be 0", new Object[0]);
            if (expireTime > 0L) {
                return CacheBuilder.newBuilder().expireAfterWrite(expireTime.longValue(), timeUnit).build();
            }
            return CacheBuilder.newBuilder().weakValues().build();
        }
    }

    @FunctionalInterface
    public static interface CacheFactory {
        public Cache<Object, Object> getCache(Long var1, TimeUnit var2);
    }
}

