/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.cache;

import cn.crane4j.annotation.ContainerCache;
import cn.crane4j.core.cache.CacheDefinition;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.cache.CacheableContainer;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDefinition;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.util.StringUtils;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableContainerProcessor
implements ContainerLifecycleProcessor {
    private static final Logger log = LoggerFactory.getLogger(CacheableContainerProcessor.class);
    protected final Crane4jGlobalConfiguration configuration;
    private @NonNull CacheDefinitionRetriever cacheDefinitionRetriever = (definition, container) -> null;

    @Override
    public @Nullable Container<Object> whenCreated(ContainerDefinition definition, Container<Object> container) {
        CacheDefinition cacheDefinition = this.retrieveCacheDefinition(definition, container);
        if (Objects.isNull(cacheDefinition)) {
            return container;
        }
        Long expireTime = cacheDefinition.getExpireTime();
        TimeUnit timeUnit = cacheDefinition.getTimeUnit();
        log.info("apply cache to container [{}], expire time is [{}] {}", new Object[]{cacheDefinition.getName(), expireTime, timeUnit.name().toLowerCase()});
        String cacheManagerName = StringUtils.emptyToDefault(cacheDefinition.getCacheManager(), "MapCacheManager");
        CacheManager cacheManager = this.configuration.getCacheManager(cacheManagerName);
        container = new CacheableContainer<Object>(container, cacheDefinition, cacheManager);
        return container;
    }

    private @Nullable CacheDefinition retrieveCacheDefinition(ContainerDefinition definition, Container<Object> container) {
        CacheDefinition cacheDefinition = this.cacheDefinitionRetriever.retrieve(definition, container);
        if (Objects.nonNull(cacheDefinition)) {
            return cacheDefinition;
        }
        return this.getCacheDefinitionFromContainer(container);
    }

    protected CacheDefinition getCacheDefinitionFromContainer(Container<Object> container) {
        ContainerCache annotation = container.getClass().getAnnotation(ContainerCache.class);
        return Objects.isNull(annotation) ? null : new CacheDefinition.Impl(container.getNamespace(), annotation.cacheManager(), annotation.expirationTime(), annotation.timeUnit());
    }

    public CacheableContainerProcessor(Crane4jGlobalConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setCacheDefinitionRetriever(@NonNull CacheDefinitionRetriever cacheDefinitionRetriever) {
        if (cacheDefinitionRetriever == null) {
            throw new NullPointerException("cacheDefinitionRetriever is marked non-null but is null");
        }
        this.cacheDefinitionRetriever = cacheDefinitionRetriever;
    }

    @FunctionalInterface
    public static interface CacheDefinitionRetriever {
        public CacheDefinition retrieve(ContainerDefinition var1, Container<Object> var2);
    }
}

