/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.cache;

import cn.crane4j.core.cache.AbstractCacheManager;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractMapCacheManager
extends AbstractCacheManager {
    public static AbstractMapCacheManager newConcurrentHashMapCacheManager() {
        return new ConcurrentHashMapCacheManager();
    }

    public static AbstractMapCacheManager newWeakConcurrentMapCacheManager() {
        return new WeakConcurrentMapCacheManager();
    }

    protected <K> @NonNull MapCacheObject<K> doCreateCache(String name, Long expireTime, TimeUnit timeUnit) {
        return new MapCacheObject<K>(name, this.createMap());
    }

    protected abstract <K> Map<K, Object> createMap();

    public static class WeakConcurrentMapCacheManager
    extends AbstractMapCacheManager {
        @Override
        public String getName() {
            return "MapCacheManager";
        }

        @Override
        protected <K> Map<K, Object> createMap() {
            return CollectionUtils.newWeakConcurrentMap();
        }
    }

    public static class ConcurrentHashMapCacheManager
    extends AbstractMapCacheManager {
        @Override
        protected <K> Map<K, Object> createMap() {
            return new ConcurrentHashMap(16);
        }
    }

    protected static class MapCacheObject<K>
    extends AbstractCacheManager.AbstractCacheObject<K> {
        private final Map<K, Object> map;

        public MapCacheObject(String name, Map<K, Object> map) {
            super(name);
            this.map = map;
        }

        @Override
        public @Nullable Object get(K key) {
            return this.map.get(key);
        }

        @Override
        public void put(K key, Object value) {
            this.map.put(key, value);
        }

        @Override
        public void putIfAbsent(K key, Object value) {
            this.map.putIfAbsent(key, value);
        }

        @Override
        public void remove(K key) {
            this.map.remove(key);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

