/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util.cms;

import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.cms.CMSException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Base64;

public class CMSEnvelopedData {
    private final EnvelopedData envelopedData;

    public static CMSEnvelopedData getInstance(byte[] envelopedDataData) {
        ContentInfo contentInfo = ContentInfo.getInstance(envelopedDataData);
        if (!contentInfo.getContentType().equals(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.3")) && !contentInfo.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            throw new IllegalArgumentException("Argument \"envelopedDataData\" is illegal");
        }
        return new CMSEnvelopedData(EnvelopedData.getInstance(contentInfo.getContent()));
    }

    public static CMSEnvelopedData getInstance(String envelopedDataData) {
        return CMSEnvelopedData.getInstance(Base64.decode(envelopedDataData));
    }

    public int getVersion() {
        return this.envelopedData.getVersion().intValueExact();
    }

    public byte[] getContent(byte[] recipientCertificateData, Function<byte[][], byte[]> cipherFunction) throws CMSException {
        Certificate recipientCertificate = Certificate.getInstance(recipientCertificateData);
        CMSEnvelopedData.checkRecipientCertificate(recipientCertificate);
        CMSEnvelopedData.getRecipientPublicKeyData(recipientCertificate);
        EncryptedContentInfo encryptedContentInfo = this.envelopedData.getEncryptedContentInfo();
        if (!encryptedContentInfo.getContentType().equals(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"))) {
            throw new CMSException("Invalid content");
        }
        if (!encryptedContentInfo.getContentEncryptionAlgorithm().getAlgorithm().equals(GMObjectIdentifiers.sms4_cbc)) {
            throw new CMSException("Invalid content encryption algorithm");
        }
        ASN1Encodable parameter = encryptedContentInfo.getContentEncryptionAlgorithm().getParameters();
        if (null == parameter || parameter instanceof ASN1Null || !(parameter instanceof ASN1OctetString)) {
            throw new CMSException("Invalid content encryption algorithm iv");
        }
        byte[] iv = ((ASN1OctetString)parameter).getOctets();
        byte[] encryptedContent = encryptedContentInfo.getEncryptedContent().getOctets();
        if (null == iv || iv.length < 1 || null == encryptedContent || encryptedContent.length < 1 || encryptedContent.length % iv.length != 0) {
            throw new CMSException("Invalid encrypted content");
        }
        for (ASN1Encodable element : this.envelopedData.getRecipientInfos()) {
            byte[] encryptedKey;
            ASN1Encodable recipientInfo = RecipientInfo.getInstance(element).getInfo();
            if (!(recipientInfo instanceof KeyTransRecipientInfo)) {
                throw new CMSException("Invalid recipient info");
            }
            KeyTransRecipientInfo keyTransRecipientInfo = (KeyTransRecipientInfo)recipientInfo;
            if (0 != keyTransRecipientInfo.getVersion().intValueExact()) {
                throw new CMSException("Invalid key trans recipient info");
            }
            if (keyTransRecipientInfo.getRecipientIdentifier().isTagged()) {
                throw new CMSException("Invalid recipient identifier");
            }
            if (!IssuerAndSerialNumber.getInstance(keyTransRecipientInfo.getRecipientIdentifier().getId()).equals(new IssuerAndSerialNumber(recipientCertificate))) continue;
            if (!keyTransRecipientInfo.getKeyEncryptionAlgorithm().getAlgorithm().equals(GMObjectIdentifiers.sm2encrypt)) {
                throw new CMSException("Invalid key encryption algorithm");
            }
            try {
                encryptedKey = ConversionUtils.SM2CipherData.fromGMT0009(keyTransRecipientInfo.getEncryptedKey().getOctets());
            }
            catch (Exception e) {
                throw new CMSException("Invalid encrypted key data");
            }
            try {
                return cipherFunction.apply(new byte[][]{encryptedKey, iv, encryptedContent});
            }
            catch (Exception e) {
                throw new RuntimeException("Decrypt failed", e);
            }
        }
        throw new CMSException("No recipient found");
    }

    public byte[] getEncoded() {
        try {
            return new ContentInfo(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.3"), this.envelopedData).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private static void checkRecipientCertificate(Certificate recipientCertificate) throws CMSException {
        if (!recipientCertificate.getSignatureAlgorithm().equals(recipientCertificate.getTBSCertificate().getSignature())) {
            throw new CMSException("Invalid recipient certificate");
        }
        if (!KeyUsage.fromExtensions(recipientCertificate.getTBSCertificate().getExtensions()).hasUsages(32)) {
            throw new CMSException("Invalid public key usage of recipient certificate");
        }
    }

    private static byte[] getRecipientPublicKeyData(Certificate recipientCertificate) throws CMSException {
        byte[] publicKeyData = recipientCertificate.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        AlgorithmIdentifier algorithmIdentifier = recipientCertificate.getSubjectPublicKeyInfo().getAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey) || (algorithmIdentifier.getParameters() instanceof ASN1ObjectIdentifier ? algorithmIdentifier.getParameters().equals(GMObjectIdentifiers.sm2p256v1) : algorithmIdentifier.getParameters().equals(new X962Parameters(GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1))))) {
            if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
                throw new CMSException("Invalid public key of recipient certificate");
            }
        } else {
            throw new CMSException("Invalid public key algorithm of recipient certificate");
        }
        return publicKeyData;
    }

    private CMSEnvelopedData(EnvelopedData envelopedData) {
        this.envelopedData = envelopedData;
    }

    public static class Generator {
        private ArrayList<Certificate> recipientCertificates = new ArrayList();
        private ArrayList<byte[]> recipientPublicKeyDatas = new ArrayList();

        public Generator addRecipient(byte[] recipientCertificateData) throws CMSException {
            Certificate recipientCertificate = Certificate.getInstance(recipientCertificateData);
            CMSEnvelopedData.checkRecipientCertificate(recipientCertificate);
            this.recipientCertificates.add(recipientCertificate);
            this.recipientPublicKeyDatas.add(CMSEnvelopedData.getRecipientPublicKeyData(recipientCertificate));
            return this;
        }

        public Generator addRecipient(String recipientCertificateData) throws CMSException {
            return this.addRecipient(Base64.decode(recipientCertificateData));
        }

        public CMSEnvelopedData generate(Function<byte[], byte[][]> cipherFunction) throws CMSException {
            byte[][] encryptedDatas;
            if (this.recipientCertificates.isEmpty()) {
                throw new CMSException("There is no recipient");
            }
            if (this.recipientCertificates.size() > 1) {
                throw new CMSException("There are too many recipients");
            }
            ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
            try {
                encryptedDatas = cipherFunction.apply(this.recipientPublicKeyDatas.get(0));
            }
            catch (Exception e) {
                throw new RuntimeException("Encrypt and wrap failed", e);
            }
            try {
                encryptedDatas[0] = ConversionUtils.SM2CipherData.toGMT0009(encryptedDatas[0]);
            }
            catch (Exception e) {
                throw new CMSException("Invalid encrypted key data");
            }
            recipientInfos.add(new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(new IssuerAndSerialNumber(this.recipientCertificates.get(0))), new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt), new DEROctetString(encryptedDatas[0]))));
            if (null == encryptedDatas[1] || encryptedDatas[1].length < 1 || null == encryptedDatas[2] || encryptedDatas[2].length < 1 || encryptedDatas[2].length % encryptedDatas[1].length != 0) {
                throw new CMSException("Invalid encrypted content");
            }
            EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), new AlgorithmIdentifier(GMObjectIdentifiers.sms4_cbc, new DEROctetString(encryptedDatas[1])), new BEROctetString(encryptedDatas[2]));
            return new CMSEnvelopedData(new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), encryptedContentInfo, (ASN1Set)null));
        }

        public CMSEnvelopedData generate(BiFunction<Integer, byte[], byte[]> wrapperFunction, Supplier<byte[][]> cipherFunction) throws CMSException {
            byte[][] encryptedDatas;
            if (this.recipientCertificates.isEmpty()) {
                throw new CMSException("There is no recipient");
            }
            ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
            for (int i = 0; i < this.recipientCertificates.size(); ++i) {
                byte[] encryptedKey;
                try {
                    encryptedKey = wrapperFunction.apply(i, this.recipientPublicKeyDatas.get(i));
                }
                catch (Exception e) {
                    throw new RuntimeException("Wrap failed", e);
                }
                try {
                    encryptedKey = ConversionUtils.SM2CipherData.toGMT0009(encryptedKey);
                }
                catch (Exception e) {
                    throw new CMSException("Invalid encrypted key data");
                }
                recipientInfos.add(new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(new IssuerAndSerialNumber(this.recipientCertificates.get(i))), new AlgorithmIdentifier(GMObjectIdentifiers.sm2encrypt), new DEROctetString(encryptedKey))));
            }
            try {
                encryptedDatas = cipherFunction.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Encrypt failed", e);
            }
            if (null == encryptedDatas[0] || encryptedDatas[0].length < 1 || null == encryptedDatas[1] || encryptedDatas[1].length < 1 || encryptedDatas[1].length % encryptedDatas[0].length != 0) {
                throw new CMSException("Invalid encrypted content");
            }
            EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), new AlgorithmIdentifier(GMObjectIdentifiers.sms4_cbc, new DEROctetString(encryptedDatas[0])), new BEROctetString(encryptedDatas[1]));
            return new CMSEnvelopedData(new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), encryptedContentInfo, (ASN1Set)null));
        }
    }
}

