/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util.cert;

import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.SignatureUtils;
import cn.com.westone.wcspsdk.util.cert.CertificateException;
import cn.com.westone.wcspsdk.util.cert.X501DName;
import java.io.IOException;
import java.util.function.Function;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Base64;

public class PKCS10CSRequest {
    private final CertificationRequest csr;

    public static PKCS10CSRequest getInstance(byte[] csrData) {
        return new PKCS10CSRequest(CertificationRequest.getInstance(csrData));
    }

    public static PKCS10CSRequest getInstance(String csrData) {
        return PKCS10CSRequest.getInstance(Base64.decode(csrData));
    }

    public int getVersion() {
        return this.csr.getCertificationRequestInfo().getVersion().intValueExact() + 1;
    }

    public String getSubject() {
        return this.getSubjectDN().getAttributeValue(X501DName.AttrType.CN);
    }

    public X501DName getSubjectDN() {
        return new X501DName(this.csr.getCertificationRequestInfo().getSubject());
    }

    public byte[] getSubjectPublicKeyData() throws CertificateException {
        byte[] publicKeyData = this.csr.getCertificationRequestInfo().getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        AlgorithmIdentifier algorithmIdentifier = this.csr.getCertificationRequestInfo().getSubjectPublicKeyInfo().getAlgorithm();
        if (algorithmIdentifier.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey) && (algorithmIdentifier.getParameters() instanceof ASN1ObjectIdentifier ? algorithmIdentifier.getParameters().equals(GMObjectIdentifiers.sm2p256v1) : algorithmIdentifier.getParameters().equals(new X962Parameters(GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1)))) && !ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
            throw new CertificateException("Invalid subject public key");
        }
        return publicKeyData;
    }

    public String getSigAlgName() {
        String algOID;
        switch (algOID = this.getSigAlgOID()) {
            case "1.2.156.10197.1.501": {
                return "SM3withSM2";
            }
            case "1.2.156.10197.1.504": {
                return "SM3withRSA";
            }
        }
        return algOID;
    }

    public String getSigAlgOID() {
        return this.csr.getSignatureAlgorithm().getAlgorithm().getId();
    }

    public byte[] getSignature() throws CertificateException {
        byte[] signatureData = this.csr.getSignature().getOctets();
        ASN1ObjectIdentifier algorithmOID = this.csr.getSignatureAlgorithm().getAlgorithm();
        if (algorithmOID.equals(GMObjectIdentifiers.sm2sign_with_sm3) || algorithmOID.equals(GMObjectIdentifiers.sm2sign_with_sha512)) {
            try {
                signatureData = ConversionUtils.SM2SignatureData.fromGMT0009(signatureData);
            }
            catch (Exception e) {
                throw new CertificateException("Invalid signature");
            }
        }
        return signatureData;
    }

    public boolean verify(byte[] subjectPublicKeyData) throws CertificateException {
        byte[] csrInfoData;
        if (!this.csr.getSignatureAlgorithm().getAlgorithm().equals(GMObjectIdentifiers.sm2sign_with_sm3)) {
            throw new CertificateException("Invalid signature algorithm");
        }
        try {
            csrInfoData = this.csr.getCertificationRequestInfo().getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        byte[] signatureData = ConversionUtils.SM2SignatureData.fromGMT0009(this.csr.getSignature().getOctets());
        return SignatureUtils.sm2Verify(subjectPublicKeyData, csrInfoData, signatureData);
    }

    public byte[] getEncoded() {
        try {
            return this.csr.getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private PKCS10CSRequest(CertificationRequest csr) {
        this.csr = csr;
    }

    public static class Builder {
        private ASN1EncodableVector attributesVector = new ASN1EncodableVector();

        public Builder addAttribute(String type, String value) {
            this.attributesVector.add(new Attribute(new ASN1ObjectIdentifier(type), new DERSet(new DERUTF8String(value))));
            return this;
        }

        public Builder addAttribute(String type, String[] value) {
            ASN1Encodable[] derValue = new DERUTF8String[value.length];
            for (int i = 0; i < derValue.length; ++i) {
                derValue[i] = new DERUTF8String(value[i]);
            }
            this.attributesVector.add(new Attribute(new ASN1ObjectIdentifier(type), new DERSet(derValue)));
            return this;
        }

        public Builder addAttribute(String type, byte[] value) {
            this.attributesVector.add(new Attribute(new ASN1ObjectIdentifier(type), new DERSet(new DERBitString(value))));
            return this;
        }

        public Builder addAttribute(String type, byte[][] value) {
            ASN1Encodable[] derValue = new DERBitString[value.length];
            for (int i = 0; i < derValue.length; ++i) {
                derValue[i] = new DERBitString(value[i]);
            }
            this.attributesVector.add(new Attribute(new ASN1ObjectIdentifier(type), new DERSet(derValue)));
            return this;
        }

        public PKCS10CSRequest build(X501DName subjectDN, byte[] subjectPublicKeyData, Function<byte[], byte[]> signer) {
            byte[] csrSignatureData;
            byte[] csrInfoData;
            if (!ConversionUtils.SM2PublicKeyData.check(subjectPublicKeyData)) {
                throw new IllegalArgumentException("Argument \"subjectPublicKeyData\" is illegal");
            }
            CertificationRequestInfo csrInfo = new CertificationRequestInfo(subjectDN.x500Name(), new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, GMObjectIdentifiers.sm2p256v1), subjectPublicKeyData), (ASN1Set)new DERSet(this.attributesVector));
            try {
                csrInfoData = csrInfo.getEncoded("DER");
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
            try {
                csrSignatureData = signer.apply(csrInfoData);
            }
            catch (Exception e) {
                throw new RuntimeException("Sign failed", e);
            }
            if (!SignatureUtils.sm2Verify(subjectPublicKeyData, csrInfoData, csrSignatureData)) {
                throw new RuntimeException("Sign failed");
            }
            csrSignatureData = ConversionUtils.SM2SignatureData.toGMT0009(csrSignatureData);
            return new PKCS10CSRequest(new CertificationRequest(csrInfo, new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3), new DERBitString(csrSignatureData)));
        }
    }
}

