/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util;

import cn.com.westone.wcspsdk.util.ConversionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;

public final class SignatureUtils {
    public static byte[] sm2PreprocessSM3(byte[] publicKeyData, byte[] data) {
        return SignatureUtils.sm2PreprocessSM3(publicKeyData, "1234567812345678", data, 0, data.length);
    }

    public static byte[] sm2PreprocessSM3(byte[] publicKeyData, byte[] data, int offset, int length) {
        return SignatureUtils.sm2PreprocessSM3(publicKeyData, "1234567812345678", data, offset, length);
    }

    public static byte[] sm2PreprocessSM3(byte[] publicKeyData, InputStream inputStream) throws IOException {
        return SignatureUtils.sm2PreprocessSM3(publicKeyData, "1234567812345678", inputStream);
    }

    public static byte[] sm2PreprocessSM3(byte[] publicKeyData, String userId, byte[] data) {
        return SignatureUtils.sm2PreprocessSM3(publicKeyData, userId, data, 0, data.length);
    }

    public static byte[] sm2PreprocessSM3(byte[] publicKeyData, String userId, byte[] data, int offset, int length) {
        if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
            throw new IllegalArgumentException("Argument \"publicKeyData\" is illegal");
        }
        ECDomainParameters params = new ECDomainParameters(GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1));
        ECPoint q = params.getCurve().decodePoint(publicKeyData).normalize();
        return SignatureUtils.sm2PreprocessSM3(params, q, userId, data, offset, length);
    }

    public static byte[] sm2PreprocessSM3(byte[] publicKeyData, String userId, InputStream inputStream) throws IOException {
        if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
            throw new IllegalArgumentException("Argument \"publicKeyData\" is illegal");
        }
        ECDomainParameters params = new ECDomainParameters(GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1));
        ECPoint q = params.getCurve().decodePoint(publicKeyData).normalize();
        return SignatureUtils.sm2PreprocessSM3(params, q, userId, inputStream);
    }

    public static boolean sm2VerifyDigest(byte[] publicKeyData, byte[] digestData, byte[] signatureData) {
        if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
            throw new IllegalArgumentException("Argument \"publicKeyData\" is illegal");
        }
        if (null == digestData || digestData.length < 1) {
            throw new IllegalArgumentException("Argument \"digestData\" is null");
        }
        ECDomainParameters params = new ECDomainParameters(GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1));
        ECPoint q = params.getCurve().decodePoint(publicKeyData).normalize();
        return SignatureUtils.sm2VerifyDigest(params, q, digestData, signatureData);
    }

    public static boolean sm2Verify(byte[] publicKeyData, byte[] data, byte[] signatureData) {
        return SignatureUtils.sm2Verify(publicKeyData, "1234567812345678", data, 0, data.length, signatureData);
    }

    public static boolean sm2Verify(byte[] publicKeyData, byte[] data, int offset, int length, byte[] signatureData) {
        return SignatureUtils.sm2Verify(publicKeyData, "1234567812345678", data, offset, length, signatureData);
    }

    static boolean sm2Verify(byte[] publicKeyData, InputStream inputStream, byte[] signatureData) throws IOException {
        return SignatureUtils.sm2Verify(publicKeyData, "1234567812345678", inputStream, signatureData);
    }

    public static boolean sm2Verify(byte[] publicKeyData, String userId, byte[] data, byte[] signatureData) {
        return SignatureUtils.sm2Verify(publicKeyData, userId, data, 0, data.length, signatureData);
    }

    public static boolean sm2Verify(byte[] publicKeyData, String userId, byte[] data, int offset, int length, byte[] signatureData) {
        if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
            throw new IllegalArgumentException("Argument \"publicKeyData\" is illegal");
        }
        ECDomainParameters params = new ECDomainParameters(GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1));
        ECPoint q = params.getCurve().decodePoint(publicKeyData).normalize();
        return SignatureUtils.sm2VerifyDigest(params, q, SignatureUtils.sm2PreprocessSM3(params, q, userId, data, offset, length), signatureData);
    }

    public static boolean sm2Verify(byte[] publicKeyData, String userId, InputStream inputStream, byte[] signatureData) throws IOException {
        if (!ConversionUtils.SM2PublicKeyData.check(publicKeyData)) {
            throw new IllegalArgumentException("Argument \"publicKeyData\" is illegal");
        }
        ECDomainParameters params = new ECDomainParameters(GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1));
        ECPoint q = params.getCurve().decodePoint(publicKeyData).normalize();
        return SignatureUtils.sm2VerifyDigest(params, q, SignatureUtils.sm2PreprocessSM3(params, q, userId, inputStream), signatureData);
    }

    private static byte[] sm2PreprocessSM3(ECDomainParameters params, ECPoint q, String userId, byte[] data, int offset, int length) {
        if (null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"data\" is null");
        }
        if (offset < 0) {
            offset += data.length;
        }
        if (offset < 0 || data.length <= offset || length < 1 || offset + length > data.length) {
            throw new IllegalArgumentException("Argument \"offset\" or \"length\" is illegal");
        }
        SM3Digest digest = new SM3Digest();
        byte[] z = SignatureUtils.calculateZ(params, q, userId);
        digest.update(z, 0, z.length);
        digest.update(data, offset, length);
        byte[] digestData = new byte[digest.getDigestSize()];
        digest.doFinal(digestData, 0);
        return digestData;
    }

    private static byte[] sm2PreprocessSM3(ECDomainParameters params, ECPoint q, String userId, InputStream inputStream) throws IOException {
        int readLength;
        SM3Digest digest = new SM3Digest();
        byte[] z = SignatureUtils.calculateZ(params, q, userId);
        digest.update(z, 0, z.length);
        byte[] buf = new byte[8192];
        while ((readLength = inputStream.read(buf)) >= 0) {
            digest.update(buf, 0, readLength);
        }
        byte[] digestData = new byte[digest.getDigestSize()];
        digest.doFinal(digestData, 0);
        return digestData;
    }

    private static byte[] calculateZ(ECDomainParameters params, ECPoint q, String userId) {
        if (null == userId || userId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"userId\" is null");
        }
        SM3Digest digest = new SM3Digest();
        byte[] buf = ConversionUtils.Data.fromUTF8String(userId);
        digest.update((byte)(buf.length * 8 >> 8 & 0xFF));
        digest.update((byte)(buf.length * 8 & 0xFF));
        digest.update(buf, 0, buf.length);
        buf = params.getCurve().getA().getEncoded();
        digest.update(buf, 0, buf.length);
        buf = params.getCurve().getB().getEncoded();
        digest.update(buf, 0, buf.length);
        buf = params.getG().getAffineXCoord().getEncoded();
        digest.update(buf, 0, buf.length);
        buf = params.getG().getAffineYCoord().getEncoded();
        digest.update(buf, 0, buf.length);
        buf = q.getAffineXCoord().getEncoded();
        digest.update(buf, 0, buf.length);
        buf = q.getAffineYCoord().getEncoded();
        digest.update(buf, 0, buf.length);
        byte[] digestData = new byte[digest.getDigestSize()];
        digest.doFinal(digestData, 0);
        return digestData;
    }

    private static boolean sm2VerifyDigest(ECDomainParameters params, ECPoint q, byte[] digestData, byte[] signatureData) {
        if (null == signatureData || signatureData.length < 1) {
            throw new IllegalArgumentException("Argument \"signatureData\" is null");
        }
        if (!ConversionUtils.SM2SignatureData.check(signatureData)) {
            throw new IllegalArgumentException("Argument \"signature\" is illegal");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(signatureData, 0, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(signatureData, 32, 64));
        BigInteger n = params.getN();
        if (r.compareTo(ECConstants.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ECConstants.ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger e = new BigInteger(1, digestData);
        BigInteger t = r.add(s).mod(n);
        if (t.equals(ECConstants.ZERO)) {
            return false;
        }
        ECPoint x1y1 = ECAlgorithms.sumOfTwoMultiplies(params.getG(), s, q, t).normalize();
        if (x1y1.isInfinity()) {
            return false;
        }
        BigInteger expectedR = e.add(x1y1.getAffineXCoord().toBigInteger()).mod(n);
        return expectedR.equals(r);
    }

    private SignatureUtils() {
    }
}

