/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.util;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.digests.SM3Digest;

public final class DigestUtils {
    public static byte[] sm3(byte[] data) {
        return DigestUtils.sm3(data, 0, data.length);
    }

    public static byte[] sm3(byte[] data, int offset, int length) {
        if (null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"data\" is null");
        }
        if (offset < 0) {
            offset += data.length;
        }
        if (offset < 0 || data.length <= offset || length < 1 || offset + length > data.length) {
            throw new IllegalArgumentException("Argument \"offset\" or \"length\" is illegal");
        }
        SM3Digest digest = new SM3Digest();
        digest.update(data, offset, length);
        byte[] digestData = new byte[digest.getDigestSize()];
        digest.doFinal(digestData, 0);
        return digestData;
    }

    public static byte[] sm3(InputStream inputStream) throws IOException {
        int readLength;
        byte[] buf = new byte[8192];
        SM3Digest digest = new SM3Digest();
        while ((readLength = inputStream.read(buf)) >= 0) {
            digest.update(buf, 0, readLength);
        }
        byte[] digestData = new byte[digest.getDigestSize()];
        digest.doFinal(digestData, 0);
        return digestData;
    }

    private DigestUtils() {
    }
}

