/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthAppUserParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.ServiceImpl;
import cn.com.westone.wcspsdk.impl.jni.JNIUtils;
import cn.com.westone.wcspsdk.impl.jni.TimestampServiceJNI;
import java.time.Instant;
import java.util.Map;

public class TimestampService
extends ServiceImpl {
    public static final String SERVICE_TYPE_TIMESTAMP = "Timestamp";
    public static final String ALGORITHM_SM2 = "SM2";
    public static final String ALGORITHM_SM3 = "SM3";
    public static final int TIME_OF_STAMP = 1;
    public static final int CN_OF_TSSIGNER = 2;
    public static final int ORINGINAL_DATA = 3;
    public static final int CERT_OF_TSSERVER = 4;
    public static final int CERTCHAIN_OF_TSSERVER = 5;
    public static final int SOURCE_OF_TIME = 6;
    public static final int TIME_PRECISION = 7;
    public static final int RESPONSE_TYPE = 8;
    public static final int SUBJECT_COUNTRY_OF_TSSIGNER = 9;
    public static final int SUBJECT_ORGNIZATION_OF_TSSIGNER = 10;
    public static final int SUBJECT_CITY_OF_TSSIGNER = 11;
    public static final int SUBJECT_EMAIL_OF_TSSIGNER = 12;

    public static TimestampService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        if (platform instanceof PlatformImpl) {
            TimestampService service = new TimestampService((PlatformImpl)platform);
            service.init(new Object[0]);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static TimestampService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        TimestampService service = new TimestampService(platform);
        service.init(new Object[0]);
        return service;
    }

    public static TimestampService getInstance(String tenantId, String appId, Map<String, Object> params, String userId, String authCode) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthAppUserParameterSpec.Builder().setAuthCode(userId, authCode).build());
        TimestampService service = new TimestampService(platform);
        service.init(new Object[0]);
        return service;
    }

    @Override
    public void init(Object ... args) {
    }

    public byte[] createTSRequest(byte[] inData, ReqType reqType, byte[] tsExt, String digestAlgorithm) throws InvalidParameterException, WCSPException {
        int algId;
        if (null == inData || inData.length < 1 || null == reqType || null == digestAlgorithm || digestAlgorithm.isEmpty()) {
            throw new IllegalArgumentException("Argument \"inData\" or \"reqType\" or \"digestAlgorithm\" is null");
        }
        switch (digestAlgorithm) {
            case "SM3": {
                algId = 0;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + digestAlgorithm);
            }
        }
        byte[][] timestampRequest = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_TS_CreateRequest IN hTsService[{}{}] inData[{}] certType[{}] tsExt[{}] algId[{}]", "0x", this.handle(), inData, reqType.value, tsExt, algId);
        JNIUtils.WCSP_CHECK("WCSP_TS_CreateRequest", TimestampServiceJNI.wcsp_TS_CreateRequest(this.handle(), inData, reqType.value, tsExt, algId, timestampRequest), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_TS_CreateRequest OUT tsRequest[{}]", new Object[]{timestampRequest[0]});
        return timestampRequest[0];
    }

    public byte[] createTSResponse(byte[] tsRequest, String signatureAlgorithm) throws InvalidParameterException, WCSPException {
        int algId;
        if (null == tsRequest || tsRequest.length < 1 || null == signatureAlgorithm || signatureAlgorithm.isEmpty()) {
            throw new IllegalArgumentException("Argument \"tsRequest\" or \"signatureAlgorithm\" is null");
        }
        switch (signatureAlgorithm) {
            case "SM2": {
                algId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + signatureAlgorithm);
            }
        }
        byte[][] timestampResponse = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_TS_CreateResponse IN hTsService[{}{}] timestampRequest[{}] signAlgorithm[{}] ", "0x", this.handle(), tsRequest, signatureAlgorithm);
        JNIUtils.WCSP_CHECK("WCSP_TS_CreateResponse", TimestampServiceJNI.wcsp_TS_CreateResponse(this.handle(), tsRequest, algId, timestampResponse), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_TS_CreateResponse OUT timestampResponse[{}]", new Object[]{timestampResponse[0]});
        return timestampResponse[0];
    }

    public boolean verifyTSValidity(byte[] tsResponse, String digestAlgorithm, String signatureAlgorithm) throws InvalidParameterException, WCSPException {
        int signAlgId;
        int algId;
        if (null == tsResponse || tsResponse.length < 1 || null == digestAlgorithm || digestAlgorithm.isEmpty() || null == signatureAlgorithm || signatureAlgorithm.isEmpty()) {
            throw new IllegalArgumentException("Argument \"tsResponse\" or \"digestAlgorithm\" or \"signatureAlgorithm\" is null");
        }
        switch (digestAlgorithm) {
            case "SM3": {
                algId = 0;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + digestAlgorithm);
            }
        }
        switch (signatureAlgorithm) {
            case "SM2": {
                signAlgId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + signatureAlgorithm);
            }
        }
        int[] isVerified = new int[]{0};
        JNIUtils.WCSP_LOG_D("WCSP_TS_VerifyValidity IN hTsService[{}{}] timestampResponse[{}] digestAlgorithm[{}] signAlgorithm[{}]", "0x", this.handle(), tsResponse, digestAlgorithm, signatureAlgorithm);
        JNIUtils.WCSP_CHECK("WCSP_TS_VerifyValidity", TimestampServiceJNI.wcsp_TS_VerifyValidity(this.handle(), tsResponse, algId, signAlgId, null, isVerified), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_TS_VerifyValidity OUT isVerified[{}]", isVerified[0]);
        return isVerified[0] == 1;
    }

    public boolean verifyTSValidity(byte[] tsResponse, String digestAlgorithm, String signatureAlgorithm, byte[] tsCert) throws InvalidParameterException, WCSPException {
        int signAlgId;
        int algId;
        if (null == tsResponse || tsResponse.length < 1 || null == digestAlgorithm || digestAlgorithm.isEmpty() || null == signatureAlgorithm || signatureAlgorithm.isEmpty() || null == tsCert || tsCert.length < 1) {
            throw new IllegalArgumentException("Argument \"tsResponse\" or \"digestAlgorithm\" or \"signatureAlgorithm\" or \"tsCert\" is null");
        }
        switch (digestAlgorithm) {
            case "SM3": {
                algId = 0;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + digestAlgorithm);
            }
        }
        switch (signatureAlgorithm) {
            case "SM2": {
                signAlgId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + signatureAlgorithm);
            }
        }
        int[] isVerified = new int[]{0};
        JNIUtils.WCSP_LOG_D("WCSP_TS_VerifyValidity IN hTsService[{}{}] timestampResponse[{}] digestAlgorithm[{}] signAlgorithm[{}] tsaCert[{}]", "0x", this.handle(), tsResponse, digestAlgorithm, signatureAlgorithm, tsCert);
        JNIUtils.WCSP_CHECK("WCSP_TS_VerifyValidity", TimestampServiceJNI.wcsp_TS_VerifyValidity(this.handle(), tsResponse, algId, signAlgId, tsCert, isVerified), new int[0]);
        JNIUtils.WCSP_LOG_D("WCSP_TS_VerifyValidity OUT isVerified[{}]", isVerified[0]);
        return isVerified[0] == 1;
    }

    public TSInfoHolder getTSInfo(byte[] tsResponse) throws WCSPException {
        if (null == tsResponse || tsResponse.length < 1) {
            throw new IllegalArgumentException("Argument \"tsResponse\" is null");
        }
        byte[][] issuerName = new byte[][]{null};
        byte[][] time = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_TS_GetInfo IN hTsService[{}{}] timestampResponse[{}]", "0x", this.handle(), tsResponse);
        JNIUtils.WCSP_CHECK("WCSP_TS_GetInfo", TimestampServiceJNI.wcsp_TS_GetInfo(this.handle(), tsResponse, issuerName, time), new int[0]);
        Instant timeRes = Instant.ofEpochSecond(TimestampService.bytesToInt(time[0]));
        JNIUtils.WCSP_LOG_D("WCSP_TS_GetInfo OUT issuerName[{}] time[{}]", new String(issuerName[0]), timeRes);
        return new TSInfoHolder(new String(issuerName[0]), timeRes);
    }

    public Object getTSDetail(byte[] tsResponse, int itemNumber) throws WCSPException {
        if (null == tsResponse || tsResponse.length < 1) {
            throw new IllegalArgumentException("Argument \"tsResponse\" is null");
        }
        byte[][] itemValue = new byte[][]{null};
        JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail IN hTsService[{}{}] timestampResponse[{}]", "0x", this.handle(), tsResponse);
        JNIUtils.WCSP_CHECK("WCSP_TS_GetDetail", TimestampServiceJNI.wcsp_TS_GetDetail(this.handle(), tsResponse, itemNumber, itemValue), new int[0]);
        switch (itemNumber) {
            case 1: {
                Instant timeRes = Instant.ofEpochSecond(TimestampService.bytesToInt(itemValue[0]));
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT TIME_OF_STAMP[{}] ", timeRes);
                return timeRes;
            }
            case 2: {
                String tsSigner = new String(itemValue[0]);
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT CN_OF_TSSIGNER[{}] ", tsSigner);
                return tsSigner;
            }
            case 3: {
                byte[] originalData = itemValue[0];
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT ORINGINAL_DATA[{}] ", new Object[]{originalData});
                return originalData;
            }
            case 4: {
                byte[] tsServer = itemValue[0];
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT CERT_OF_TSSERVER[{}] ", new Object[]{tsServer});
                return tsServer;
            }
            case 5: {
                byte[] certChainOfTsServer = itemValue[0];
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT CERTCHAIN_OF_TSSERVER[{}] ", new Object[]{certChainOfTsServer});
                return certChainOfTsServer;
            }
            case 6: {
                byte[] sourceOfTime = itemValue[0];
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT SOURCE_OF_TIME[{}] ", new Object[]{sourceOfTime});
                return sourceOfTime;
            }
            case 7: {
                int timePrecision = TimestampService.bytesToInt(itemValue[0]);
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT TIME_PRECISION[{}] ", timePrecision);
                return timePrecision;
            }
            case 8: {
                int responseType = TimestampService.bytesToInt(itemValue[0]);
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT RESPONSE_TYPE[{}] ", responseType);
                return responseType;
            }
            case 9: {
                String subjectCountryOfTsSigner = new String(itemValue[0]);
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT SUBJECT_COUNTRY_OF_TSSIGNER[{}] ", subjectCountryOfTsSigner);
                return subjectCountryOfTsSigner;
            }
            case 10: {
                String subjectOrgOfTsSigner = new String(itemValue[0]);
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT SUBJECT_ORGNIZATION_OF_TSSIGNER[{}] ", subjectOrgOfTsSigner);
                return subjectOrgOfTsSigner;
            }
            case 11: {
                String subjectCityOfTsSigner = new String(itemValue[0]);
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT SUBJECT_CITY_OF_TSSIGNER[{}] ", subjectCityOfTsSigner);
                return subjectCityOfTsSigner;
            }
            case 12: {
                String subjectEmailOfTsSigner = new String(itemValue[0]);
                JNIUtils.WCSP_LOG_D("WCSP_TS_GetDetail OUT SUBJECT_EMAIL_OF_TSSIGNER[{}] ", subjectEmailOfTsSigner);
                return subjectEmailOfTsSigner;
            }
        }
        return itemValue[0];
    }

    private TimestampService(PlatformImpl platform) throws WCSPException {
        super(5, SERVICE_TYPE_TIMESTAMP, platform);
    }

    private static int bytesToInt(byte[] bytes) {
        int number = 0;
        for (int i = 0; i < 4; ++i) {
            number += bytes[i] << i * 8;
        }
        return number;
    }

    public static final class TSInfoHolder {
        private final String issuerName;
        private final Instant time;

        public String issuerName() {
            return this.issuerName;
        }

        public Instant time() {
            return this.time;
        }

        private TSInfoHolder(String issuerName, Instant time) {
            this.issuerName = issuerName;
            this.time = time;
        }
    }

    public static enum ReqType {
        INCLUDE_TSCERT(0),
        EXCLUDE_TSCERT(1);

        private final int value;

        private ReqType(int value) {
            this.value = value;
        }
    }
}

