/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthAppUserParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.COService;
import cn.com.westone.wcspsdk.baseservice.co.Decryptor;
import cn.com.westone.wcspsdk.baseservice.co.Encryptor;
import cn.com.westone.wcspsdk.baseservice.co.KeyPair;
import cn.com.westone.wcspsdk.baseservice.co.Mac;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.co.SessionKey;
import cn.com.westone.wcspsdk.baseservice.co.ShortDataMac;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.base.Utils;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.com.westone.wcspsdk.util.KeyUtils;
import java.util.Arrays;
import java.util.Map;

public class SessionEncryptService
implements CryptoService {
    public static final String SERVICE_TYPE_SESSIONENCRYPT = "SessionEncrypt";
    private COService coService = null;
    private final PlatformImpl platform;

    public static SessionEncryptService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        if (platform instanceof PlatformImpl) {
            SessionEncryptService service = new SessionEncryptService((PlatformImpl)platform);
            service.init(new Object[0]);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static SessionEncryptService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        SessionEncryptService service = new SessionEncryptService(platform);
        service.init(new Object[0]);
        return service;
    }

    public static SessionEncryptService getInstance(String tenantId, String appId, Map<String, Object> params, String userId, String authCode) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthAppUserParameterSpec.Builder().setAuthCode(userId, authCode).build());
        SessionEncryptService service = new SessionEncryptService(platform);
        service.init(new Object[0]);
        return service;
    }

    @Override
    public void init(Object ... args) throws WCSPException {
        if (null == this.coService) {
            if (this.platform.isServerSDK()) {
                try {
                    this.coService = COService.getInstance("CO-REMOTE", this.platform);
                }
                catch (InvalidParameterException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
                this.coService.init(new Object[0]);
            } else {
                this.coService = COService.getInstance(this.platform);
                this.coService.init(new Object[0]);
                this.coService.verifyPIN("123456");
            }
        }
    }

    public SessionInitiator getSessionInitiator() throws WCSPException {
        try {
            KeyPair keyPair = this.coService.getKeyPair("SM2", "ENC");
            return new SessionInitiator(ConversionUtils.SM2PublicKeyData.fromGMT0016(keyPair.publicKey().getKeyData()));
        }
        catch (InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public SessionInitiator getSessionInitiator(String initiatorId) throws WCSPException {
        throw new UnsupportedOperationException();
    }

    public SessionResponder getSessionResponder(String initiatorKeyAgreementData) throws InvalidParameterException, WCSPException {
        try {
            byte[] keyAgreementData = ConversionUtils.SM2PublicKeyData.toGMT0016(ConversionUtils.Data.fromBase64String(initiatorKeyAgreementData));
            PublicKey publicKey = KeyUtils.createPublicKeySM2("ENC", keyAgreementData);
            SessionKey encKey = this.coService.generateSessionKey("SM4_CBC", publicKey);
            SessionKey macKey = this.coService.generateSessionKey("SM4_MAC", publicKey);
            byte[] wrappedEncKey = ConversionUtils.SM2CipherData.fromGMT0016(encKey.getWrapped());
            byte[] wrappedMacKey = ConversionUtils.SM2CipherData.fromGMT0016(macKey.getWrapped());
            byte[] keyData = Utils.arrayConcatenate(wrappedEncKey, wrappedMacKey, new byte[0][]);
            return new SessionResponder(encKey, macKey, keyData);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public SessionResponder getSessionResponder(String responderId, String initiatorId, String initiatorKeyAgreementData) throws InvalidParameterException, WCSPException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String type() {
        return SERVICE_TYPE_SESSIONENCRYPT;
    }

    @Override
    public CryptoServicePlatform platform() {
        return this.platform;
    }

    private SessionEncryptService(PlatformImpl platform) {
        this.platform = platform;
    }

    private class Cipher {
        private static final byte HEADER_LENGTH = 34;
        private static final byte VERSION = 1;
        private static final byte ALGORITHM = 1;
        private final SessionKey encKey;
        private final SessionKey macKey;

        private Cipher(SessionKey encKey, SessionKey macKey) {
            this.encKey = encKey;
            this.macKey = macKey;
        }

        private String encryptMessage(String message) throws InvalidParameterException, WCSPException {
            if (null == message || message.isEmpty()) {
                throw new IllegalArgumentException("Argument \"message\" is null");
            }
            return ConversionUtils.Data.toBase64String(this.encryptData(ConversionUtils.Data.fromUTF8String(message)));
        }

        private byte[] encryptData(byte[] data) throws InvalidParameterException, WCSPException {
            if (null == data || data.length < 1) {
                throw new IllegalArgumentException("Argument \"data\" is null");
            }
            byte[] iv = SessionEncryptService.this.coService.generateRandom(16);
            try {
                byte[] macData;
                byte[] encData;
                block41: {
                    if (data.length > 1007) {
                        encData = new byte[]{};
                        try (Encryptor encryptor = SessionEncryptService.this.coService.getEncryptor(this.encKey, iv, "CBC", "PKCS7Padding");
                             Mac mac = SessionEncryptService.this.coService.getCBCMac(this.macKey, iv, "NoPadding");){
                            byte[] encDataPart;
                            while (data.length > 64512) {
                                byte[] dataPart = Arrays.copyOf(data, 64512);
                                encDataPart = encryptor.update(dataPart);
                                encData = Utils.arrayConcatenate(encData, encDataPart, new byte[0][]);
                                mac.update(encDataPart);
                                data = Arrays.copyOfRange(data, 64512, data.length);
                            }
                            encDataPart = encryptor.doFinal(data);
                            encData = Utils.arrayConcatenate(encData, encDataPart, new byte[0][]);
                            macData = mac.doFinal(encDataPart);
                            break block41;
                        }
                    }
                    encData = SessionEncryptService.this.coService.encryptShortData(this.encKey, iv, "CBC", "PKCS7Padding", data);
                    try (ShortDataMac shortDataMac = SessionEncryptService.this.coService.getShortDataCBCMac(this.macKey, iv, "NoPadding");){
                        macData = shortDataMac.mac(encData);
                    }
                }
                return Utils.arrayConcatenate(new byte[]{1, 1}, iv, macData, encData);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }

        private String decryptMessage(String encryptedMessage) throws InvalidParameterException, WCSPException {
            if (null == encryptedMessage || encryptedMessage.isEmpty()) {
                throw new IllegalArgumentException("Argument \"encryptedMessage\" is null");
            }
            return ConversionUtils.Data.toUTF8String(this.decryptData(ConversionUtils.Data.fromBase64String(encryptedMessage)));
        }

        private byte[] decryptData(byte[] encryptedData) throws InvalidParameterException, WCSPException {
            if (null == encryptedData || encryptedData.length < 1) {
                throw new IllegalArgumentException("Argument \"encryptedData\" is null");
            }
            if (encryptedData.length < 50) {
                throw new IllegalArgumentException("Invalid encryptedData length");
            }
            block13 : switch (encryptedData[0]) {
                case 1: {
                    switch (encryptedData[1]) {
                        case 1: {
                            break block13;
                        }
                    }
                    throw new InvalidParameterException("Invalid header: algorithm");
                }
                default: {
                    throw new InvalidParameterException("Invalid header: version");
                }
            }
            byte[] iv = Arrays.copyOfRange(encryptedData, 2, 18);
            byte[] encData = Arrays.copyOfRange(encryptedData, 34, encryptedData.length);
            try {
                byte[] macData;
                byte[] data;
                block49: {
                    if (encData.length > 1023) {
                        data = new byte[]{};
                        try (Decryptor decryptor = SessionEncryptService.this.coService.getDecryptor(this.encKey, iv, "CBC", "PKCS7Padding");
                             Mac mac = SessionEncryptService.this.coService.getCBCMac(this.macKey, iv, "NoPadding");){
                            byte[] dataPart;
                            while (encData.length > 64512) {
                                byte[] encDataPart = Arrays.copyOf(encData, 64512);
                                dataPart = decryptor.update(encDataPart);
                                data = Utils.arrayConcatenate(data, dataPart, new byte[0][]);
                                mac.update(encDataPart);
                                encData = Arrays.copyOfRange(encData, 64512, encData.length);
                            }
                            dataPart = decryptor.doFinal(encData);
                            data = Utils.arrayConcatenate(data, dataPart, new byte[0][]);
                            macData = mac.doFinal(encData);
                            break block49;
                        }
                    }
                    data = SessionEncryptService.this.coService.decryptShortData(this.encKey, iv, "CBC", "PKCS7Padding", encData);
                    try (ShortDataMac shortDataMac = SessionEncryptService.this.coService.getShortDataCBCMac(this.macKey, iv, "NoPadding");){
                        macData = shortDataMac.mac(encData);
                    }
                }
                if (!Utils.arrayEquals(macData, 0, encryptedData, 18, 16)) {
                    throw new IllegalArgumentException("Invalid encryptedData");
                }
                return data;
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }

        private void close() {
            this.encKey.close();
            this.macKey.close();
        }
    }

    public class SessionResponder
    implements AutoCloseable {
        private final Cipher cipher;
        private final byte[] keyAgreementData;

        public String getKeyAgreementData() {
            return ConversionUtils.Data.toBase64String(this.keyAgreementData);
        }

        public String encryptMessage(String message) throws InvalidParameterException, WCSPException {
            return this.cipher.encryptMessage(message);
        }

        public byte[] encryptData(byte[] data) throws InvalidParameterException, WCSPException {
            return this.cipher.encryptData(data);
        }

        public String decryptMessage(String encryptedMessage) throws InvalidParameterException, WCSPException {
            return this.cipher.decryptMessage(encryptedMessage);
        }

        public byte[] decryptData(byte[] encryptedData) throws InvalidParameterException, WCSPException {
            return this.cipher.decryptData(encryptedData);
        }

        @Override
        public void close() {
            this.cipher.close();
        }

        private SessionResponder(SessionKey encKey, SessionKey macKey, byte[] keyAgreementData) {
            this.cipher = new Cipher(encKey, macKey);
            this.keyAgreementData = keyAgreementData;
        }
    }

    public class SessionInitiator
    implements AutoCloseable {
        private Cipher cipher = null;
        private final byte[] keyAgreementData;

        public String getKeyAgreementData() {
            return ConversionUtils.Data.toBase64String(this.keyAgreementData);
        }

        public void init(String responderKeyAgreementData) throws InvalidParameterException, WCSPException {
            if (null == responderKeyAgreementData || responderKeyAgreementData.isEmpty()) {
                throw new IllegalArgumentException("Argument \"responderKeyAgreementData\" is null");
            }
            byte[] keyAgreementData = ConversionUtils.Data.fromBase64String(responderKeyAgreementData);
            if (keyAgreementData.length < 2 || 0 != keyAgreementData.length % 2) {
                throw new InvalidParameterException("Invalid responderKeyAgreementData");
            }
            byte[] encKeyData = ConversionUtils.SM2CipherData.toGMT0016(Arrays.copyOfRange(keyAgreementData, 0, keyAgreementData.length / 2));
            byte[] macKeyData = ConversionUtils.SM2CipherData.toGMT0016(Arrays.copyOfRange(keyAgreementData, keyAgreementData.length / 2, keyAgreementData.length));
            KeyPair keyPair = SessionEncryptService.this.coService.getKeyPair("SM2", "ENC");
            try {
                SessionKey encKey = SessionEncryptService.this.coService.importSessionKey("SM4_CBC", encKeyData, keyPair.privateKey());
                SessionKey macKey = SessionEncryptService.this.coService.importSessionKey("SM4_MAC", macKeyData, keyPair.privateKey());
                this.cipher = new Cipher(encKey, macKey);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }

        public void init(String responderId, String responderKeyAgreementData) throws InvalidParameterException, WCSPException {
            throw new UnsupportedOperationException();
        }

        public String encryptMessage(String message) throws InvalidParameterException, WCSPException {
            if (null == this.cipher) {
                throw new IllegalStateException("SessionInitiator has not been initialized");
            }
            return this.cipher.encryptMessage(message);
        }

        public byte[] encryptData(byte[] data) throws InvalidParameterException, WCSPException {
            if (null == this.cipher) {
                throw new IllegalStateException("SessionInitiator has not been initialized");
            }
            return this.cipher.encryptData(data);
        }

        public String decryptMessage(String encryptedMessage) throws InvalidParameterException, WCSPException {
            if (null == this.cipher) {
                throw new IllegalStateException("SessionInitiator has not been initialized");
            }
            return this.cipher.decryptMessage(encryptedMessage);
        }

        public byte[] decryptData(byte[] encryptedData) throws InvalidParameterException, WCSPException {
            if (null == this.cipher) {
                throw new IllegalStateException("SessionInitiator has not been initialized");
            }
            return this.cipher.decryptData(encryptedData);
        }

        @Override
        public void close() {
            this.cipher.close();
        }

        private SessionInitiator(byte[] keyAgreementData) {
            this.keyAgreementData = keyAgreementData;
        }
    }
}

