/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthAppUserParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.FPEDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.FPEEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.SymmShortDataDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.SymmShortDataEncryptorImpl;
import cn.com.westone.wcspsdk.impl.km.KMSecretKeyImpl;
import cn.com.westone.wcspsdk.impl.km.KMServiceImpl;
import java.util.HashMap;
import java.util.Map;

public class LightDataService
implements CryptoService {
    public static final String SERVICE_TYPE_LIGHTENCRYPT = "LightEncrypt";
    private static final String TEMPLATE_DATA_PROTECT_KEY = "TEMPLATE_DATA_PROTECT_KEY";
    private static final byte MAX_TINY_DATA_LENGTH = 32;
    private KMServiceImpl kmService = null;
    private COServiceImpl coService = null;
    private final PlatformImpl platform;
    private String keyId;

    public static LightDataService getInstance(CryptoServicePlatform platform) throws WCSPException {
        return LightDataService.getInstance(platform, null);
    }

    public static LightDataService getInstance(CryptoServicePlatform platform, String keyId) throws WCSPException {
        if (platform instanceof PlatformImpl) {
            LightDataService service = new LightDataService((PlatformImpl)platform, keyId);
            service.init(new Object[0]);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static LightDataService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        return LightDataService.getInstance(tenantId, appId, params, secret, null);
    }

    public static LightDataService getInstance(String tenantId, String appId, Map<String, Object> params, String secret, String keyId) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        LightDataService service = new LightDataService(platform, keyId);
        service.init(new Object[0]);
        return service;
    }

    public static LightDataService getInstance(String tenantId, String appId, Map<String, Object> params, String userId, String authCode, String keyId) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthAppUserParameterSpec.Builder().setAuthCode(userId, authCode).build());
        LightDataService service = new LightDataService(platform, keyId);
        service.init(new Object[0]);
        return service;
    }

    public static LightDataService getInstance(String tenantId, String appId, String secret, String cfgFile, String keyId) throws InvalidParameterException, WCSPException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cfgFile", cfgFile);
        return LightDataService.getInstance(tenantId, appId, params, secret, keyId);
    }

    @Override
    public void init(Object ... args) throws WCSPException {
        if (null == this.kmService) {
            this.kmService = KMServiceImpl.getInstance(this.platform);
            this.kmService.init(new Object[0]);
            if (null == this.keyId || this.keyId.isEmpty()) {
                KMSecretKeyImpl[] kmSecretKeys = this.kmService.getSecretKeyList(TEMPLATE_DATA_PROTECT_KEY, 1);
                if (null == kmSecretKeys || kmSecretKeys.length == 0) {
                    throw new WCSPException("kmSecretKey is null");
                }
                this.keyId = kmSecretKeys[0].keyId();
            }
        }
        if (null == this.coService) {
            if (this.platform.isServerSDK()) {
                try {
                    this.coService = COServiceImpl.getInstance("CO-REMOTE", this.platform);
                }
                catch (InvalidParameterException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
                this.coService.init(new Object[0]);
            } else {
                this.coService = COServiceImpl.getInstance(this.platform);
                this.coService.init(new Object[0]);
                this.coService.verifyPIN("123456");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encrypt(byte[] data) throws InvalidParameterException, WCSPException {
        if (null == data) throw new IllegalArgumentException("Argument \"data\" is null");
        if (data.length < 1) {
            throw new IllegalArgumentException("Argument \"data\" is null");
        }
        if (null == this.kmService) throw new IllegalStateException("Service has not been initialized");
        if (null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        if (data.length < 32) {
            try (SymmShortDataEncryptorImpl encryptor = this.coService.getShortDataEncryptor(this.kmService.getSecretKey(this.keyId), null, "ECB", "PKCS7Padding");){
                byte[] byArray = encryptor.encrypt(data);
                return byArray;
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }
        try (SymmShortDataEncryptorImpl encryptor = this.coService.getShortDataEncryptor(this.kmService.getSecretKey(this.keyId), new byte[16], "CBC", "PKCS7Padding");){
            byte[] byArray = encryptor.encrypt(data);
            return byArray;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(byte[] encData) throws InvalidParameterException, WCSPException {
        if (null == encData) throw new IllegalArgumentException("Argument \"encData\" is null");
        if (encData.length < 1) {
            throw new IllegalArgumentException("Argument \"encData\" is null");
        }
        if (null == this.kmService) throw new IllegalStateException("Service has not been initialized");
        if (null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        if (encData.length < 33) {
            try (SymmShortDataDecryptorImpl decryptor = this.coService.getShortDataDecryptor(this.kmService.getSecretKey(this.keyId), null, "ECB", "PKCS7Padding");){
                byte[] byArray = decryptor.decrypt(encData);
                return byArray;
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }
        try (SymmShortDataDecryptorImpl decryptor = this.coService.getShortDataDecryptor(this.kmService.getSecretKey(this.keyId), new byte[16], "CBC", "PKCS7Padding");){
            byte[] byArray = decryptor.decrypt(encData);
            return byArray;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public byte[] encryptDeprecated(byte[] data) throws InvalidParameterException, WCSPException {
        if (null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"data\" is null");
        }
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        try {
            return this.coService.encryptShortData(this.kmService.getSecretKey(this.keyId), new byte[16], "CBC", "PKCS7Padding", data);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public byte[] decryptDeprecated(byte[] encData) throws InvalidParameterException, WCSPException {
        if (null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"encData\" is null");
        }
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        try {
            return this.coService.decryptShortData(this.kmService.getSecretKey(this.keyId), new byte[16], "CBC", "PKCS7Padding", encData);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public String encryptPhoneNumber(String phoneNumber, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEEncryptorImpl fpeEncryptor = null;
        try {
            fpeEncryptor = this.coService.getFPEEncryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeEncryptor) {
            return fpeEncryptor.encryptPhoneNumber(phoneNumber, style);
        }
        return "";
    }

    public String decryptPhoneNumber(String encPhoneNumber, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEDecryptorImpl fpeDecryptor = null;
        try {
            fpeDecryptor = this.coService.getFPEDecryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeDecryptor) {
            return fpeDecryptor.decryptPhoneNumber(encPhoneNumber, style);
        }
        return "";
    }

    public String encryptIDCardNumber(String idCardNumber, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEEncryptorImpl fpeEncryptor = null;
        try {
            fpeEncryptor = this.coService.getFPEEncryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeEncryptor) {
            return fpeEncryptor.encryptIDCardNumber(idCardNumber, style);
        }
        return "";
    }

    public String decryptIDCardNumber(String encIDCardNumber, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEDecryptorImpl fpeDecryptor = null;
        try {
            fpeDecryptor = this.coService.getFPEDecryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeDecryptor) {
            return fpeDecryptor.decryptIDCardNumber(encIDCardNumber, style);
        }
        return "";
    }

    public String encryptBankCardNumber(String bankCardNumber, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEEncryptorImpl fpeEncryptor = null;
        try {
            fpeEncryptor = this.coService.getFPEEncryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeEncryptor) {
            return fpeEncryptor.encryptBankCardNumber(bankCardNumber, style);
        }
        return "";
    }

    public String decryptBankCardNumber(String encBankCardNumber, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEDecryptorImpl fpeDecryptor = null;
        try {
            fpeDecryptor = this.coService.getFPEDecryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeDecryptor) {
            return fpeDecryptor.decryptBankCardNumber(encBankCardNumber, style);
        }
        return "";
    }

    public String encryptIPAddress(String ipAddress, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEEncryptorImpl fpeEncryptor = null;
        try {
            fpeEncryptor = this.coService.getFPEEncryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeEncryptor) {
            return fpeEncryptor.encryptIPAddress(ipAddress, style);
        }
        return "";
    }

    public String decryptIPAddress(String encIPAddress, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEDecryptorImpl fpeDecryptor = null;
        try {
            fpeDecryptor = this.coService.getFPEDecryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeDecryptor) {
            return fpeDecryptor.decryptIPAddress(encIPAddress, style);
        }
        return "";
    }

    public String encryptEmailAddress(String emailAddress, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEEncryptorImpl fpeEncryptor = null;
        try {
            fpeEncryptor = this.coService.getFPEEncryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeEncryptor) {
            return fpeEncryptor.encryptEmailAddress(emailAddress, style);
        }
        return "";
    }

    public String decryptEmailAddress(String encEmailAddress, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEDecryptorImpl fpeDecryptor = null;
        try {
            fpeDecryptor = this.coService.getFPEDecryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeDecryptor) {
            return fpeDecryptor.decryptEmailAddress(encEmailAddress, style);
        }
        return "";
    }

    public String encryptString(String string, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEEncryptorImpl fpeEncryptor = null;
        try {
            fpeEncryptor = this.coService.getFPEEncryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeEncryptor) {
            return fpeEncryptor.encryptString(string, style);
        }
        return "";
    }

    public String decryptString(String encString, int style) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEDecryptorImpl fpeDecryptor = null;
        try {
            fpeDecryptor = this.coService.getFPEDecryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeDecryptor) {
            return fpeDecryptor.decryptString(encString, style);
        }
        return "";
    }

    public int encryptInteger(int integer) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEEncryptorImpl fpeEncryptor = null;
        try {
            fpeEncryptor = this.coService.getFPEEncryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeEncryptor) {
            return fpeEncryptor.encryptInteger(integer);
        }
        return 0;
    }

    public int decryptInteger(int encInteger) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEDecryptorImpl fpeDecryptor = null;
        try {
            fpeDecryptor = this.coService.getFPEDecryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeDecryptor) {
            return fpeDecryptor.decryptInteger(encInteger);
        }
        return 0;
    }

    public double encryptDouble(double doubleP) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEEncryptorImpl fpeEncryptor = null;
        try {
            fpeEncryptor = this.coService.getFPEEncryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeEncryptor) {
            return fpeEncryptor.encryptDouble(doubleP);
        }
        return 0.0;
    }

    public double decryptDouble(double encDouble) throws WCSPException {
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        FPEDecryptorImpl fpeDecryptor = null;
        try {
            fpeDecryptor = this.coService.getFPEDecryptor(this.kmService.getSecretKey(this.keyId));
        }
        catch (InvalidKeyException | InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        if (null != fpeDecryptor) {
            return fpeDecryptor.decryptDouble(encDouble);
        }
        return 0.0;
    }

    public String keyId() {
        return this.keyId;
    }

    @Override
    public String type() {
        return SERVICE_TYPE_LIGHTENCRYPT;
    }

    @Override
    public CryptoServicePlatform platform() {
        return this.platform;
    }

    private LightDataService(PlatformImpl platform, String keyId) {
        this.platform = platform;
        this.keyId = keyId;
    }
}

