/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthAppUserParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.km.KMService;
import cn.com.westone.wcspsdk.baseservice.km.KeyNoUpdateStrategySpec;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import java.util.HashMap;
import java.util.Map;

public class KeyGenerateService
implements CryptoService {
    public static final String SERVICE_TYPE_KEYGENERATE = "KeyGenerate";
    private KMService kmService = null;
    private final PlatformImpl platform;

    public static KeyGenerateService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (platform instanceof PlatformImpl) {
            KeyGenerateService service = new KeyGenerateService((PlatformImpl)platform);
            service.init(new Object[0]);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static KeyGenerateService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        KeyGenerateService service = new KeyGenerateService(platform);
        service.init(new Object[0]);
        return service;
    }

    public static KeyGenerateService getInstance(String tenantId, String appId, Map<String, Object> params, String userId, String authCode) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthAppUserParameterSpec.Builder().setAuthCode(userId, authCode).build());
        KeyGenerateService service = new KeyGenerateService(platform);
        service.init(new Object[0]);
        return service;
    }

    public static KeyGenerateService getInstance(String tenantId, String appId, String secret, String cfgFile) throws InvalidParameterException, WCSPException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cfgFile", cfgFile);
        return KeyGenerateService.getInstance(tenantId, appId, params, secret);
    }

    @Override
    public void init(Object ... args) throws WCSPException {
        if (null == this.kmService) {
            this.kmService = KMService.getInstance(this.platform);
            this.kmService.init(new Object[0]);
        }
    }

    public String generateKeyId() throws WCSPException {
        if (null == this.kmService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        try {
            return this.kmService.createSecretKey("SM4", "ENC", null, null, new KeyNoUpdateStrategySpec.Builder().build()).keyId();
        }
        catch (InvalidParameterException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public String type() {
        return SERVICE_TYPE_KEYGENERATE;
    }

    @Override
    public CryptoServicePlatform platform() {
        return this.platform;
    }

    private KeyGenerateService(PlatformImpl platform) {
        this.platform = platform;
    }
}

