/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthAppUserParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.FileDecryptorImpl;
import cn.com.westone.wcspsdk.impl.co.FileEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.FileTransformEncryptorImpl;
import cn.com.westone.wcspsdk.impl.co.TriStageOperator;
import cn.com.westone.wcspsdk.impl.km.KMSecretKeyImpl;
import cn.com.westone.wcspsdk.impl.km.KMServiceImpl;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class FileSecurityService
implements CryptoService {
    public static final String SERVICE_TYPE_FILESECURITY = "FileSecurity";
    private static final String TEMPLATE_FILE_ENCRYPT_KEY = "TEMPLATE_FILE_ENCRYPT_KEY";
    private KMServiceImpl kmService = null;
    private COServiceImpl coService = null;
    private final PlatformImpl platform;

    public static FileSecurityService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (platform instanceof PlatformImpl) {
            FileSecurityService service = new FileSecurityService((PlatformImpl)platform);
            service.init(new Object[0]);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static FileSecurityService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        FileSecurityService service = new FileSecurityService(platform);
        service.init(new Object[0]);
        return service;
    }

    public static FileSecurityService getInstance(String tenantId, String appId, Map<String, Object> params, String userId, String authCode) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthAppUserParameterSpec.Builder().setAuthCode(userId, authCode).build());
        FileSecurityService service = new FileSecurityService(platform);
        service.init(new Object[0]);
        return service;
    }

    @Override
    public void init(Object ... args) throws WCSPException {
        if (null == this.kmService) {
            this.kmService = KMServiceImpl.getInstance(this.platform);
            this.kmService.init(new Object[0]);
        }
        if (null == this.coService) {
            this.coService = COServiceImpl.getInstance(this.platform);
            this.coService.init(new Object[0]);
            this.coService.verifyPIN(this.platform.useHSM() ? "11111111" : "123456");
        }
    }

    public EncryptedInputStream getEncryptedInputStream(InputStream inputStream) throws WCSPException {
        return this.getEncryptedInputStream(null, inputStream);
    }

    public EncryptedInputStream getEncryptedInputStream(String keyId, InputStream inputStream) throws WCSPException {
        KMSecretKeyImpl kmSecretKey;
        if (null == inputStream) {
            throw new IllegalArgumentException("Argument \"inputStream\" is null");
        }
        if (null == keyId || keyId.isEmpty()) {
            KMSecretKeyImpl[] kmSecretKeys = this.kmService.getSecretKeyList(TEMPLATE_FILE_ENCRYPT_KEY, 1);
            if (null == kmSecretKeys || kmSecretKeys.length == 0) {
                throw new WCSPException("kmSecretKey is null");
            }
            kmSecretKey = kmSecretKeys[0];
        } else {
            kmSecretKey = this.kmService.getSecretKey(keyId);
        }
        try {
            return new EncryptedInputStream(keyId, inputStream, this.coService.getFileEncryptor(kmSecretKey));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public EncryptedOutputStream getEncryptedOutputStream(OutputStream outputStream) throws WCSPException {
        return this.getEncryptedOutputStream(null, outputStream);
    }

    public EncryptedOutputStream getEncryptedOutputStream(String keyId, OutputStream outputStream) throws WCSPException {
        KMSecretKeyImpl kmSecretKey;
        if (null == outputStream) {
            throw new IllegalArgumentException("Argument \"outputStream\" is null");
        }
        if (null == keyId || keyId.isEmpty()) {
            KMSecretKeyImpl[] kmSecretKeys = this.kmService.getSecretKeyList(TEMPLATE_FILE_ENCRYPT_KEY, 1);
            if (null == kmSecretKeys || kmSecretKeys.length == 0) {
                throw new WCSPException("kmSecretKey is null");
            }
            kmSecretKey = kmSecretKeys[0];
        } else {
            kmSecretKey = this.kmService.getSecretKey(keyId);
        }
        try {
            return new EncryptedOutputStream(keyId, outputStream, this.coService.getFileEncryptor(kmSecretKey));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public void encrypt(InputStream inputStream, OutputStream outputStream) throws IOException, WCSPException {
        this.encrypt(null, inputStream, outputStream);
    }

    public void encrypt(String keyId, InputStream inputStream, OutputStream outputStream) throws IOException, WCSPException {
        KMSecretKeyImpl kmSecretKey;
        if (null == inputStream || null == outputStream) {
            throw new IllegalArgumentException("Argument \"inputStream\" or \"outputStream\" is null");
        }
        if (null == keyId || keyId.isEmpty()) {
            KMSecretKeyImpl[] kmSecretKeys = this.kmService.getSecretKeyList(TEMPLATE_FILE_ENCRYPT_KEY, 1);
            if (null == kmSecretKeys || kmSecretKeys.length == 0) {
                throw new WCSPException("kmSecretKey is null");
            }
            kmSecretKey = kmSecretKeys[0];
        } else {
            kmSecretKey = this.kmService.getSecretKey(keyId);
        }
        try (FileEncryptorImpl fileEncryptor = this.coService.getFileEncryptor(kmSecretKey);){
            this.process(inputStream, outputStream, fileEncryptor);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public DecryptedInputStream getDecryptedInputStream(InputStream inputStream) throws WCSPException {
        if (null == inputStream) {
            throw new IllegalArgumentException("Argument \"inputStream\" is null");
        }
        return new DecryptedInputStream(inputStream, this.coService.getFileDecryptor());
    }

    public DecryptedOutputStream getDecryptedOutputStream(OutputStream outputStream) throws WCSPException {
        if (null == outputStream) {
            throw new IllegalArgumentException("Argument \"outputStream\" is null");
        }
        return new DecryptedOutputStream(outputStream, this.coService.getFileDecryptor());
    }

    public void decrypt(InputStream inputStream, OutputStream outputStream) throws IOException, WCSPException {
        if (null == inputStream || null == outputStream) {
            throw new IllegalArgumentException("Argument \"inputStream\" or \"outputStream\" is null");
        }
        try (FileDecryptorImpl fileDecryptor = this.coService.getFileDecryptor();){
            this.process(inputStream, outputStream, fileDecryptor);
        }
    }

    public TransformedInputStream getTransformedInputStream(String transformKeyId, InputStream inputStream) throws WCSPException {
        if (null == transformKeyId || transformKeyId.isEmpty() || null == inputStream) {
            throw new IllegalArgumentException("Argument \"transformKeyId\" or \"inputStream\" is null");
        }
        try {
            return new TransformedInputStream(transformKeyId, inputStream, this.coService.getFileTransformEncryptor(this.kmService.getSecretKey(transformKeyId)));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public TransformedOutputStream getTransformedOutputStream(String transformKeyId, OutputStream outputStream) throws WCSPException {
        if (null == transformKeyId || transformKeyId.isEmpty() || null == outputStream) {
            throw new IllegalArgumentException("Argument \"transformKeyId\" or \"outputStream\" is null");
        }
        try {
            return new TransformedOutputStream(transformKeyId, outputStream, this.coService.getFileTransformEncryptor(this.kmService.getSecretKey(transformKeyId)));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public void transform(String transformKeyId, InputStream inputStream, OutputStream outputStream) throws IOException, WCSPException {
        if (null == transformKeyId || transformKeyId.isEmpty() || null == inputStream || null == outputStream) {
            throw new IllegalArgumentException("Argument \"transformKeyId\" or \"inputStream\" or \"outputStream\" is null");
        }
        try (FileTransformEncryptorImpl fileTransformEncryptor = this.coService.getFileTransformEncryptor(this.kmService.getSecretKey(transformKeyId));){
            this.process(inputStream, outputStream, fileTransformEncryptor);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    @Override
    public String type() {
        return SERVICE_TYPE_FILESECURITY;
    }

    @Override
    public CryptoServicePlatform platform() {
        return this.platform;
    }

    private FileSecurityService(PlatformImpl platform) {
        this.platform = platform;
    }

    private void process(InputStream inputStream, OutputStream outputStream, TriStageOperator fileCipher) throws IOException, WCSPException {
        int inputLength;
        byte[] input = new byte[64512];
        do {
            if (0 == (inputLength = inputStream.read(input))) continue;
            byte[] output = null;
            output = inputLength > 0 ? fileCipher.update(input, 0, inputLength) : fileCipher.doFinal();
            if (output.length <= 0) continue;
            outputStream.write(output, 0, output.length);
        } while (inputLength >= 0);
    }

    private abstract class SecurityOutputStream
    extends FilterOutputStream {
        private final String keyId;
        private final TriStageOperator fileCipher;
        private byte[] cache;
        private int cacheLength;
        private boolean isClose;

        @Override
        public void write(int b) throws IOException {
            if (this.cacheLength + 1 > this.cache.length) {
                this.writeToOut(this.cache, 0, this.cacheLength);
                this.cacheLength = 0;
            }
            this.cache[this.cacheLength++] = (byte)b;
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            if (null == buf) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > buf.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (this.cacheLength + len > this.cache.length) {
                if (this.cacheLength > 0) {
                    this.writeToOut(this.cache, 0, this.cacheLength);
                    this.cacheLength = 0;
                }
                if (len > this.cache.length) {
                    this.writeToOut(buf, off, len);
                    return;
                }
            }
            System.arraycopy(buf, off, this.cache, this.cacheLength, len);
            this.cacheLength += len;
        }

        @Override
        public void flush() throws IOException {
            this.writeToOut(this.cache, 0, this.cacheLength);
            this.cacheLength = 0;
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try (TriStageOperator obj = this.fileCipher;){
                this.isClose = true;
                super.close();
            }
            finally {
                this.cacheLength = 0;
            }
        }

        public String keyId() {
            return this.keyId;
        }

        public FileSecurityService service() {
            return FileSecurityService.this;
        }

        private SecurityOutputStream(String keyId, OutputStream outputStream, TriStageOperator fileCipher) {
            super(outputStream);
            this.cache = new byte[1024];
            this.cacheLength = 0;
            this.isClose = false;
            this.keyId = keyId;
            this.fileCipher = fileCipher;
        }

        private void writeToOut(byte[] buf, int off, int len) throws IOException {
            byte[] output = null;
            try {
                if (this.isClose) {
                    output = len > 0 ? this.fileCipher.doFinal(buf, off, len) : this.fileCipher.doFinal();
                } else if (len > 0) {
                    output = this.fileCipher.update(buf, off, len);
                }
            }
            catch (WCSPException e) {
                throw new IOException("WCSP Exception", e);
            }
            if (null != output && output.length > 0) {
                this.out.write(output, 0, output.length);
            }
        }
    }

    private abstract class SecurityInputStream
    extends FilterInputStream {
        private static final int CACHE_SIZE = 1024;
        private final String keyId;
        private final TriStageOperator fileCipher;
        private byte[] cache;
        private int cacheOffset;
        private int cacheLength;
        private boolean isEnd;

        @Override
        public int read() throws IOException {
            while (true) {
                if (this.cacheLength > 0) {
                    --this.cacheLength;
                    return this.cache[this.cacheOffset++] & 0xFF;
                }
                if (this.isEnd) {
                    return -1;
                }
                this.readFromIn(null, 0, 0);
            }
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (null == buf) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > buf.length) {
                throw new IndexOutOfBoundsException();
            }
            int readLength = 0;
            while (len > 0) {
                if (this.cacheLength >= len) {
                    System.arraycopy(this.cache, this.cacheOffset, buf, off, len);
                    this.cacheOffset += len;
                    this.cacheLength -= len;
                    return readLength + len;
                }
                if (this.cacheLength > 0) {
                    System.arraycopy(this.cache, this.cacheOffset, buf, off, this.cacheLength);
                    readLength += this.cacheLength;
                    off += this.cacheLength;
                    len -= this.cacheLength;
                }
                if (this.isEnd) {
                    this.cacheOffset = 0;
                    this.cacheLength = 0;
                    return readLength > 0 ? readLength : -1;
                }
                int ret = this.readFromIn(buf, off, len);
                readLength += ret;
                off += ret;
                len -= ret;
            }
            return readLength;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n < 0L) {
                throw new IndexOutOfBoundsException();
            }
            int readLength = 0;
            while (n > 0L) {
                if ((long)this.cacheLength >= n) {
                    this.cacheOffset = (int)((long)this.cacheOffset + n);
                    this.cacheLength = (int)((long)this.cacheLength - n);
                    return (long)readLength + n;
                }
                if (this.cacheLength > 0) {
                    readLength += this.cacheLength;
                    n -= (long)this.cacheLength;
                }
                if (this.isEnd) {
                    this.cacheOffset = 0;
                    this.cacheLength = 0;
                    return readLength > 0 ? (long)readLength : -1L;
                }
                this.readFromIn(null, 0, 0);
            }
            return readLength;
        }

        @Override
        public int available() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean markSupported() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try (TriStageOperator obj = this.fileCipher;){
                this.isEnd = true;
                super.close();
            }
            finally {
                this.cacheLength = 0;
            }
        }

        public String keyId() {
            return this.keyId;
        }

        public FileSecurityService service() {
            return FileSecurityService.this;
        }

        private SecurityInputStream(String keyId, InputStream inputStream, TriStageOperator fileCipher) {
            super(inputStream);
            this.cache = new byte[1024];
            this.cacheOffset = 0;
            this.cacheLength = 0;
            this.isEnd = false;
            this.keyId = keyId;
            this.fileCipher = fileCipher;
        }

        private int readFromIn(byte[] buf, int off, int len) throws IOException {
            this.cacheOffset = 0;
            this.cacheLength = 0;
            int inputLength = (Math.max(768, len) + 15) / 16 * 16;
            if (this.cache.length < inputLength) {
                this.cache = new byte[inputLength];
            }
            if (0 == (inputLength = this.in.read(this.cache, 0, inputLength))) {
                return 0;
            }
            byte[] output = null;
            try {
                if (inputLength > 0) {
                    output = this.fileCipher.update(this.cache, 0, inputLength);
                } else {
                    this.isEnd = true;
                    output = this.fileCipher.doFinal();
                }
            }
            catch (WCSPException e) {
                throw new IOException("WCSP Exception", e);
            }
            if (output.length > len) {
                if (output.length > len + this.cache.length) {
                    this.cache = new byte[output.length - len];
                }
                if (len > 0) {
                    System.arraycopy(output, 0, buf, off, len);
                }
                this.cacheLength = output.length - len;
                System.arraycopy(output, len, this.cache, 0, this.cacheLength);
                return len;
            }
            if (output.length > 0) {
                System.arraycopy(output, 0, buf, off, output.length);
            }
            return output.length;
        }
    }

    public class TransformedOutputStream
    extends SecurityOutputStream {
        private TransformedOutputStream(String transformKeyId, OutputStream outputStream, FileTransformEncryptorImpl fileTransformEncryptor) {
            super(transformKeyId, outputStream, fileTransformEncryptor);
        }
    }

    public class TransformedInputStream
    extends SecurityInputStream {
        private TransformedInputStream(String transformKeyId, InputStream inputStream, FileTransformEncryptorImpl fileTransformEncryptor) {
            super(transformKeyId, inputStream, fileTransformEncryptor);
        }
    }

    public class DecryptedOutputStream
    extends SecurityOutputStream {
        private DecryptedOutputStream(OutputStream outputStream, FileDecryptorImpl fileDecryptor) {
            super(null, outputStream, fileDecryptor);
        }
    }

    public class DecryptedInputStream
    extends SecurityInputStream {
        private DecryptedInputStream(InputStream inputStream, FileDecryptorImpl fileDecryptor) {
            super(null, inputStream, fileDecryptor);
        }
    }

    public class EncryptedOutputStream
    extends SecurityOutputStream {
        private EncryptedOutputStream(String keyId, OutputStream outputStream, FileEncryptorImpl fileEncryptor) {
            super(keyId, outputStream, fileEncryptor);
        }
    }

    public class EncryptedInputStream
    extends SecurityInputStream {
        private EncryptedInputStream(String keyId, InputStream inputStream, FileEncryptorImpl fileEncryptor) {
            super(keyId, inputStream, fileEncryptor);
        }
    }
}

