/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthAppUserParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KeyNoUpdateStrategySpec;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.km.KMSecretKeyImpl;
import cn.com.westone.wcspsdk.impl.km.KMServiceImpl;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class E2EEncryptDataService
implements CryptoService {
    public static final String SERVICE_TYPE_E2EENCRYPTSERVICE = "E2EEncrypt";
    private static final byte HEADER_LENGTH = 30;
    private static final byte VERSION = 1;
    private static final byte ALGORITHM = 1;
    private ConcurrentHashMap<String, KMSecretKey> reciptentIdMap = new ConcurrentHashMap();
    private KMServiceImpl kmService = null;
    private COServiceImpl coService = null;
    private final PlatformImpl platform;

    public static E2EEncryptDataService getInstance(CryptoServicePlatform platform) throws WCSPException {
        if (platform instanceof PlatformImpl) {
            E2EEncryptDataService service = new E2EEncryptDataService((PlatformImpl)platform);
            service.init(new Object[0]);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static E2EEncryptDataService getInstance(String tenantId, String appId, Map<String, Object> params, String secret) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        E2EEncryptDataService service = new E2EEncryptDataService(platform);
        service.init(new Object[0]);
        return service;
    }

    public static E2EEncryptDataService getInstance(String tenantId, String appId, Map<String, Object> params, String userId, String authCode) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthAppUserParameterSpec.Builder().setAuthCode(userId, authCode).build());
        E2EEncryptDataService service = new E2EEncryptDataService(platform);
        service.init(new Object[0]);
        return service;
    }

    public static E2EEncryptDataService getInstance(String tenantId, String appId, String secret, String cfgFile) throws InvalidParameterException, WCSPException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cfgFile", cfgFile);
        return E2EEncryptDataService.getInstance(tenantId, appId, params, secret);
    }

    @Override
    public void init(Object ... args) throws WCSPException {
        if (null == this.kmService) {
            this.kmService = KMServiceImpl.getInstance(this.platform);
            this.kmService.init(new Object[0]);
        }
        if (null == this.coService) {
            if (this.platform.isServerSDK()) {
                try {
                    this.coService = COServiceImpl.getInstance("CO-REMOTE", this.platform);
                }
                catch (InvalidParameterException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
                this.coService.init(new Object[0]);
            } else {
                this.coService = COServiceImpl.getInstance(this.platform);
                this.coService.init(new Object[0]);
                this.coService.verifyPIN("123456");
            }
        }
    }

    public String encrypt(String recipientId, String text) throws InvalidParameterException, WCSPException {
        byte[] encData;
        if (null == recipientId || recipientId.isEmpty() || null == text || text.isEmpty()) {
            throw new IllegalArgumentException("Argument \"reciptentId\" or \"text\" is null");
        }
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        if (text.length() > 65519) {
            throw new InvalidParameterException("The plain text is too long");
        }
        KMSecretKey secretKey = this.reciptentIdMap.get(recipientId);
        if (null == secretKey) {
            KMSecretKey secretKeyOld;
            KMSecretKeyImpl[] kmSecretKeys = this.kmService.getSecretKeyList(SERVICE_TYPE_E2EENCRYPTSERVICE + recipientId, 1);
            if (null == kmSecretKeys || kmSecretKeys.length == 0) {
                try {
                    secretKey = this.kmService.createSecretKey("SM4", "ENC", SERVICE_TYPE_E2EENCRYPTSERVICE + recipientId, null, new KeyNoUpdateStrategySpec.Builder().build());
                }
                catch (Exception e) {
                    kmSecretKeys = this.kmService.getSecretKeyList(SERVICE_TYPE_E2EENCRYPTSERVICE + recipientId, 1);
                    if (null != kmSecretKeys && kmSecretKeys.length != 0) {
                        secretKey = kmSecretKeys[0];
                    }
                    throw new WCSPException(e.getMessage());
                }
                if (null != secretKey) {
                    String[] addAuthUserList = new String[]{recipientId};
                    this.kmService.updateKeyAuthority(secretKey.keyId(), addAuthUserList, null);
                }
            } else {
                secretKey = kmSecretKeys[0];
            }
            if (null != (secretKeyOld = this.reciptentIdMap.putIfAbsent(recipientId, secretKey))) {
                secretKey = secretKeyOld;
            }
        }
        if (null == secretKey) {
            throw new RuntimeException("Unexpected exception");
        }
        byte[] iv = this.coService.generateRandom(16);
        try {
            encData = this.coService.encryptShortData(secretKey, iv, "PKCS7Padding", ConversionUtils.Data.fromUTF8String(text));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        ByteBuffer buf = ByteBuffer.allocate(31 + secretKey.keyId().length() - 10 + encData.length);
        buf.put((byte)1);
        buf.put((byte)1);
        buf.put((byte)secretKey.keyId().length());
        buf.put(secretKey.keyId().getBytes(StandardCharsets.US_ASCII));
        buf.put(iv);
        buf.putShort((short)encData.length);
        buf.put(encData);
        return ConversionUtils.Data.toBase64String(buf.array());
    }

    public String decrypt(String encText) throws InvalidParameterException, WCSPException {
        if (null == encText || encText.isEmpty()) {
            throw new IllegalArgumentException("Argument \"encText\" is null");
        }
        if (null == this.kmService || null == this.coService) {
            throw new IllegalStateException("Service has not been initialized");
        }
        ByteBuffer buf = ByteBuffer.wrap(ConversionUtils.Data.fromBase64String(encText));
        if (buf.capacity() <= 30) {
            throw new InvalidParameterException("Invalid enc data");
        }
        switch (buf.getShort()) {
            case 257: {
                return this.decryptV1A1(buf);
            }
            case 513: {
                return this.decryptV2A1(buf);
            }
        }
        throw new InvalidParameterException("Invalid version or algorithm");
    }

    @Override
    public String type() {
        return SERVICE_TYPE_E2EENCRYPTSERVICE;
    }

    @Override
    public CryptoServicePlatform platform() {
        return this.platform;
    }

    private String decryptV1A1(ByteBuffer buf) throws InvalidParameterException, WCSPException {
        byte[] keyIdData = new byte[buf.get()];
        buf.get(keyIdData);
        String keyId = new String(keyIdData, StandardCharsets.US_ASCII);
        byte[] iv = new byte[16];
        buf.get(iv);
        short encDataLength = buf.getShort();
        if (buf.capacity() - 30 + 10 - 1 - keyIdData.length != encDataLength) {
            throw new InvalidParameterException("Invalid enc data");
        }
        byte[] encData = new byte[encDataLength];
        buf.get(encData);
        try {
            return ConversionUtils.Data.toUTF8String(this.coService.decryptShortData(this.kmService.getSecretKey(keyId), iv, "PKCS7Padding", encData));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private String decryptV2A1(ByteBuffer buf) throws InvalidParameterException, WCSPException {
        String keyId = String.format("%x%04x", buf.getLong(), buf.getShort());
        byte[] iv = new byte[16];
        buf.get(iv);
        short encDataLength = buf.getShort();
        if (buf.capacity() - 30 != encDataLength) {
            throw new InvalidParameterException("Invalid enc data");
        }
        byte[] encData = new byte[encDataLength];
        buf.get(encData);
        try {
            return ConversionUtils.Data.toUTF8String(this.coService.decryptShortData(this.kmService.getSecretKey(keyId), iv, "PKCS7Padding", encData));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private E2EEncryptDataService(PlatformImpl platform) {
        this.platform = platform;
    }
}

