/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.typicalservice;

import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoService;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidKeyException;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.co.COServiceImpl;
import cn.com.westone.wcspsdk.impl.co.FileIOCipherImpl;
import cn.com.westone.wcspsdk.impl.km.KMServiceImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DecryptFileOutputService
implements CryptoService {
    public static final String SERVICE_TYPE_DECRYPTFILEOUTPUT = "DecryptFileOutput";
    private KMServiceImpl kmService = null;
    private COServiceImpl coService = null;
    private FileIOCipherImpl fileCipher = null;
    private String keyId = null;
    private String fileName = null;
    private PlatformImpl platform;

    public static DecryptFileOutputService getInstance(CryptoServicePlatform platform, String keyId, String file) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        if (platform instanceof PlatformImpl) {
            DecryptFileOutputService service = new DecryptFileOutputService((PlatformImpl)platform);
            service.init(keyId, file);
            return service;
        }
        throw new UnsupportedOperationException("Unsupport CryptoServicePlatform");
    }

    public static DecryptFileOutputService getInstance(String tenantId, String appId, Map<String, Object> params, String secret, String keyId, String file) throws InvalidParameterException, WCSPException {
        PlatformImpl platform = PlatformImpl.getInstance();
        platform.init(tenantId, appId, params);
        platform.authorize(new AuthSecretParameterSpec.Builder().setSecret(secret).build());
        DecryptFileOutputService service = new DecryptFileOutputService(platform);
        service.init(keyId, file);
        return service;
    }

    public static DecryptFileOutputService getInstance(String tenantId, String appId, String secret, String cfgFile, String keyId, String file) throws InvalidParameterException, WCSPException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cfgFile", cfgFile);
        return DecryptFileOutputService.getInstance(tenantId, appId, params, secret, keyId, file);
    }

    @Override
    public void init(Object ... args) throws WCSPException {
        if (null == args || args.length < 1) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (args.length != 2 || null != args[0] && !(args[0] instanceof String) || null != args[1] && !(args[1] instanceof String)) {
            throw new IllegalArgumentException("Invalid argument");
        }
        if (null == args[0] || ((String)args[0]).isEmpty()) {
            throw new IllegalArgumentException("Argument \"keyId\" is null");
        }
        if (null == args[1] || ((String)args[1]).isEmpty()) {
            throw new IllegalArgumentException("Argument \"fileName\" is null");
        }
        this.keyId = (String)args[0];
        this.fileName = (String)args[1];
        if (null == this.kmService) {
            this.kmService = KMServiceImpl.getInstance(this.platform);
            this.kmService.init(new Object[0]);
        }
        if (null == this.coService) {
            try {
                this.coService = COServiceImpl.getInstance("CO-REMOTE", this.platform);
            }
            catch (InvalidParameterException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
            this.coService.init(new Object[0]);
        }
        if (null != this.fileCipher) {
            this.fileCipher.close();
            this.fileCipher = null;
        }
        try {
            this.fileCipher = this.coService.getFileIOCipher(this.kmService.getSecretKey(this.keyId), this.fileName, FileIOCipherImpl.OPMode.DecryptFileOutput);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public void decryptWrite(byte[] encData) throws WCSPException {
        if (null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"encData\" is null");
        }
        if (null == this.fileCipher) {
            throw new IllegalStateException("Service has not been initialized");
        }
        this.fileCipher.write(encData);
    }

    public void decryptWrite(byte[] srcData, int offset, int length) throws WCSPException {
        if (null == srcData || srcData.length < 1) {
            throw new IllegalArgumentException("Argument \"srcData\" is null");
        }
        if (offset < 0) {
            offset += srcData.length;
        }
        if (offset < 0 || srcData.length <= offset || length < 1 || offset + length > srcData.length) {
            throw new IllegalArgumentException("Argument \"offset\" or \"len\" is illegal");
        }
        if (null == this.fileCipher) {
            throw new IllegalStateException("Service has not been initialized");
        }
        byte[] buf = Arrays.copyOfRange(srcData, offset, offset + length);
        this.fileCipher.write(buf);
    }

    public void doFinal() {
        if (null != this.fileCipher) {
            this.fileCipher.close();
            this.fileCipher = null;
        }
    }

    public String keyId() {
        return this.keyId;
    }

    public String fileName() {
        return this.fileName;
    }

    @Override
    public String type() {
        return SERVICE_TYPE_DECRYPTFILEOUTPUT;
    }

    @Override
    public CryptoServicePlatform platform() {
        return this.platform;
    }

    private DecryptFileOutputService(PlatformImpl platform) {
        this.platform = platform;
    }
}

