/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.km;

import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.co.PublicKey;
import cn.com.westone.wcspsdk.baseservice.km.KMKeyPairImportHelper;
import cn.com.westone.wcspsdk.impl.base.WCSPKM;
import cn.com.westone.wcspsdk.impl.km.KMKeyPairImpl;
import cn.com.westone.wcspsdk.impl.km.KMServiceImpl;

public class KMKeyPairImportHelperImpl
implements KMKeyPairImportHelper {
    private String keyId;
    private String token;
    private PublicKey publicKey;
    private final KMServiceImpl tKmService;

    KMKeyPairImportHelperImpl(long hKMService, String keyId, String token, PublicKey publicKey, KMServiceImpl kmService) {
        this.keyId = keyId;
        this.token = token;
        this.publicKey = publicKey;
        this.tKmService = kmService;
    }

    @Override
    public PublicKey protectionKey() {
        return this.publicKey;
    }

    @Override
    public KMKeyPairImpl importEnvelopedKeyPair(String algorithm, String usage, String alias, String description, int expiryInDays, byte[] envelopedKeyPairData) throws InvalidParameterException, WCSPException {
        int usageId;
        int algorithmId;
        if (null == algorithm || algorithm.isEmpty() || null == usage || usage.isEmpty() || null == envelopedKeyPairData || envelopedKeyPairData.length < 1) {
            throw new IllegalArgumentException("Argument \"algorithm\" or \"usage\" or \"wrappedKeyData\" is null");
        }
        if (expiryInDays < 0 || expiryInDays > 36500) {
            throw new IllegalArgumentException("expiryInDays invalid,it should be 0\uff5e36500");
        }
        if (null == alias) {
            alias = "";
        }
        if (null == description) {
            description = "";
        }
        switch (algorithm) {
            case "SM2": {
                algorithmId = 2;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid algorithm: " + algorithm);
            }
        }
        switch (usage) {
            case "ENC": {
                usageId = 1;
                break;
            }
            default: {
                throw new InvalidParameterException("Invalid usage: " + usage);
            }
        }
        WCSPKM.WCSP_KM_ImportKeyPair(this.tKmService.handle(), this.keyId, this.token, this.publicKey.getKeyData(), algorithmId, usageId, alias, description, expiryInDays, envelopedKeyPairData);
        return new KMKeyPairImpl(this.keyId, usage, algorithm, this.tKmService);
    }
}

