/*
 * Decompiled with CFR 0.152.
 */
package cn.com.westone.wcspsdk.impl.fc;

import cn.com.westone.wcspsdk.WCSPException;
import cn.com.westone.wcspsdk.baseservice.fc.FCService;
import cn.com.westone.wcspsdk.impl.PlatformImpl;
import cn.com.westone.wcspsdk.impl.ServiceImpl;
import cn.com.westone.wcspsdk.impl.base.WCSPFC;

public class FCServiceImpl
extends ServiceImpl
implements FCService {
    public static FCServiceImpl getInstance(PlatformImpl platform) throws WCSPException {
        if (null == platform) {
            throw new IllegalArgumentException("Argument \"platform\" is null");
        }
        return new FCServiceImpl(platform);
    }

    private FCServiceImpl(PlatformImpl platform) throws WCSPException {
        super(8, "FC", platform);
    }

    @Override
    public void init(Object ... args) {
    }

    private int getKeyType(FCService.KeyType keyType) {
        int keyTypeI;
        if (null == keyType) {
            throw new IllegalArgumentException("Argument \"keyType\" is null");
        }
        switch (keyType) {
            case LMK: {
                keyTypeI = 1;
                break;
            }
            case ZMK: {
                keyTypeI = 2;
                break;
            }
            case ZPK: {
                keyTypeI = 4;
                break;
            }
            case ZAK: {
                keyTypeI = 3;
                break;
            }
            case ZEK: {
                keyTypeI = 10;
                break;
            }
            case PVK: {
                keyTypeI = 6;
                break;
            }
            case CVK: {
                keyTypeI = 5;
                break;
            }
            case WWK: {
                keyTypeI = 9;
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument \"keyType\" is Illegal");
            }
        }
        return keyTypeI;
    }

    private int getAlgorithm(FCService.Algorithm algorithm) {
        int algorithmI;
        if (null == algorithm) {
            throw new IllegalArgumentException("Argument \"algorithm\" is null");
        }
        switch (algorithm) {
            case TripleDES: {
                algorithmI = 1;
                break;
            }
            case SM4: {
                algorithmI = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument \"algorithm\" is Illegal");
            }
        }
        return algorithmI;
    }

    private int getAlgorithmMode(FCService.AlgorithmMode algorithmMode) {
        int algorithmModeI;
        if (null == algorithmMode) {
            throw new IllegalArgumentException("Argument \"algorithmMode\" is null");
        }
        switch (algorithmMode) {
            case ECB: {
                algorithmModeI = 0;
                break;
            }
            case CBC: {
                algorithmModeI = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument \"algorithmMode\" is Illegal");
            }
        }
        return algorithmModeI;
    }

    private int getAlgorithmPadding(FCService.AlgorithmPadding algorithmPadding) {
        int algorithmPaddingI;
        if (null == algorithmPadding) {
            throw new IllegalArgumentException("Argument \"algorithmPadding\" is null");
        }
        switch (algorithmPadding) {
            case NOPadding: {
                algorithmPaddingI = 0;
                break;
            }
            case PKCS1Padding: {
                algorithmPaddingI = 1;
                break;
            }
            case PKCS7Padding: {
                algorithmPaddingI = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument \"algorithmPadding\" is Illegal");
            }
        }
        return algorithmPaddingI;
    }

    private int getPINBlockFormat(FCService.PINBlockFormat pinBlockFormat) {
        int pinBlockFormatI;
        if (null == pinBlockFormat) {
            throw new IllegalArgumentException("Argument \"pinBlockFormat\" is null");
        }
        switch (pinBlockFormat) {
            case ANSI98withPAN: {
                pinBlockFormatI = 1;
                break;
            }
            case ANSI98withoutPAN: {
                pinBlockFormatI = 6;
                break;
            }
            case PBOC30: {
                pinBlockFormatI = 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument \"pinBlockFormat\" is Illegal");
            }
        }
        return pinBlockFormatI;
    }

    private int getMACType(FCService.MACType macType) {
        int macTypeI;
        if (null == macType) {
            throw new IllegalArgumentException("Argument \"macType\" is null");
        }
        switch (macType) {
            case ANSI99: {
                macTypeI = 10;
                break;
            }
            case ANSI919: {
                macTypeI = 11;
                break;
            }
            case PBOC30: {
                macTypeI = 12;
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument \"macType\" is Illegal");
            }
        }
        return macTypeI;
    }

    @Override
    public FCService.WrappedKeyDataHolder generateKey(FCService.KeyType keyType, FCService.KeyBits keyBits, String zmkAppId, String zmkNodeId, FCService.Algorithm algorithm) throws WCSPException {
        if (null == zmkAppId || zmkAppId.isEmpty() || null == zmkNodeId || zmkNodeId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"zmkAppId\" or \"zmkNodeId\" is null");
        }
        byte[][] pWrappedKeyDataByLMK = new byte[][]{null};
        byte[][] pWrappedKeyDataByZMK = new byte[][]{null};
        byte[][] pCKV = new byte[][]{null};
        WCSPFC.WCSP_FC_GenerateKey(this.handle(), "", "", this.getKeyType(keyType), keyBits.value, zmkAppId, zmkNodeId, this.getAlgorithm(algorithm), 0, pWrappedKeyDataByLMK, pWrappedKeyDataByZMK, pCKV);
        return new FCService.WrappedKeyDataHolder(pWrappedKeyDataByLMK[0], pWrappedKeyDataByZMK[0], pCKV[0]);
    }

    @Override
    public FCService.WrappedKeyDataHolder generateKey(String appId, String nodeId, FCService.KeyType keyType, FCService.KeyBits keyBits, String zmkAppId, String zmkNodeId, FCService.Algorithm algorithm) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == zmkAppId || zmkAppId.isEmpty() || null == zmkNodeId || zmkNodeId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"zmkAppId\" or \"zmkNodeId\" is null");
        }
        byte[][] pWrappedKeyDataByLMK = new byte[][]{null};
        byte[][] pWrappedKeyDataByZMK = new byte[][]{null};
        byte[][] pCKV = new byte[][]{null};
        WCSPFC.WCSP_FC_GenerateKey(this.handle(), appId, nodeId, this.getKeyType(keyType), keyBits.value, zmkAppId, zmkNodeId, this.getAlgorithm(algorithm), 1, pWrappedKeyDataByLMK, pWrappedKeyDataByZMK, pCKV);
        return new FCService.WrappedKeyDataHolder(pWrappedKeyDataByLMK[0], pWrappedKeyDataByZMK[0], pCKV[0]);
    }

    @Override
    public byte[] importKey(String appId, String nodeId, FCService.KeyType keyType, String zmkAppId, String zmkNodeId, FCService.Algorithm algorithm, byte[] wrappedKeyDataByZMK, byte[] keyCKV) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == zmkAppId || zmkAppId.isEmpty() || null == zmkNodeId || zmkNodeId.isEmpty() || null == wrappedKeyDataByZMK || wrappedKeyDataByZMK.length < 1 || null == keyCKV || keyCKV.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"zmkAppId\" or \"zmkNodeId\" or \"wrappedKeyDataByZMK\" or \"keyCKV\" is null");
        }
        byte[][] pWrappedKeyDataByLMK = new byte[][]{null};
        WCSPFC.WCSP_FC_ImportKey(this.handle(), appId, nodeId, this.getKeyType(keyType), zmkAppId, zmkNodeId, this.getAlgorithm(algorithm), wrappedKeyDataByZMK, keyCKV, pWrappedKeyDataByLMK);
        return pWrappedKeyDataByLMK[0];
    }

    @Override
    public FCService.WrappedKeyDataHolder exportKey(String appId, String nodeId, FCService.KeyType keyType, String zmkAppId, String zmkNodeId, FCService.Algorithm algorithm) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == zmkAppId || zmkAppId.isEmpty() || null == zmkNodeId || zmkNodeId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"zmkAppId\" or \"zmkNodeId\" is null");
        }
        byte[][] pWrappedKeyDataByLMK = new byte[][]{null};
        byte[][] pWrappedKeyDataByZMK = new byte[][]{null};
        byte[][] pCKV = new byte[][]{null};
        WCSPFC.WCSP_FC_ExportKey(this.handle(), appId, nodeId, this.getKeyType(keyType), zmkAppId, zmkNodeId, this.getAlgorithm(algorithm), pWrappedKeyDataByLMK, pWrappedKeyDataByZMK, pCKV);
        return new FCService.WrappedKeyDataHolder(pWrappedKeyDataByLMK[0], pWrappedKeyDataByZMK[0], pCKV[0]);
    }

    @Override
    public byte[] encryptData(String appId, String nodeId, FCService.KeyType keyType, FCService.Algorithm algorithm, FCService.AlgorithmMode algorithmMode, FCService.AlgorithmPadding algorithmPadding, byte[] iv, byte[] data) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"data\" is null");
        }
        if (null == iv) {
            iv = new byte[]{};
        }
        byte[][] pEncData = new byte[][]{null};
        WCSPFC.WCSP_FC_SymmEncrypt(this.handle(), appId, nodeId, this.getKeyType(keyType), this.getAlgorithm(algorithm), this.getAlgorithmMode(algorithmMode), this.getAlgorithmPadding(algorithmPadding), iv, data, pEncData);
        return pEncData[0];
    }

    @Override
    public byte[] decryptData(String appId, String nodeId, FCService.KeyType keyType, FCService.Algorithm algorithm, FCService.AlgorithmMode algorithmMode, FCService.AlgorithmPadding algorithmPadding, byte[] iv, byte[] encData) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"encData\" is null");
        }
        if (null == iv) {
            iv = new byte[]{};
        }
        byte[][] pData = new byte[][]{null};
        WCSPFC.WCSP_FC_SymmDecrypt(this.handle(), appId, nodeId, this.getKeyType(keyType), this.getAlgorithm(algorithm), this.getAlgorithmMode(algorithmMode), this.getAlgorithmPadding(algorithmPadding), iv, encData, pData);
        return pData[0];
    }

    @Override
    public byte[] transformEncryptData(String decAppId, String decNodeId, FCService.KeyType decKeyType, FCService.Algorithm decAlgorithm, FCService.AlgorithmMode decAlgorithmMode, FCService.AlgorithmPadding decAlgorithmPadding, byte[] decIV, String encAppId, String encNodeId, FCService.KeyType encKeyType, FCService.Algorithm encAlgorithm, FCService.AlgorithmMode encAlgorithmMode, FCService.AlgorithmPadding encAlgorithmPadding, byte[] encIV, byte[] encData) throws WCSPException {
        if (null == decAppId || decAppId.isEmpty() || null == decNodeId || decNodeId.isEmpty() || null == encAppId || encAppId.isEmpty() || null == encNodeId || encNodeId.isEmpty() || null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"decAppId\" or \"decNodeId\" or \"encAppId\" or \"encNodeId\" or \"encData\" is null");
        }
        if (null == decIV) {
            decIV = new byte[]{};
        }
        if (null == encIV) {
            encIV = new byte[]{};
        }
        byte[][] pEncData = new byte[][]{null};
        WCSPFC.WCSP_FC_SymmEncryptConvertData(this.handle(), decAppId, decNodeId, this.getKeyType(decKeyType), this.getAlgorithm(decAlgorithm), this.getAlgorithmMode(decAlgorithmMode), this.getAlgorithmPadding(decAlgorithmPadding), decIV, encAppId, encNodeId, this.getKeyType(encKeyType), this.getAlgorithm(encAlgorithm), this.getAlgorithmMode(encAlgorithmMode), this.getAlgorithmPadding(encAlgorithmPadding), encIV, encData, pEncData);
        return pEncData[0];
    }

    @Override
    public byte[] generatePIN(int pinLength, String appId, String nodeId, FCService.Algorithm algorithm, FCService.PINBlockFormat pinBlockFormat, String pan) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" is null");
        }
        if (null == pan) {
            pan = "";
        }
        byte[][] pEncPINBlock = new byte[][]{null};
        WCSPFC.WCSP_FC_GeneratePin(this.handle(), pinLength, appId, nodeId, this.getAlgorithm(algorithm), this.getPINBlockFormat(pinBlockFormat), pan, pEncPINBlock);
        return pEncPINBlock[0];
    }

    @Override
    public byte[] encryptPIN(String appId, String nodeId, FCService.Algorithm algorithm, FCService.PINBlockFormat pinBlockFormat, String pan, String pin) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == pin || pin.isEmpty()) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"pin\" is null");
        }
        if (null == pan) {
            pan = "";
        }
        byte[][] pEncPINBlock = new byte[][]{null};
        WCSPFC.WCSP_FC_EncryptPin(this.handle(), appId, nodeId, this.getAlgorithm(algorithm), this.getPINBlockFormat(pinBlockFormat), pan, pin, pEncPINBlock);
        return pEncPINBlock[0];
    }

    @Override
    public String decryptPIN(String appId, String nodeId, FCService.Algorithm algorithm, FCService.PINBlockFormat pinBlockFormat, String pan, byte[] encPINBlock) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == encPINBlock || encPINBlock.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"encPINBlock\" is null");
        }
        if (null == pan) {
            pan = "";
        }
        String[] pPIN = new String[]{null};
        WCSPFC.WCSP_FC_DecryptPin(this.handle(), appId, nodeId, this.getAlgorithm(algorithm), this.getPINBlockFormat(pinBlockFormat), pan, encPINBlock, pPIN);
        return pPIN[0];
    }

    @Override
    public byte[] transformEncryptPIN(String decAppId, String decNodeId, FCService.Algorithm decAlgorithm, FCService.PINBlockFormat decPINBlockFormat, String decPAN, String encAppId, String encNodeId, FCService.Algorithm encAlgorithm, FCService.PINBlockFormat encPINBlockFormat, String encPAN, byte[] encPINBlock) throws WCSPException {
        if (null == decAppId || decAppId.isEmpty() || null == decNodeId || decNodeId.isEmpty() || null == encAppId || encAppId.isEmpty() || null == encNodeId || encNodeId.isEmpty() || null == encPINBlock || encPINBlock.length < 1) {
            throw new IllegalArgumentException("Argument \"decAppId\" or \"decNodeId\" or \"encAppId\" or \"encNodeId\" or \"encPINBlock\" is null");
        }
        if (null == decPAN) {
            decPAN = "";
        }
        if (null == encPAN) {
            encPAN = "";
        }
        byte[][] pEncPINBlock = new byte[][]{null};
        WCSPFC.WCSP_FC_EncryptConvertPin(this.handle(), decAppId, decNodeId, this.getAlgorithm(decAlgorithm), this.getPINBlockFormat(decPINBlockFormat), decPAN, encAppId, encNodeId, this.getAlgorithm(encAlgorithm), this.getPINBlockFormat(encPINBlockFormat), encPAN, encPINBlock, pEncPINBlock);
        return pEncPINBlock[0];
    }

    @Override
    public byte[] calculatePINOffset(String pvkAppId, String pvkNodeId, String appId, String nodeId, FCService.Algorithm algorithm, FCService.PINBlockFormat pinBlockFormat, String pan, byte[] encPINBlock) throws WCSPException {
        if (null == pvkAppId || pvkAppId.isEmpty() || null == pvkNodeId || pvkNodeId.isEmpty() || null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == encPINBlock || encPINBlock.length < 1) {
            throw new IllegalArgumentException("Argument \"pvkAppId\" or \"pvkNodeId\" or \"appId\" or \"nodeId\" or \"encPINBlock\" is null");
        }
        if (null == pan) {
            pan = "";
        }
        byte[][] pPINOffset = new byte[][]{null};
        WCSPFC.WCSP_FC_GeneratePinOffset(this.handle(), pvkAppId, pvkNodeId, appId, nodeId, this.getAlgorithm(algorithm), this.getPINBlockFormat(pinBlockFormat), pan, encPINBlock, pPINOffset);
        return pPINOffset[0];
    }

    @Override
    public byte[] recalculatePINOffset(String pvkAppId, String pvkNodeId, String appId, String nodeId, FCService.Algorithm algorithm, FCService.PINBlockFormat pinBlockFormat, String pan, byte[] oldEncPINBlock, byte[] oldPINOffset, byte[] newEncPINBlock) throws WCSPException {
        if (null == pvkAppId || pvkAppId.isEmpty() || null == pvkNodeId || pvkNodeId.isEmpty() || null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == oldEncPINBlock || oldEncPINBlock.length < 1 || null == oldPINOffset || oldPINOffset.length < 1 || null == newEncPINBlock || newEncPINBlock.length < 1) {
            throw new IllegalArgumentException("Argument \"pvkAppId\" or \"pvkNodeId\" or \"appId\" or \"nodeId\" or \"oldEncPINBlock\"  or \"oldPINOffset\" or \"newEncPINBlock\" is null");
        }
        if (null == pan) {
            pan = "";
        }
        byte[][] pNewPINOffset = new byte[][]{null};
        WCSPFC.WCSP_FC_ChangePin(this.handle(), pvkAppId, pvkNodeId, appId, nodeId, this.getAlgorithm(algorithm), this.getPINBlockFormat(pinBlockFormat), pan, oldEncPINBlock, oldPINOffset, newEncPINBlock, pNewPINOffset);
        return pNewPINOffset[0];
    }

    @Override
    public boolean verifyPINOffset(String pvkAppId, String pvkNodeId, String appId, String nodeId, FCService.Algorithm algorithm, FCService.PINBlockFormat pinBlockFormat, String pan, byte[] encPINBlock, byte[] pinOffset) throws WCSPException {
        if (null == pvkAppId || pvkAppId.isEmpty() || null == pvkNodeId || pvkNodeId.isEmpty() || null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == encPINBlock || encPINBlock.length < 1 || null == pinOffset || pinOffset.length < 1) {
            throw new IllegalArgumentException("Argument \"pvkAppId\" or \"pvkNodeId\" or \"appId\" or \"nodeId\" or \"encPINBlock\" or \"pinOffset\" is null");
        }
        if (null == pan) {
            pan = "";
        }
        int[] pResult = new int[]{0};
        WCSPFC.WCSP_FC_VerifyPin(this.handle(), pvkAppId, pvkNodeId, appId, nodeId, this.getAlgorithm(algorithm), this.getPINBlockFormat(pinBlockFormat), pan, encPINBlock, pinOffset, pResult);
        return pResult[0] == 1;
    }

    @Override
    public boolean checkWeakPIN(String appId, String nodeId, FCService.Algorithm algorithm, FCService.PINBlockFormat pinBlockFormat, String pan, byte[] encPINBlock, String[] checkWords) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == encPINBlock || encPINBlock.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"encPINBlock\" is null");
        }
        if (null == pan) {
            pan = "";
        }
        int[] pResult = new int[]{0};
        StringBuilder stringBuilder = new StringBuilder();
        if (null != checkWords) {
            for (int i = 1; i <= checkWords.length; ++i) {
                stringBuilder.append("00").append(i).append(":").append(checkWords[i - 1]).append("|");
            }
        }
        WCSPFC.WCSP_FC_CheckPin(this.handle(), appId, nodeId, this.getAlgorithm(algorithm), this.getPINBlockFormat(pinBlockFormat), pan, encPINBlock, stringBuilder.toString(), pResult);
        return pResult[0] == 1;
    }

    @Override
    public byte[] calculateMAC(String appId, String nodeId, FCService.Algorithm algorithm, FCService.MACType macType, byte[] iv, byte[] data) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == iv || iv.length < 1 || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"iv\" or \"data\" is null");
        }
        byte[][] pMacData = new byte[][]{null};
        WCSPFC.WCSP_FC_GenerateMac(this.handle(), appId, nodeId, this.getAlgorithm(algorithm), this.getMACType(macType), iv, data, pMacData);
        return pMacData[0];
    }

    @Override
    public boolean verifyMAC(String appId, String nodeId, FCService.Algorithm algorithm, FCService.MACType macType, byte[] iv, byte[] data, byte[] macData) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == iv || iv.length < 1 || null == data || data.length < 1 || null == macData || macData.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"iv\" or \"data\" or \"macData\" is null");
        }
        int[] pResult = new int[]{0};
        WCSPFC.WCSP_FC_VerifyMac(this.handle(), appId, nodeId, this.getAlgorithm(algorithm), this.getMACType(macType), iv, data, macData, pResult);
        return pResult[0] == 1;
    }

    @Override
    public byte[] hash(FCService.Algorithm algorithm, byte[] data) throws WCSPException {
        if (null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"data\" is null");
        }
        if (null == algorithm) {
            throw new IllegalArgumentException("Argument \"algorithm\" is null");
        }
        byte[][] pHashData = new byte[][]{null};
        switch (algorithm) {
            case SHA1: {
                WCSPFC.WCSP_FC_HashSha1(this.handle(), data, pHashData);
                break;
            }
            case SHA256: {
                WCSPFC.WCSP_FC_HashSha256(this.handle(), data, pHashData);
                break;
            }
            case MD5: {
                WCSPFC.WCSP_FC_HashMd5(this.handle(), data, pHashData);
                break;
            }
            case SM3: {
                WCSPFC.WCSP_FC_HashSm3(this.handle(), data, pHashData);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument \"macType\" is Illegal");
            }
        }
        return pHashData[0];
    }

    @Override
    public byte[] hashSM2Preprocess(String appId, String nodeId, byte[] data) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"data\" is null");
        }
        byte[][] pHashData = new byte[][]{null};
        WCSPFC.WCSP_FC_HashSm2(this.handle(), appId, nodeId, data, pHashData);
        return pHashData[0];
    }

    @Override
    public byte[] generateKeyPairSM2(String appId, String nodeId) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" is null");
        }
        byte[][] pPublicKeyData = new byte[][]{null};
        WCSPFC.WCSP_FC_GenerateKeyPairSm2(this.handle(), appId, nodeId, pPublicKeyData);
        return pPublicKeyData[0];
    }

    @Override
    public byte[] encryptDataSM2(String appId, String nodeId, byte[] data) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"data\" is null");
        }
        byte[][] pEncData = new byte[][]{null};
        WCSPFC.WCSP_FC_EncryptSm2(this.handle(), appId, nodeId, data, pEncData);
        return pEncData[0];
    }

    @Override
    public byte[] decryptDataSM2(String appId, String nodeId, byte[] encData) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"encData\" is null");
        }
        byte[][] pData = new byte[][]{null};
        WCSPFC.WCSP_FC_DecryptSm2(this.handle(), appId, nodeId, encData, pData);
        return pData[0];
    }

    @Override
    public byte[] signHashSM2(String appId, String nodeId, byte[] hashData) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == hashData || hashData.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"hashData\" is null");
        }
        byte[][] pSignatureData = new byte[][]{null};
        WCSPFC.WCSP_FC_SignSm2(this.handle(), appId, nodeId, hashData, pSignatureData);
        return pSignatureData[0];
    }

    @Override
    public boolean verifyHashSM2(String appId, String nodeId, byte[] hashData, byte[] signatureData) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == hashData || hashData.length < 1 || null == signatureData || signatureData.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"hashData\" or \"signatureData\" is null");
        }
        int[] pResult = new int[]{0};
        WCSPFC.WCSP_FC_VerifySm2(this.handle(), appId, nodeId, hashData, signatureData, pResult);
        return pResult[0] == 1;
    }

    @Override
    public byte[] exportPublicKeySM2(String appId, String nodeId) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" is null");
        }
        byte[][] pPublicKeyData = new byte[][]{null};
        WCSPFC.WCSP_FC_ExportPublicKeySm2(this.handle(), appId, nodeId, pPublicKeyData);
        return pPublicKeyData[0];
    }

    @Override
    public byte[] generateKeyPairRSA(String appId, String nodeId, FCService.KeyBits keyBits, FCService.RSAExponent exponent) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" is null");
        }
        byte[][] pPublicKeyData = new byte[][]{null};
        WCSPFC.WCSP_FC_GenerateKeyPairRsa(this.handle(), appId, nodeId, keyBits.value, exponent.value, pPublicKeyData);
        return pPublicKeyData[0];
    }

    @Override
    public byte[] encryptDataRSA(String appId, String nodeId, FCService.AlgorithmPadding algorithmPadding, byte[] data) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == data || data.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"data\" is null");
        }
        byte[][] pEncData = new byte[][]{null};
        WCSPFC.WCSP_FC_EncryptRsa(this.handle(), appId, nodeId, this.getAlgorithmPadding(algorithmPadding), data, pEncData);
        return pEncData[0];
    }

    @Override
    public byte[] decryptDataRSA(String appId, String nodeId, FCService.AlgorithmPadding algorithmPadding, byte[] encData) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == encData || encData.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"encData\" is null");
        }
        byte[][] pData = new byte[][]{null};
        WCSPFC.WCSP_FC_DecryptRsa(this.handle(), appId, nodeId, this.getAlgorithmPadding(algorithmPadding), encData, pData);
        return pData[0];
    }

    @Override
    public byte[] signHashRSA(String appId, String nodeId, byte[] hashData) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == hashData || hashData.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"hashData\" is null");
        }
        byte[][] pSignatureData = new byte[][]{null};
        WCSPFC.WCSP_FC_SignRsa(this.handle(), appId, nodeId, hashData, pSignatureData);
        return pSignatureData[0];
    }

    @Override
    public boolean verifyHashRSA(String appId, String nodeId, byte[] hashData, byte[] signatureData) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty() || null == hashData || hashData.length < 1 || null == signatureData || signatureData.length < 1) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" or \"hashData\" or \"signatureData\" is null");
        }
        int[] pResult = new int[]{0};
        WCSPFC.WCSP_FC_VerifyRsa(this.handle(), appId, nodeId, hashData, signatureData, pResult);
        return pResult[0] == 1;
    }

    @Override
    public byte[] exportPublicKeyRSA(String appId, String nodeId) throws WCSPException {
        if (null == appId || appId.isEmpty() || null == nodeId || nodeId.isEmpty()) {
            throw new IllegalArgumentException("Argument \"appId\" or \"nodeId\" is null");
        }
        byte[][] pPublicKeyData = new byte[][]{null};
        WCSPFC.WCSP_FC_ExportPublicKeyRsa(this.handle(), appId, nodeId, pPublicKeyData);
        return pPublicKeyData[0];
    }
}

